/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.rds.DatabaseProxyOptions;
import software.amazon.awscdk.services.rds.DatabaseProxyProps;
import software.amazon.awscdk.services.rds.ProxyTarget;
import software.amazon.awscdk.services.rds.SessionPinningFilter;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.DatabaseProxyProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DatabaseProxyProps
extends JsiiSerializable,
DatabaseProxyOptions {
    @NotNull
    public ProxyTarget getProxyTarget();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseProxyProps> {
        private ProxyTarget proxyTarget;
        private List<ISecret> secrets;
        private IVpc vpc;
        private Duration borrowTimeout;
        private String dbProxyName;
        private Boolean debugLogging;
        private Boolean iamAuth;
        private Duration idleClientTimeout;
        private String initQuery;
        private Number maxConnectionsPercent;
        private Number maxIdleConnectionsPercent;
        private Boolean requireTls;
        private IRole role;
        private List<ISecurityGroup> securityGroups;
        private List<SessionPinningFilter> sessionPinningFilters;
        private SubnetSelection vpcSubnets;

        public Builder proxyTarget(ProxyTarget proxyTarget) {
            this.proxyTarget = proxyTarget;
            return this;
        }

        public Builder secrets(List<? extends ISecret> secrets) {
            this.secrets = secrets;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder borrowTimeout(Duration borrowTimeout) {
            this.borrowTimeout = borrowTimeout;
            return this;
        }

        public Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public Builder debugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        public Builder iamAuth(Boolean iamAuth) {
            this.iamAuth = iamAuth;
            return this;
        }

        public Builder idleClientTimeout(Duration idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        public Builder initQuery(String initQuery) {
            this.initQuery = initQuery;
            return this;
        }

        public Builder maxConnectionsPercent(Number maxConnectionsPercent) {
            this.maxConnectionsPercent = maxConnectionsPercent;
            return this;
        }

        public Builder maxIdleConnectionsPercent(Number maxIdleConnectionsPercent) {
            this.maxIdleConnectionsPercent = maxIdleConnectionsPercent;
            return this;
        }

        public Builder requireTls(Boolean requireTls) {
            this.requireTls = requireTls;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder sessionPinningFilters(List<? extends SessionPinningFilter> sessionPinningFilters) {
            this.sessionPinningFilters = sessionPinningFilters;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public DatabaseProxyProps build() {
            return new Jsii.Proxy(this.proxyTarget, this.secrets, this.vpc, this.borrowTimeout, this.dbProxyName, this.debugLogging, this.iamAuth, this.idleClientTimeout, this.initQuery, this.maxConnectionsPercent, this.maxIdleConnectionsPercent, this.requireTls, this.role, this.securityGroups, this.sessionPinningFilters, this.vpcSubnets);
        }
    }
}

