/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.transfer.CfnUser;
import software.amazon.awscdk.services.transfer.CfnUserProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnUser")
public class CfnUser
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnUser.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnUser(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUser(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnUser(@NotNull Construct scope, @NotNull String id, @NotNull CfnUserProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrServerId() {
        return (String)Kernel.get((Object)this, (String)"attrServerId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUserName() {
        return (String)Kernel.get((Object)this, (String)"attrUserName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getRole() {
        return (String)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(String.class));
    }

    public void setRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"role", (Object)Objects.requireNonNull(value, "role is required"));
    }

    @NotNull
    public String getServerId() {
        return (String)Kernel.get((Object)this, (String)"serverId", (NativeType)NativeType.forClass(String.class));
    }

    public void setServerId(@NotNull String value) {
        Kernel.set((Object)this, (String)"serverId", (Object)Objects.requireNonNull(value, "serverId is required"));
    }

    @NotNull
    public String getUserName() {
        return (String)Kernel.get((Object)this, (String)"userName", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserName(@NotNull String value) {
        Kernel.set((Object)this, (String)"userName", (Object)Objects.requireNonNull(value, "userName is required"));
    }

    @Nullable
    public String getHomeDirectory() {
        return (String)Kernel.get((Object)this, (String)"homeDirectory", (NativeType)NativeType.forClass(String.class));
    }

    public void setHomeDirectory(@Nullable String value) {
        Kernel.set((Object)this, (String)"homeDirectory", (Object)value);
    }

    @Nullable
    public Object getHomeDirectoryMappings() {
        return Kernel.get((Object)this, (String)"homeDirectoryMappings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHomeDirectoryMappings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"homeDirectoryMappings", (Object)value);
    }

    public void setHomeDirectoryMappings(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"homeDirectoryMappings", value);
    }

    @Nullable
    public String getHomeDirectoryType() {
        return (String)Kernel.get((Object)this, (String)"homeDirectoryType", (NativeType)NativeType.forClass(String.class));
    }

    public void setHomeDirectoryType(@Nullable String value) {
        Kernel.set((Object)this, (String)"homeDirectoryType", (Object)value);
    }

    @Nullable
    public String getPolicy() {
        return (String)Kernel.get((Object)this, (String)"policy", (NativeType)NativeType.forClass(String.class));
    }

    public void setPolicy(@Nullable String value) {
        Kernel.set((Object)this, (String)"policy", (Object)value);
    }

    @Nullable
    public Object getPosixProfile() {
        return Kernel.get((Object)this, (String)"posixProfile", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPosixProfile(@Nullable PosixProfileProperty value) {
        Kernel.set((Object)this, (String)"posixProfile", (Object)value);
    }

    public void setPosixProfile(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"posixProfile", (Object)value);
    }

    @Nullable
    public List<String> getSshPublicKeys() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"sshPublicKeys", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSshPublicKeys(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"sshPublicKeys", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnUser> {
        private final Construct scope;
        private final String id;
        private final CfnUserProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnUserProps.Builder();
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder serverId(String serverId) {
            this.props.serverId(serverId);
            return this;
        }

        public Builder userName(String userName) {
            this.props.userName(userName);
            return this;
        }

        public Builder homeDirectory(String homeDirectory) {
            this.props.homeDirectory(homeDirectory);
            return this;
        }

        public Builder homeDirectoryMappings(IResolvable homeDirectoryMappings) {
            this.props.homeDirectoryMappings(homeDirectoryMappings);
            return this;
        }

        public Builder homeDirectoryMappings(List<? extends Object> homeDirectoryMappings) {
            this.props.homeDirectoryMappings(homeDirectoryMappings);
            return this;
        }

        public Builder homeDirectoryType(String homeDirectoryType) {
            this.props.homeDirectoryType(homeDirectoryType);
            return this;
        }

        public Builder policy(String policy) {
            this.props.policy(policy);
            return this;
        }

        public Builder posixProfile(PosixProfileProperty posixProfile) {
            this.props.posixProfile(posixProfile);
            return this;
        }

        public Builder posixProfile(IResolvable posixProfile) {
            this.props.posixProfile(posixProfile);
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.props.sshPublicKeys(sshPublicKeys);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnUser build() {
            return new CfnUser(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnUser.PosixProfileProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PosixProfileProperty
    extends JsiiSerializable {
        @NotNull
        public Number getGid();

        @NotNull
        public Number getUid();

        @Nullable
        default public Object getSecondaryGids() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PosixProfileProperty> {
            private Number gid;
            private Number uid;
            private Object secondaryGids;

            public Builder gid(Number gid) {
                this.gid = gid;
                return this;
            }

            public Builder uid(Number uid) {
                this.uid = uid;
                return this;
            }

            public Builder secondaryGids(IResolvable secondaryGids) {
                this.secondaryGids = secondaryGids;
                return this;
            }

            public Builder secondaryGids(List<? extends Number> secondaryGids) {
                this.secondaryGids = secondaryGids;
                return this;
            }

            public PosixProfileProperty build() {
                return new Jsii.Proxy(this.gid, this.uid, this.secondaryGids);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnUser.HomeDirectoryMapEntryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HomeDirectoryMapEntryProperty
    extends JsiiSerializable {
        @NotNull
        public String getEntry();

        @NotNull
        public String getTarget();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HomeDirectoryMapEntryProperty> {
            private String entry;
            private String target;

            public Builder entry(String entry) {
                this.entry = entry;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public HomeDirectoryMapEntryProperty build() {
                return new Jsii.Proxy(this.entry, this.target);
            }
        }
    }
}

