package software.amazon.awscdk;

/**
 * (experimental) The location of the published file asset.
 * <p>
 * This is where the asset
 * can be consumed at runtime.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:54:53.135Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.FileAssetLocation")
@software.amazon.jsii.Jsii.Proxy(FileAssetLocation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FileAssetLocation extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name of the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * (experimental) The HTTP URL of this asset on Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpUrl();

    /**
     * (experimental) The Amazon S3 object key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

    /**
     * (experimental) The S3 URL of this asset on Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * s3:}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectUrl();

    /**
     * @return a {@link Builder} of {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FileAssetLocation> {
        private java.lang.String bucketName;
        private java.lang.String httpUrl;
        private java.lang.String objectKey;
        private java.lang.String s3ObjectUrl;

        /**
         * Sets the value of {@link FileAssetLocation#getBucketName}
         * @param bucketName The name of the Amazon S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getHttpUrl}
         * @param httpUrl The HTTP URL of this asset on Amazon S3. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpUrl(java.lang.String httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getObjectKey}
         * @param objectKey The Amazon S3 object key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder objectKey(java.lang.String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getS3ObjectUrl}
         * @param s3ObjectUrl The S3 URL of this asset on Amazon S3. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3ObjectUrl(java.lang.String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAssetLocation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FileAssetLocation build() {
            return new Jsii$Proxy(bucketName, httpUrl, objectKey, s3ObjectUrl);
        }
    }

    /**
     * An implementation for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAssetLocation {
        private final java.lang.String bucketName;
        private final java.lang.String httpUrl;
        private final java.lang.String objectKey;
        private final java.lang.String s3ObjectUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpUrl = software.amazon.jsii.Kernel.get(this, "httpUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectKey = software.amazon.jsii.Kernel.get(this, "objectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3ObjectUrl = software.amazon.jsii.Kernel.get(this, "s3ObjectUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String bucketName, final java.lang.String httpUrl, final java.lang.String objectKey, final java.lang.String s3ObjectUrl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(bucketName, "bucketName is required");
            this.httpUrl = java.util.Objects.requireNonNull(httpUrl, "httpUrl is required");
            this.objectKey = java.util.Objects.requireNonNull(objectKey, "objectKey is required");
            this.s3ObjectUrl = java.util.Objects.requireNonNull(s3ObjectUrl, "s3ObjectUrl is required");
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.String getHttpUrl() {
            return this.httpUrl;
        }

        @Override
        public final java.lang.String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public final java.lang.String getS3ObjectUrl() {
            return this.s3ObjectUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucketName", om.valueToTree(this.getBucketName()));
            data.set("httpUrl", om.valueToTree(this.getHttpUrl()));
            data.set("objectKey", om.valueToTree(this.getObjectKey()));
            data.set("s3ObjectUrl", om.valueToTree(this.getS3ObjectUrl()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.FileAssetLocation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileAssetLocation.Jsii$Proxy that = (FileAssetLocation.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            if (!httpUrl.equals(that.httpUrl)) return false;
            if (!objectKey.equals(that.objectKey)) return false;
            return this.s3ObjectUrl.equals(that.s3ObjectUrl);
        }

        @Override
        public final int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.httpUrl.hashCode());
            result = 31 * result + (this.objectKey.hashCode());
            result = 31 * result + (this.s3ObjectUrl.hashCode());
            return result;
        }
    }
}
