package software.amazon.awscdk;

/**
 * (experimental) Work with secret values in the CDK.
 * <p>
 * Secret values in the CDK (such as those retrieved from SecretsManager) are
 * represented as regular strings, just like other values that are only
 * available at deployment time.
 * <p>
 * To help you avoid accidental mistakes which would lead to you putting your
 * secret values directly into a CloudFormation template, constructs that take
 * secret values will not allow you to pass in a literal secret value. They do
 * so by calling <code>Secret.assertSafeSecret()</code>.
 * <p>
 * You can escape the check by calling <code>Secret.plainText()</code>, but doing
 * so is highly discouraged.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:54:55.596Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.SecretValue")
public class SecretValue extends software.amazon.awscdk.Intrinsic {

    protected SecretValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IntrinsicProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value, options });
    }

    /**
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value });
    }

    /**
     * (experimental) Obtain the secret value through a CloudFormation dynamic reference.
     * <p>
     * If possible, use <code>SecretValue.ssmSecure</code> or <code>SecretValue.secretsManager</code> directly.
     * <p>
     * @param ref The dynamic reference to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue cfnDynamicReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnDynamicReference ref) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "cfnDynamicReference", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(ref, "ref is required") });
    }

    /**
     * (experimental) Obtain the secret value through a CloudFormation parameter.
     * <p>
     * Generally, this is not a recommended approach. AWS Secrets Manager is the
     * recommended way to reference secrets.
     * <p>
     * @param param The CloudFormation parameter to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue cfnParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnParameter param) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "cfnParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(param, "param is required") });
    }

    /**
     * (experimental) Construct a literal secret value for use with secret-aware constructs.
     * <p>
     * <em>Do not use this method for any secrets that you care about.</em>
     * <p>
     * The only reasonable use case for using this method is when you are testing.
     * <p>
     * @param secret This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue plainText(final @org.jetbrains.annotations.NotNull java.lang.String secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "plainText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * (experimental) Creates a `SecretValue` with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretsManagerSecretOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "secretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required"), options });
    }

    /**
     * (experimental) Creates a `SecretValue` with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "secretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required") });
    }

    /**
     * (experimental) Use a secret value stored from a Systems Manager (SSM) parameter.
     * <p>
     * @param parameterName The name of the parameter in the Systems Manager Parameter Store. This parameter is required.
     * @param version An integer that specifies the version of the parameter to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue ssmSecure(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.SecretValue.class, "ssmSecure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.SecretValue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.SecretValue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param value This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.Object value) {
            return new Builder(value);
        }

        private final java.lang.Object value;
        private software.amazon.awscdk.IntrinsicProps.Builder options;

        private Builder(final java.lang.Object value) {
            this.value = value;
        }

        /**
         * (experimental) Capture the stack trace of where this token is created.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param stackTrace Capture the stack trace of where this token is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackTrace(final java.lang.Boolean stackTrace) {
            this.options().stackTrace(stackTrace);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.SecretValue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.SecretValue build() {
            return new software.amazon.awscdk.SecretValue(
                this.value,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.IntrinsicProps.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.IntrinsicProps.Builder();
            }
            return this.options;
        }
    }
}
