/**
 * <h1>AWS::ACMPCA Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_acmpca;
 * </pre></blockquote>
 * <p>
 * <h2>Certificate Authority</h2>
 * <p>
 * This package contains a <code>CertificateAuthority</code> class.
 * At the moment, you cannot create new Authorities using it,
 * but you can import existing ones using the <code>fromCertificateAuthorityArn</code> static method:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object certificateAuthority = acmpca.CertificateAuthority.fromCertificateAuthorityArn(this, "CA", "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/023077d8-2bfa-4eb0-8f22-05c96deade77");
 * </pre></blockquote>
 * <p>
 * <h2>Low-level <code>Cfn*</code> classes</h2>
 * <p>
 * You can always use the low-level classes
 * (starting with <code>Cfn*</code>) to create resources like the Certificate Authority:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object cfnCertificateAuthority = CfnCertificateAuthority.Builder.create(this, "CA")
 *         .type("ROOT")
 *         .keyAlgorithm("RSA_2048")
 *         .signingAlgorithm("SHA256WITHRSA")
 *         .subject(Map.of(
 *                 "country", "US",
 *                 "organization", "string",
 *                 "organizationalUnit", "string",
 *                 "distinguishedNameQualifier", "string",
 *                 "state", "string",
 *                 "commonName", "123",
 *                 "serialNumber", "string",
 *                 "locality", "string",
 *                 "title", "string",
 *                 "surname", "string",
 *                 "givenName", "string",
 *                 "initials", "DG",
 *                 "pseudonym", "string",
 *                 "generationQualifier", "DBG"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If you need to pass the higher-level <code>ICertificateAuthority</code> somewhere,
 * you can get it from the lower-level <code>CfnCertificateAuthority</code> using the same <code>fromCertificateAuthorityArn</code> method:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object certificateAuthority = acmpca.CertificateAuthority.fromCertificateAuthorityArn(this, "CertificateAuthority", cfnCertificateAuthority.getAttrArn());
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.acmpca;
