/**
 * <h1>AWS Auto Scaling Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <strong>Application AutoScaling</strong> is used to configure autoscaling for all
 * services other than scaling EC2 instances. For example, you will use this to
 * scale ECS tasks, DynamoDB capacity, Spot Fleet sizes, Comprehend document classification endpoints, Lambda function provisioned concurrency and more.
 * <p>
 * As a CDK user, you will probably not have to interact with this library
 * directly; instead, it will be used by other construct libraries to
 * offer AutoScaling features for their own constructs.
 * <p>
 * This document will describe the general autoscaling features and concepts;
 * your particular service may offer only a subset of these.
 * <p>
 * <h2>AutoScaling basics</h2>
 * <p>
 * Resources can offer one or more <strong>attributes</strong> to autoscale, typically
 * representing some capacity dimension of the underlying service. For example,
 * a DynamoDB Table offers autoscaling of the read and write capacity of the
 * table proper and its Global Secondary Indexes, an ECS Service offers
 * autoscaling of its task count, an RDS Aurora cluster offers scaling of its
 * replica count, and so on.
 * <p>
 * When you enable autoscaling for an attribute, you specify a minimum and a
 * maximum value for the capacity. AutoScaling policies that respond to metrics
 * will never go higher or lower than the indicated capacity (but scheduled
 * scaling actions might, see below).
 * <p>
 * There are three ways to scale your capacity:
 * <p>
 * <ul>
 * <li><strong>In response to a metric</strong> (also known as step scaling); for example, you
 * might want to scale out if the CPU usage across your cluster starts to rise,
 * and scale in when it drops again.</li>
 * <li><strong>By trying to keep a certain metric around a given value</strong> (also known as
 * target tracking scaling); you might want to automatically scale out an in to
 * keep your CPU usage around 50%.</li>
 * <li><strong>On a schedule</strong>; you might want to organize your scaling around traffic
 * flows you expect, by scaling out in the morning and scaling in in the
 * evening.</li>
 * </ul>
 * <p>
 * The general pattern of autoscaling will look like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object capacity = resource.autoScaleCapacity(Map.of(
 *         "minCapacity", 5,
 *         "maxCapacity", 100));
 * 
 * // Enable a type of metric scaling and/or schedule scaling
 * capacity.scaleOnMetric(...);
 * capacity.scaleToTrackMetric(...);
 * capacity.scaleOnSchedule(...);
 * </pre></blockquote>
 * <p>
 * <h2>Step Scaling</h2>
 * <p>
 * This type of scaling scales in and out in deterministic steps that you
 * configure, in response to metric values. For example, your scaling strategy
 * to scale in response to CPU usage might look like this:
 * <p>
 * <blockquote><pre>
 *  Scaling        -1          (no change)          +1       +3
 *             │        │                       │        │        │
 *             ├────────┼───────────────────────┼────────┼────────┤
 *             │        │                       │        │        │
 * CPU usage   0%      10%                     50%       70%     100%
 * </pre></blockquote>
 * <p>
 * (Note that this is not necessarily a recommended scaling strategy, but it's
 * a possible one. You will have to determine what thresholds are right for you).
 * <p>
 * You would configure it like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * capacity.scaleOnMetric("ScaleToCPU", Map.of(
 *         "metric", service.metricCpuUtilization(),
 *         "scalingSteps", asList(Map.of("upper", 10, "change", -1), Map.of("lower", 50, "change", +1), Map.of("lower", 70, "change", +3)),
 * 
 *         // Change this to AdjustmentType.PercentChangeInCapacity to interpret the
 *         // 'change' numbers before as percentages instead of capacity counts.
 *         "adjustmentType", autoscaling.AdjustmentType.getCHANGE_IN_CAPACITY()));
 * </pre></blockquote>
 * <p>
 * The AutoScaling construct library will create the required CloudWatch alarms and
 * AutoScaling policies for you.
 * <p>
 * <h2>Target Tracking Scaling</h2>
 * <p>
 * This type of scaling scales in and out in order to keep a metric (typically
 * representing utilization) around a value you prefer. This type of scaling is
 * typically heavily service-dependent in what metric you can use, and so
 * different services will have different methods here to set up target tracking
 * scaling.
 * <p>
 * The following example configures the read capacity of a DynamoDB table
 * to be around 60% utilization:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object readCapacity = table.autoScaleReadCapacity(Map.of(
 *         "minCapacity", 10,
 *         "maxCapacity", 1000));
 * readCapacity.scaleOnUtilization(Map.of(
 *         "targetUtilizationPercent", 60));
 * </pre></blockquote>
 * <p>
 * <h2>Scheduled Scaling</h2>
 * <p>
 * This type of scaling is used to change capacities based on time. It works
 * by changing the <code>minCapacity</code> and <code>maxCapacity</code> of the attribute, and so
 * can be used for two purposes:
 * <p>
 * <ul>
 * <li>Scale in and out on a schedule by setting the <code>minCapacity</code> high or
 * the <code>maxCapacity</code> low.</li>
 * <li>Still allow the regular scaling actions to do their job, but restrict
 * the range they can scale over (by setting both <code>minCapacity</code> and
 * <code>maxCapacity</code> but changing their range over time).</li>
 * </ul>
 * <p>
 * The following schedule expressions can be used:
 * <p>
 * <ul>
 * <li><code>at(yyyy-mm-ddThh:mm:ss)</code> -- scale at a particular moment in time</li>
 * <li><code>rate(value unit)</code> -- scale every minute/hour/day</li>
 * <li><code>cron(mm hh dd mm dow)</code> -- scale on arbitrary schedules</li>
 * </ul>
 * <p>
 * Of these, the cron expression is the most useful but also the most
 * complicated. A schedule is expressed as a cron expression. The <code>Schedule</code> class has a <code>cron</code> method to help build cron expressions.
 * <p>
 * The following example scales the fleet out in the morning, and lets natural
 * scaling take over at night:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object capacity = resource.autoScaleCapacity(Map.of(
 *         "minCapacity", 1,
 *         "maxCapacity", 50));
 * 
 * capacity.scaleOnSchedule("PrescaleInTheMorning", Map.of(
 *         "schedule", autoscaling.Schedule.cron(Map.of("hour", "8", "minute", "0")),
 *         "minCapacity", 20));
 * 
 * capacity.scaleOnSchedule("AllowDownscalingAtNight", Map.of(
 *         "schedule", autoscaling.Schedule.cron(Map.of("hour", "20", "minute", "0")),
 *         "minCapacity", 1));
 * </pre></blockquote>
 * <p>
 * <h2>Examples</h2>
 * <p>
 * <h3>Lambda Provisioned Concurrency Auto Scaling</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Function handler = new Function(this, "MyFunction", new FunctionProps()
 *         .runtime(lambda.Runtime.getPYTHON_3_7())
 *         .handler("index.handler")
 *         .code(new InlineCode("\nimport json, time\ndef handler(event, context):\n    time.sleep(1)\n    return {\n        'statusCode': 200,\n        'body': json.dumps('Hello CDK from Lambda!')\n    }"))
 *         .reservedConcurrentExecutions(2));
 * 
 * Version fnVer = handler.addVersion("CDKLambdaVersion", undefined, "demo alias", 10);
 * 
 * LambdaRestApi.Builder.create(this, "API").handler(fnVer).build();
 * 
 * Object target = ScalableTarget.Builder.create(this, "ScalableTarget")
 *         .serviceNamespace(applicationautoscaling.ServiceNamespace.getLAMBDA())
 *         .maxCapacity(100)
 *         .minCapacity(10)
 *         .resourceId(String.format("function:%s:%s", handler.getFunctionName(), fnVer.getVersion()))
 *         .scalableDimension("lambda:function:ProvisionedConcurrency")
 *         .build();
 * s;
 * target.scaleToTrackMetric("PceTracking", Map.of(
 *         "targetValue", 0.9,
 *         "predefinedMetric", applicationautoscaling.PredefinedMetric.getLAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION()));
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.applicationautoscaling;
