package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Configure whether the AutoScalingGroup waits for signals.
 * <p>
 * If you do configure waiting for signals, you should make sure the instances
 * invoke <code>cfn-signal</code> somewhere in their UserData to signal that they have
 * started up (either successfully or unsuccessfully).
 * <p>
 * Signals are used both during intial creation and subsequent updates.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.128Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.Signals")
public abstract class Signals extends software.amazon.jsii.JsiiObject {

    protected Signals(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Signals(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected Signals() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Wait for the desiredCapacity of the AutoScalingGroup amount of signals to have been received.
     * <p>
     * If no desiredCapacity has been configured, wait for minCapacity signals intead.
     * <p>
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.Signals waitForAll(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.SignalsOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.Signals.class, "waitForAll", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class), new Object[] { options });
    }

    /**
     * (experimental) Wait for the desiredCapacity of the AutoScalingGroup amount of signals to have been received.
     * <p>
     * If no desiredCapacity has been configured, wait for minCapacity signals intead.
     * <p>
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.Signals waitForAll() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.Signals.class, "waitForAll", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class));
    }

    /**
     * (experimental) Wait for a specific amount of signals to have been received.
     * <p>
     * You should send one signal per instance, so this represents the number of
     * instances to wait for.
     * <p>
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     * <p>
     * @param count This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.Signals waitForCount(final @org.jetbrains.annotations.NotNull java.lang.Number count, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.SignalsOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.Signals.class, "waitForCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class), new Object[] { java.util.Objects.requireNonNull(count, "count is required"), options });
    }

    /**
     * (experimental) Wait for a specific amount of signals to have been received.
     * <p>
     * You should send one signal per instance, so this represents the number of
     * instances to wait for.
     * <p>
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     * <p>
     * @param count This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.Signals waitForCount(final @org.jetbrains.annotations.NotNull java.lang.Number count) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.Signals.class, "waitForCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class), new Object[] { java.util.Objects.requireNonNull(count, "count is required") });
    }

    /**
     * (experimental) Wait for the minCapacity of the AutoScalingGroup amount of signals to have been received.
     * <p>
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.Signals waitForMinCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.SignalsOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.Signals.class, "waitForMinCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class), new Object[] { options });
    }

    /**
     * (experimental) Wait for the minCapacity of the AutoScalingGroup amount of signals to have been received.
     * <p>
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.Signals waitForMinCapacity() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.Signals.class, "waitForMinCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class));
    }

    /**
     * (experimental) Helper to render the actual creation policy, as the logic between them is quite similar.
     * <p>
     * @param options This parameter is required.
     * @param count
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnCreationPolicy doRender(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.SignalsOptions options, final @org.jetbrains.annotations.Nullable java.lang.Number count) {
        return software.amazon.jsii.Kernel.call(this, "doRender", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnCreationPolicy.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required"), count });
    }

    /**
     * (experimental) Helper to render the actual creation policy, as the logic between them is quite similar.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnCreationPolicy doRender(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.SignalsOptions options) {
        return software.amazon.jsii.Kernel.call(this, "doRender", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnCreationPolicy.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Render the ASG's CreationPolicy.
     * <p>
     * @param renderOptions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnCreationPolicy renderCreationPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.RenderSignalsOptions renderOptions);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.autoscaling.Signals {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Render the ASG's CreationPolicy.
         * <p>
         * @param renderOptions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnCreationPolicy renderCreationPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.RenderSignalsOptions renderOptions) {
            return software.amazon.jsii.Kernel.call(this, "renderCreationPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnCreationPolicy.class), new Object[] { java.util.Objects.requireNonNull(renderOptions, "renderOptions is required") });
        }
    }
}
