package software.amazon.awscdk.services.backup;

/**
 * (experimental) Properties for a BackupPlanRule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.148Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupPlanRuleProps")
@software.amazon.jsii.Jsii.Proxy(BackupPlanRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BackupPlanRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The backup vault where backups are.
     * <p>
     * Default: - use the vault defined at the plan level. If not defined a new
     * common vault for the plan will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault getBackupVault() {
        return null;
    }

    /**
     * (experimental) The duration after a backup job is successfully started before it must be completed or it is canceled by AWS Backup.
     * <p>
     * Default: - 8 hours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getCompletionWindow() {
        return null;
    }

    /**
     * (experimental) Specifies the duration after creation that a recovery point is deleted.
     * <p>
     * Must be greater than <code>moveToColdStorageAfter</code>.
     * <p>
     * Default: - recovery point is never deleted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDeleteAfter() {
        return null;
    }

    /**
     * (experimental) Specifies the duration after creation that a recovery point is moved to cold storage.
     * <p>
     * Default: - recovery point is never moved to cold storage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMoveToColdStorageAfter() {
        return null;
    }

    /**
     * (experimental) A display name for the backup rule.
     * <p>
     * Default: - a CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return null;
    }

    /**
     * (experimental) A CRON expression specifying when AWS Backup initiates a backup job.
     * <p>
     * Default: - no schedule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.Schedule getScheduleExpression() {
        return null;
    }

    /**
     * (experimental) The duration after a backup is scheduled before a job is canceled if it doesn't start successfully.
     * <p>
     * Default: - 8 hours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getStartWindow() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackupPlanRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupPlanRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BackupPlanRuleProps> {
        private software.amazon.awscdk.services.backup.IBackupVault backupVault;
        private software.amazon.awscdk.Duration completionWindow;
        private software.amazon.awscdk.Duration deleteAfter;
        private software.amazon.awscdk.Duration moveToColdStorageAfter;
        private java.lang.String ruleName;
        private software.amazon.awscdk.services.events.Schedule scheduleExpression;
        private software.amazon.awscdk.Duration startWindow;

        /**
         * Sets the value of {@link BackupPlanRuleProps#getBackupVault}
         * @param backupVault The backup vault where backups are.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupVault(software.amazon.awscdk.services.backup.IBackupVault backupVault) {
            this.backupVault = backupVault;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getCompletionWindow}
         * @param completionWindow The duration after a backup job is successfully started before it must be completed or it is canceled by AWS Backup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder completionWindow(software.amazon.awscdk.Duration completionWindow) {
            this.completionWindow = completionWindow;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getDeleteAfter}
         * @param deleteAfter Specifies the duration after creation that a recovery point is deleted.
         *                    Must be greater than <code>moveToColdStorageAfter</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deleteAfter(software.amazon.awscdk.Duration deleteAfter) {
            this.deleteAfter = deleteAfter;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getMoveToColdStorageAfter}
         * @param moveToColdStorageAfter Specifies the duration after creation that a recovery point is moved to cold storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder moveToColdStorageAfter(software.amazon.awscdk.Duration moveToColdStorageAfter) {
            this.moveToColdStorageAfter = moveToColdStorageAfter;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getRuleName}
         * @param ruleName A display name for the backup rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getScheduleExpression}
         * @param scheduleExpression A CRON expression specifying when AWS Backup initiates a backup job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scheduleExpression(software.amazon.awscdk.services.events.Schedule scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getStartWindow}
         * @param startWindow The duration after a backup is scheduled before a job is canceled if it doesn't start successfully.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder startWindow(software.amazon.awscdk.Duration startWindow) {
            this.startWindow = startWindow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupPlanRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BackupPlanRuleProps build() {
            return new Jsii$Proxy(backupVault, completionWindow, deleteAfter, moveToColdStorageAfter, ruleName, scheduleExpression, startWindow);
        }
    }

    /**
     * An implementation for {@link BackupPlanRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPlanRuleProps {
        private final software.amazon.awscdk.services.backup.IBackupVault backupVault;
        private final software.amazon.awscdk.Duration completionWindow;
        private final software.amazon.awscdk.Duration deleteAfter;
        private final software.amazon.awscdk.Duration moveToColdStorageAfter;
        private final java.lang.String ruleName;
        private final software.amazon.awscdk.services.events.Schedule scheduleExpression;
        private final software.amazon.awscdk.Duration startWindow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupVault = software.amazon.jsii.Kernel.get(this, "backupVault", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.IBackupVault.class));
            this.completionWindow = software.amazon.jsii.Kernel.get(this, "completionWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.deleteAfter = software.amazon.jsii.Kernel.get(this, "deleteAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.moveToColdStorageAfter = software.amazon.jsii.Kernel.get(this, "moveToColdStorageAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Schedule.class));
            this.startWindow = software.amazon.jsii.Kernel.get(this, "startWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.backup.IBackupVault backupVault, final software.amazon.awscdk.Duration completionWindow, final software.amazon.awscdk.Duration deleteAfter, final software.amazon.awscdk.Duration moveToColdStorageAfter, final java.lang.String ruleName, final software.amazon.awscdk.services.events.Schedule scheduleExpression, final software.amazon.awscdk.Duration startWindow) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupVault = backupVault;
            this.completionWindow = completionWindow;
            this.deleteAfter = deleteAfter;
            this.moveToColdStorageAfter = moveToColdStorageAfter;
            this.ruleName = ruleName;
            this.scheduleExpression = scheduleExpression;
            this.startWindow = startWindow;
        }

        @Override
        public final software.amazon.awscdk.services.backup.IBackupVault getBackupVault() {
            return this.backupVault;
        }

        @Override
        public final software.amazon.awscdk.Duration getCompletionWindow() {
            return this.completionWindow;
        }

        @Override
        public final software.amazon.awscdk.Duration getDeleteAfter() {
            return this.deleteAfter;
        }

        @Override
        public final software.amazon.awscdk.Duration getMoveToColdStorageAfter() {
            return this.moveToColdStorageAfter;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final software.amazon.awscdk.services.events.Schedule getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final software.amazon.awscdk.Duration getStartWindow() {
            return this.startWindow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBackupVault() != null) {
                data.set("backupVault", om.valueToTree(this.getBackupVault()));
            }
            if (this.getCompletionWindow() != null) {
                data.set("completionWindow", om.valueToTree(this.getCompletionWindow()));
            }
            if (this.getDeleteAfter() != null) {
                data.set("deleteAfter", om.valueToTree(this.getDeleteAfter()));
            }
            if (this.getMoveToColdStorageAfter() != null) {
                data.set("moveToColdStorageAfter", om.valueToTree(this.getMoveToColdStorageAfter()));
            }
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }
            if (this.getScheduleExpression() != null) {
                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
            }
            if (this.getStartWindow() != null) {
                data.set("startWindow", om.valueToTree(this.getStartWindow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.BackupPlanRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupPlanRuleProps.Jsii$Proxy that = (BackupPlanRuleProps.Jsii$Proxy) o;

            if (this.backupVault != null ? !this.backupVault.equals(that.backupVault) : that.backupVault != null) return false;
            if (this.completionWindow != null ? !this.completionWindow.equals(that.completionWindow) : that.completionWindow != null) return false;
            if (this.deleteAfter != null ? !this.deleteAfter.equals(that.deleteAfter) : that.deleteAfter != null) return false;
            if (this.moveToColdStorageAfter != null ? !this.moveToColdStorageAfter.equals(that.moveToColdStorageAfter) : that.moveToColdStorageAfter != null) return false;
            if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
            if (this.scheduleExpression != null ? !this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression != null) return false;
            return this.startWindow != null ? this.startWindow.equals(that.startWindow) : that.startWindow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupVault != null ? this.backupVault.hashCode() : 0;
            result = 31 * result + (this.completionWindow != null ? this.completionWindow.hashCode() : 0);
            result = 31 * result + (this.deleteAfter != null ? this.deleteAfter.hashCode() : 0);
            result = 31 * result + (this.moveToColdStorageAfter != null ? this.moveToColdStorageAfter.hashCode() : 0);
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
            result = 31 * result + (this.startWindow != null ? this.startWindow.hashCode() : 0);
            return result;
        }
    }
}
