/**
 * <h1>AWS Backup Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS Backup is a fully managed backup service that makes it easy to centralize and automate the backup of data across AWS services in the cloud and on premises. Using AWS Backup, you can configure backup policies and monitor backup activity for your AWS resources in one place.
 * <p>
 * <h2>Backup plan and selection</h2>
 * <p>
 * In AWS Backup, a <em>backup plan</em> is a policy expression that defines when and how you want to back up your AWS resources, such as Amazon DynamoDB tables or Amazon Elastic File System (Amazon EFS) file systems. You can assign resources to backup plans, and AWS Backup automatically backs up and retains backups for those resources according to the backup plan. You can create multiple backup plans if you have workloads with different backup requirements.
 * <p>
 * This module provides ready-made backup plans (similar to the console experience):
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_backup;
 * 
 * 
 * // Daily, weekly and monthly with 5 year retention
 * BackupPlan plan = backup.BackupPlan.dailyWeeklyMonthly5YearRetention(this, "Plan");
 * </pre></blockquote>
 * <p>
 * Assigning resources to a plan can be done with <code>addSelection()</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * plan.addSelection("Selection", Map.of(
 *         "resources", asList(backup.BackupResource.fromDynamoDbTable(myTable), backup.BackupResource.fromTag("stage", "prod"), backup.BackupResource.fromConstruct(myCoolConstruct))));
 * </pre></blockquote>
 * <p>
 * If not specified, a new IAM role with a managed policy for backup will be
 * created for the selection. The <code>BackupSelection</code> implements <code>IGrantable</code>.
 * <p>
 * To add rules to a plan, use <code>addRule()</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * plan.addRule(BackupPlanRule.Builder.create()
 *         .completionWindow(Duration.hours(2))
 *         .startWindow(Duration.hours(1))
 *         .scheduleExpression(events.Schedule.cron(Map.of(// Only cron expressions are supported
 *                 "day", "15",
 *                 "hour", "3",
 *                 "minute", "30")))
 *         .moveToColdStorageAfter(Duration.days(30))
 *         .build());
 * </pre></blockquote>
 * <p>
 * Ready-made rules are also available:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * plan.addRule(BackupPlanRule.daily());
 * plan.addRule(BackupPlanRule.weekly());
 * </pre></blockquote>
 * <p>
 * By default a new <a href="#Backup-vault">vault</a> is created when creating a plan.
 * It is also possible to specify a vault either at the plan level or at the
 * rule level.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object plan = backup.BackupPlan.daily35DayRetention(this, "Plan", myVault);// Use `myVault` for all plan rules
 * plan.addRule(BackupPlanRule.monthly1Year(otherVault));
 * </pre></blockquote>
 * <p>
 * <h2>Backup vault</h2>
 * <p>
 * In AWS Backup, a <em>backup vault</em> is a container that you organize your backups in. You can use backup vaults to set the AWS Key Management Service (AWS KMS) encryption key that is used to encrypt backups in the backup vault and to control access to the backups in the backup vault. If you require different encryption keys or access policies for different groups of backups, you can optionally create multiple backup vaults.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object vault = BackupVault.Builder.create(stack, "Vault")
 *         .encryptionKey(myKey)// Custom encryption key
 *         .notificationTopic(myTopic)
 *         .build();
 * </pre></blockquote>
 * <p>
 * A vault has a default <code>RemovalPolicy</code> set to <code>RETAIN</code>. Note that removing a vault
 * that contains recovery points will fail.
 */
package software.amazon.awscdk.services.backup;
