/**
 * <h1>AWS::Chatbot Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS Chatbot is an AWS service that enables DevOps and software development teams to use Slack chat rooms to monitor and respond to operational events in their AWS Cloud. AWS Chatbot processes AWS service notifications from Amazon Simple Notification Service (Amazon SNS), and forwards them to Slack chat rooms so teams can analyze and act on them immediately, regardless of location.
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_chatbot;
 * 
 * 
 * SlackChannelConfiguration slackChannel = new SlackChannelConfiguration(this, "MySlackChannel", new SlackChannelConfigurationProps()
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID"));
 * 
 * slackChannel.addToPrincipalPolicy(new PolicyStatement(new PolicyStatementProps()
 *         .effect(iam.Effect.getALLOW())
 *         .actions(asList("s3:GetObject"))
 *         .resources(asList("arn:aws:s3:::abc/xyz/123.txt"))));
 * </pre></blockquote>
 * <p>
 * <h2>Log Group</h2>
 * <p>
 * Slack channel configuration automatically create a log group with the name <code>/aws/chatbot/&lt;configuration-name&gt;</code> in <code>us-east-1</code> upon first execution with
 * log data set to never expire.
 * <p>
 * The <code>logRetention</code> property can be used to set a different expiration period. A log group will be created if not already exists.
 * If the log group already exists, it's expiration will be configured to the value specified in this construct (never expire, by default).
 * <p>
 * By default, CDK uses the AWS SDK retry options when interacting with the log group. The <code>logRetentionRetryOptions</code> property
 * allows you to customize the maximum number of retries and base backoff duration.
 * <p>
 * <em>Note</em> that, if <code>logRetention</code> is set, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html">CloudFormation custom
 * resource</a> is added
 * to the stack that pre-creates the log group as part of the stack deployment, if it already doesn't exist, and sets the
 * correct log retention period (never expire, by default).
 */
package software.amazon.awscdk.services.chatbot;
