package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFormation `AWS::CloudFront::CachePolicy`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.205Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy")
public class CfnCachePolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCachePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCachePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFront::CachePolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCachePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnCachePolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudFront::CachePolicy.CachePolicyConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCachePolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "cachePolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudFront::CachePolicy.CachePolicyConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCachePolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CachePolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "cachePolicyConfig", java.util.Objects.requireNonNull(value, "cachePolicyConfig is required"));
    }

    /**
     * `AWS::CloudFront::CachePolicy.CachePolicyConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCachePolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cachePolicyConfig", java.util.Objects.requireNonNull(value, "cachePolicyConfig is required"));
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CachePolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CachePolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CachePolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.DefaultTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDefaultTtl();

        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.MaxTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTtl();

        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.MinTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinTtl();

        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.ParametersInCacheKeyAndForwardedToOrigin`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getParametersInCacheKeyAndForwardedToOrigin();

        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.Comment`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CachePolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CachePolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CachePolicyConfigProperty> {
            private java.lang.Number defaultTtl;
            private java.lang.Number maxTtl;
            private java.lang.Number minTtl;
            private java.lang.String name;
            private java.lang.Object parametersInCacheKeyAndForwardedToOrigin;
            private java.lang.String comment;

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getDefaultTtl}
             * @param defaultTtl `CfnCachePolicy.CachePolicyConfigProperty.DefaultTTL`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getMaxTtl}
             * @param maxTtl `CfnCachePolicy.CachePolicyConfigProperty.MaxTTL`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getMinTtl}
             * @param minTtl `CfnCachePolicy.CachePolicyConfigProperty.MinTTL`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getName}
             * @param name `CfnCachePolicy.CachePolicyConfigProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getParametersInCacheKeyAndForwardedToOrigin}
             * @param parametersInCacheKeyAndForwardedToOrigin `CfnCachePolicy.CachePolicyConfigProperty.ParametersInCacheKeyAndForwardedToOrigin`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parametersInCacheKeyAndForwardedToOrigin(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty parametersInCacheKeyAndForwardedToOrigin) {
                this.parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getParametersInCacheKeyAndForwardedToOrigin}
             * @param parametersInCacheKeyAndForwardedToOrigin `CfnCachePolicy.CachePolicyConfigProperty.ParametersInCacheKeyAndForwardedToOrigin`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parametersInCacheKeyAndForwardedToOrigin(software.amazon.awscdk.IResolvable parametersInCacheKeyAndForwardedToOrigin) {
                this.parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getComment}
             * @param comment `CfnCachePolicy.CachePolicyConfigProperty.Comment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CachePolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CachePolicyConfigProperty build() {
                return new Jsii$Proxy(defaultTtl, maxTtl, minTtl, name, parametersInCacheKeyAndForwardedToOrigin, comment);
            }
        }

        /**
         * An implementation for {@link CachePolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CachePolicyConfigProperty {
            private final java.lang.Number defaultTtl;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String name;
            private final java.lang.Object parametersInCacheKeyAndForwardedToOrigin;
            private final java.lang.String comment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parametersInCacheKeyAndForwardedToOrigin = software.amazon.jsii.Kernel.get(this, "parametersInCacheKeyAndForwardedToOrigin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number defaultTtl, final java.lang.Number maxTtl, final java.lang.Number minTtl, final java.lang.String name, final java.lang.Object parametersInCacheKeyAndForwardedToOrigin, final java.lang.String comment) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultTtl = java.util.Objects.requireNonNull(defaultTtl, "defaultTtl is required");
                this.maxTtl = java.util.Objects.requireNonNull(maxTtl, "maxTtl is required");
                this.minTtl = java.util.Objects.requireNonNull(minTtl, "minTtl is required");
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.parametersInCacheKeyAndForwardedToOrigin = java.util.Objects.requireNonNull(parametersInCacheKeyAndForwardedToOrigin, "parametersInCacheKeyAndForwardedToOrigin is required");
                this.comment = comment;
            }

            @Override
            public final java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public final java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public final java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getParametersInCacheKeyAndForwardedToOrigin() {
                return this.parametersInCacheKeyAndForwardedToOrigin;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                data.set("minTtl", om.valueToTree(this.getMinTtl()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("parametersInCacheKeyAndForwardedToOrigin", om.valueToTree(this.getParametersInCacheKeyAndForwardedToOrigin()));
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CachePolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CachePolicyConfigProperty.Jsii$Proxy that = (CachePolicyConfigProperty.Jsii$Proxy) o;

                if (!defaultTtl.equals(that.defaultTtl)) return false;
                if (!maxTtl.equals(that.maxTtl)) return false;
                if (!minTtl.equals(that.minTtl)) return false;
                if (!name.equals(that.name)) return false;
                if (!parametersInCacheKeyAndForwardedToOrigin.equals(that.parametersInCacheKeyAndForwardedToOrigin)) return false;
                return this.comment != null ? this.comment.equals(that.comment) : that.comment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultTtl.hashCode();
                result = 31 * result + (this.maxTtl.hashCode());
                result = 31 * result + (this.minTtl.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.parametersInCacheKeyAndForwardedToOrigin.hashCode());
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CookiesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCachePolicy.CookiesConfigProperty.CookieBehavior`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCookieBehavior();

        /**
         * `CfnCachePolicy.CookiesConfigProperty.Cookies`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCookies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesConfigProperty> {
            private java.lang.String cookieBehavior;
            private java.util.List<java.lang.String> cookies;

            /**
             * Sets the value of {@link CookiesConfigProperty#getCookieBehavior}
             * @param cookieBehavior `CfnCachePolicy.CookiesConfigProperty.CookieBehavior`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookieBehavior(java.lang.String cookieBehavior) {
                this.cookieBehavior = cookieBehavior;
                return this;
            }

            /**
             * Sets the value of {@link CookiesConfigProperty#getCookies}
             * @param cookies `CfnCachePolicy.CookiesConfigProperty.Cookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(java.util.List<java.lang.String> cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesConfigProperty build() {
                return new Jsii$Proxy(cookieBehavior, cookies);
            }
        }

        /**
         * An implementation for {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesConfigProperty {
            private final java.lang.String cookieBehavior;
            private final java.util.List<java.lang.String> cookies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookieBehavior = software.amazon.jsii.Kernel.get(this, "cookieBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cookies = software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String cookieBehavior, final java.util.List<java.lang.String> cookies) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookieBehavior = java.util.Objects.requireNonNull(cookieBehavior, "cookieBehavior is required");
                this.cookies = cookies;
            }

            @Override
            public final java.lang.String getCookieBehavior() {
                return this.cookieBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getCookies() {
                return this.cookies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookieBehavior", om.valueToTree(this.getCookieBehavior()));
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CookiesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesConfigProperty.Jsii$Proxy that = (CookiesConfigProperty.Jsii$Proxy) o;

                if (!cookieBehavior.equals(that.cookieBehavior)) return false;
                return this.cookies != null ? this.cookies.equals(that.cookies) : that.cookies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cookieBehavior.hashCode();
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.HeadersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HeadersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeadersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCachePolicy.HeadersConfigProperty.HeaderBehavior`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderBehavior();

        /**
         * `CfnCachePolicy.HeadersConfigProperty.Headers`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeadersConfigProperty> {
            private java.lang.String headerBehavior;
            private java.util.List<java.lang.String> headers;

            /**
             * Sets the value of {@link HeadersConfigProperty#getHeaderBehavior}
             * @param headerBehavior `CfnCachePolicy.HeadersConfigProperty.HeaderBehavior`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerBehavior(java.lang.String headerBehavior) {
                this.headerBehavior = headerBehavior;
                return this;
            }

            /**
             * Sets the value of {@link HeadersConfigProperty#getHeaders}
             * @param headers `CfnCachePolicy.HeadersConfigProperty.Headers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<java.lang.String> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeadersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeadersConfigProperty build() {
                return new Jsii$Proxy(headerBehavior, headers);
            }
        }

        /**
         * An implementation for {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeadersConfigProperty {
            private final java.lang.String headerBehavior;
            private final java.util.List<java.lang.String> headers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerBehavior = software.amazon.jsii.Kernel.get(this, "headerBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String headerBehavior, final java.util.List<java.lang.String> headers) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerBehavior = java.util.Objects.requireNonNull(headerBehavior, "headerBehavior is required");
                this.headers = headers;
            }

            @Override
            public final java.lang.String getHeaderBehavior() {
                return this.headerBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getHeaders() {
                return this.headers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerBehavior", om.valueToTree(this.getHeaderBehavior()));
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.HeadersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeadersConfigProperty.Jsii$Proxy that = (HeadersConfigProperty.Jsii$Proxy) o;

                if (!headerBehavior.equals(that.headerBehavior)) return false;
                return this.headers != null ? this.headers.equals(that.headers) : that.headers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headerBehavior.hashCode();
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty")
    @software.amazon.jsii.Jsii.Proxy(ParametersInCacheKeyAndForwardedToOriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParametersInCacheKeyAndForwardedToOriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.CookiesConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCookiesConfig();

        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingGzip`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableAcceptEncodingGzip();

        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.HeadersConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHeadersConfig();

        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.QueryStringsConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryStringsConfig();

        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingBrotli`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableAcceptEncodingBrotli() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParametersInCacheKeyAndForwardedToOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParametersInCacheKeyAndForwardedToOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParametersInCacheKeyAndForwardedToOriginProperty> {
            private java.lang.Object cookiesConfig;
            private java.lang.Object enableAcceptEncodingGzip;
            private java.lang.Object headersConfig;
            private java.lang.Object queryStringsConfig;
            private java.lang.Object enableAcceptEncodingBrotli;

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getCookiesConfig}
             * @param cookiesConfig `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.CookiesConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookiesConfig(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CookiesConfigProperty cookiesConfig) {
                this.cookiesConfig = cookiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getCookiesConfig}
             * @param cookiesConfig `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.CookiesConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookiesConfig(software.amazon.awscdk.IResolvable cookiesConfig) {
                this.cookiesConfig = cookiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingGzip}
             * @param enableAcceptEncodingGzip `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingGzip`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingGzip(java.lang.Boolean enableAcceptEncodingGzip) {
                this.enableAcceptEncodingGzip = enableAcceptEncodingGzip;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingGzip}
             * @param enableAcceptEncodingGzip `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingGzip`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingGzip(software.amazon.awscdk.IResolvable enableAcceptEncodingGzip) {
                this.enableAcceptEncodingGzip = enableAcceptEncodingGzip;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getHeadersConfig}
             * @param headersConfig `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.HeadersConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headersConfig(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.HeadersConfigProperty headersConfig) {
                this.headersConfig = headersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getHeadersConfig}
             * @param headersConfig `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.HeadersConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headersConfig(software.amazon.awscdk.IResolvable headersConfig) {
                this.headersConfig = headersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getQueryStringsConfig}
             * @param queryStringsConfig `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.QueryStringsConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringsConfig(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.QueryStringsConfigProperty queryStringsConfig) {
                this.queryStringsConfig = queryStringsConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getQueryStringsConfig}
             * @param queryStringsConfig `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.QueryStringsConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringsConfig(software.amazon.awscdk.IResolvable queryStringsConfig) {
                this.queryStringsConfig = queryStringsConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingBrotli}
             * @param enableAcceptEncodingBrotli `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingBrotli`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingBrotli(java.lang.Boolean enableAcceptEncodingBrotli) {
                this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingBrotli}
             * @param enableAcceptEncodingBrotli `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingBrotli`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingBrotli(software.amazon.awscdk.IResolvable enableAcceptEncodingBrotli) {
                this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParametersInCacheKeyAndForwardedToOriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParametersInCacheKeyAndForwardedToOriginProperty build() {
                return new Jsii$Proxy(cookiesConfig, enableAcceptEncodingGzip, headersConfig, queryStringsConfig, enableAcceptEncodingBrotli);
            }
        }

        /**
         * An implementation for {@link ParametersInCacheKeyAndForwardedToOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParametersInCacheKeyAndForwardedToOriginProperty {
            private final java.lang.Object cookiesConfig;
            private final java.lang.Object enableAcceptEncodingGzip;
            private final java.lang.Object headersConfig;
            private final java.lang.Object queryStringsConfig;
            private final java.lang.Object enableAcceptEncodingBrotli;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookiesConfig = software.amazon.jsii.Kernel.get(this, "cookiesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableAcceptEncodingGzip = software.amazon.jsii.Kernel.get(this, "enableAcceptEncodingGzip", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headersConfig = software.amazon.jsii.Kernel.get(this, "headersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryStringsConfig = software.amazon.jsii.Kernel.get(this, "queryStringsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableAcceptEncodingBrotli = software.amazon.jsii.Kernel.get(this, "enableAcceptEncodingBrotli", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object cookiesConfig, final java.lang.Object enableAcceptEncodingGzip, final java.lang.Object headersConfig, final java.lang.Object queryStringsConfig, final java.lang.Object enableAcceptEncodingBrotli) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookiesConfig = java.util.Objects.requireNonNull(cookiesConfig, "cookiesConfig is required");
                this.enableAcceptEncodingGzip = java.util.Objects.requireNonNull(enableAcceptEncodingGzip, "enableAcceptEncodingGzip is required");
                this.headersConfig = java.util.Objects.requireNonNull(headersConfig, "headersConfig is required");
                this.queryStringsConfig = java.util.Objects.requireNonNull(queryStringsConfig, "queryStringsConfig is required");
                this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
            }

            @Override
            public final java.lang.Object getCookiesConfig() {
                return this.cookiesConfig;
            }

            @Override
            public final java.lang.Object getEnableAcceptEncodingGzip() {
                return this.enableAcceptEncodingGzip;
            }

            @Override
            public final java.lang.Object getHeadersConfig() {
                return this.headersConfig;
            }

            @Override
            public final java.lang.Object getQueryStringsConfig() {
                return this.queryStringsConfig;
            }

            @Override
            public final java.lang.Object getEnableAcceptEncodingBrotli() {
                return this.enableAcceptEncodingBrotli;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookiesConfig", om.valueToTree(this.getCookiesConfig()));
                data.set("enableAcceptEncodingGzip", om.valueToTree(this.getEnableAcceptEncodingGzip()));
                data.set("headersConfig", om.valueToTree(this.getHeadersConfig()));
                data.set("queryStringsConfig", om.valueToTree(this.getQueryStringsConfig()));
                if (this.getEnableAcceptEncodingBrotli() != null) {
                    data.set("enableAcceptEncodingBrotli", om.valueToTree(this.getEnableAcceptEncodingBrotli()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParametersInCacheKeyAndForwardedToOriginProperty.Jsii$Proxy that = (ParametersInCacheKeyAndForwardedToOriginProperty.Jsii$Proxy) o;

                if (!cookiesConfig.equals(that.cookiesConfig)) return false;
                if (!enableAcceptEncodingGzip.equals(that.enableAcceptEncodingGzip)) return false;
                if (!headersConfig.equals(that.headersConfig)) return false;
                if (!queryStringsConfig.equals(that.queryStringsConfig)) return false;
                return this.enableAcceptEncodingBrotli != null ? this.enableAcceptEncodingBrotli.equals(that.enableAcceptEncodingBrotli) : that.enableAcceptEncodingBrotli == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cookiesConfig.hashCode();
                result = 31 * result + (this.enableAcceptEncodingGzip.hashCode());
                result = 31 * result + (this.headersConfig.hashCode());
                result = 31 * result + (this.queryStringsConfig.hashCode());
                result = 31 * result + (this.enableAcceptEncodingBrotli != null ? this.enableAcceptEncodingBrotli.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.QueryStringsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryStringsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCachePolicy.QueryStringsConfigProperty.QueryStringBehavior`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueryStringBehavior();

        /**
         * `CfnCachePolicy.QueryStringsConfigProperty.QueryStrings`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStrings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryStringsConfigProperty> {
            private java.lang.String queryStringBehavior;
            private java.util.List<java.lang.String> queryStrings;

            /**
             * Sets the value of {@link QueryStringsConfigProperty#getQueryStringBehavior}
             * @param queryStringBehavior `CfnCachePolicy.QueryStringsConfigProperty.QueryStringBehavior`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringBehavior(java.lang.String queryStringBehavior) {
                this.queryStringBehavior = queryStringBehavior;
                return this;
            }

            /**
             * Sets the value of {@link QueryStringsConfigProperty#getQueryStrings}
             * @param queryStrings `CfnCachePolicy.QueryStringsConfigProperty.QueryStrings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStrings(java.util.List<java.lang.String> queryStrings) {
                this.queryStrings = queryStrings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryStringsConfigProperty build() {
                return new Jsii$Proxy(queryStringBehavior, queryStrings);
            }
        }

        /**
         * An implementation for {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringsConfigProperty {
            private final java.lang.String queryStringBehavior;
            private final java.util.List<java.lang.String> queryStrings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryStringBehavior = software.amazon.jsii.Kernel.get(this, "queryStringBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryStrings = software.amazon.jsii.Kernel.get(this, "queryStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String queryStringBehavior, final java.util.List<java.lang.String> queryStrings) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryStringBehavior = java.util.Objects.requireNonNull(queryStringBehavior, "queryStringBehavior is required");
                this.queryStrings = queryStrings;
            }

            @Override
            public final java.lang.String getQueryStringBehavior() {
                return this.queryStringBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getQueryStrings() {
                return this.queryStrings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryStringBehavior", om.valueToTree(this.getQueryStringBehavior()));
                if (this.getQueryStrings() != null) {
                    data.set("queryStrings", om.valueToTree(this.getQueryStrings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.QueryStringsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringsConfigProperty.Jsii$Proxy that = (QueryStringsConfigProperty.Jsii$Proxy) o;

                if (!queryStringBehavior.equals(that.queryStringBehavior)) return false;
                return this.queryStrings != null ? this.queryStrings.equals(that.queryStrings) : that.queryStrings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryStringBehavior.hashCode();
                result = 31 * result + (this.queryStrings != null ? this.queryStrings.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnCachePolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnCachePolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnCachePolicyProps.Builder();
        }

        /**
         * `AWS::CloudFront::CachePolicy.CachePolicyConfig`.
         * <p>
         * @return {@code this}
         * @param cachePolicyConfig `AWS::CloudFront::CachePolicy.CachePolicyConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicyConfig(final software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CachePolicyConfigProperty cachePolicyConfig) {
            this.props.cachePolicyConfig(cachePolicyConfig);
            return this;
        }
        /**
         * `AWS::CloudFront::CachePolicy.CachePolicyConfig`.
         * <p>
         * @return {@code this}
         * @param cachePolicyConfig `AWS::CloudFront::CachePolicy.CachePolicyConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicyConfig(final software.amazon.awscdk.IResolvable cachePolicyConfig) {
            this.props.cachePolicyConfig(cachePolicyConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnCachePolicy build() {
            return new software.amazon.awscdk.services.cloudfront.CfnCachePolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
