package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFormation `AWS::CloudFront::StreamingDistribution`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.213Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution")
public class CfnStreamingDistribution extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnStreamingDistribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStreamingDistribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFront::StreamingDistribution`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStreamingDistribution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnStreamingDistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudFront::StreamingDistribution.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStreamingDistributionConfig() {
        return software.amazon.jsii.Kernel.get(this, "streamingDistributionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamingDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamingDistributionConfig", java.util.Objects.requireNonNull(value, "streamingDistributionConfig is required"));
    }

    /**
     * `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamingDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamingDistributionConfig", java.util.Objects.requireNonNull(value, "streamingDistributionConfig is required"));
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStreamingDistribution.LoggingProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnStreamingDistribution.LoggingProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnStreamingDistribution.LoggingProperty.Prefix`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            private java.lang.String bucket;
            private java.lang.Object enabled;
            private java.lang.String prefix;

            /**
             * Sets the value of {@link LoggingProperty#getBucket}
             * @param bucket `CfnStreamingDistribution.LoggingProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getEnabled}
             * @param enabled `CfnStreamingDistribution.LoggingProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getEnabled}
             * @param enabled `CfnStreamingDistribution.LoggingProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getPrefix}
             * @param prefix `CfnStreamingDistribution.LoggingProperty.Prefix`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(bucket, enabled, prefix);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.String bucket;
            private final java.lang.Object enabled;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String bucket, final java.lang.Object enabled, final java.lang.String prefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.prefix = java.util.Objects.requireNonNull(prefix, "prefix is required");
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("prefix", om.valueToTree(this.getPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!enabled.equals(that.enabled)) return false;
                return this.prefix.equals(that.prefix);
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.prefix.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.S3OriginProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStreamingDistribution.S3OriginProperty.DomainName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * `CfnStreamingDistribution.S3OriginProperty.OriginAccessIdentity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessIdentity();

        /**
         * @return a {@link Builder} of {@link S3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OriginProperty> {
            private java.lang.String domainName;
            private java.lang.String originAccessIdentity;

            /**
             * Sets the value of {@link S3OriginProperty#getDomainName}
             * @param domainName `CfnStreamingDistribution.S3OriginProperty.DomainName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link S3OriginProperty#getOriginAccessIdentity}
             * @param originAccessIdentity `CfnStreamingDistribution.S3OriginProperty.OriginAccessIdentity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessIdentity(java.lang.String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OriginProperty build() {
                return new Jsii$Proxy(domainName, originAccessIdentity);
            }
        }

        /**
         * An implementation for {@link S3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OriginProperty {
            private final java.lang.String domainName;
            private final java.lang.String originAccessIdentity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originAccessIdentity = software.amazon.jsii.Kernel.get(this, "originAccessIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String domainName, final java.lang.String originAccessIdentity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
                this.originAccessIdentity = java.util.Objects.requireNonNull(originAccessIdentity, "originAccessIdentity is required");
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getOriginAccessIdentity() {
                return this.originAccessIdentity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));
                data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.S3OriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OriginProperty.Jsii$Proxy that = (S3OriginProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                return this.originAccessIdentity.equals(that.originAccessIdentity);
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.originAccessIdentity.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamingDistributionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamingDistributionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Comment`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComment();

        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.S3Origin`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Origin();

        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.TrustedSigners`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrustedSigners();

        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Aliases`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
            return null;
        }

        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Logging`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
            return null;
        }

        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.PriceClass`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPriceClass() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamingDistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamingDistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamingDistributionConfigProperty> {
            private java.lang.String comment;
            private java.lang.Object enabled;
            private java.lang.Object s3Origin;
            private java.lang.Object trustedSigners;
            private java.util.List<java.lang.String> aliases;
            private java.lang.Object logging;
            private java.lang.String priceClass;

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getComment}
             * @param comment `CfnStreamingDistribution.StreamingDistributionConfigProperty.Comment`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getEnabled}
             * @param enabled `CfnStreamingDistribution.StreamingDistributionConfigProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getEnabled}
             * @param enabled `CfnStreamingDistribution.StreamingDistributionConfigProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getS3Origin}
             * @param s3Origin `CfnStreamingDistribution.StreamingDistributionConfigProperty.S3Origin`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.S3OriginProperty s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getS3Origin}
             * @param s3Origin `CfnStreamingDistribution.StreamingDistributionConfigProperty.S3Origin`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.IResolvable s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getTrustedSigners}
             * @param trustedSigners `CfnStreamingDistribution.StreamingDistributionConfigProperty.TrustedSigners`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.TrustedSignersProperty trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getTrustedSigners}
             * @param trustedSigners `CfnStreamingDistribution.StreamingDistributionConfigProperty.TrustedSigners`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(software.amazon.awscdk.IResolvable trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getAliases}
             * @param aliases `CfnStreamingDistribution.StreamingDistributionConfigProperty.Aliases`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliases(java.util.List<java.lang.String> aliases) {
                this.aliases = aliases;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getLogging}
             * @param logging `CfnStreamingDistribution.StreamingDistributionConfigProperty.Logging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getLogging}
             * @param logging `CfnStreamingDistribution.StreamingDistributionConfigProperty.Logging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.IResolvable logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link StreamingDistributionConfigProperty#getPriceClass}
             * @param priceClass `CfnStreamingDistribution.StreamingDistributionConfigProperty.PriceClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priceClass(java.lang.String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamingDistributionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamingDistributionConfigProperty build() {
                return new Jsii$Proxy(comment, enabled, s3Origin, trustedSigners, aliases, logging, priceClass);
            }
        }

        /**
         * An implementation for {@link StreamingDistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamingDistributionConfigProperty {
            private final java.lang.String comment;
            private final java.lang.Object enabled;
            private final java.lang.Object s3Origin;
            private final java.lang.Object trustedSigners;
            private final java.util.List<java.lang.String> aliases;
            private final java.lang.Object logging;
            private final java.lang.String priceClass;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Origin = software.amazon.jsii.Kernel.get(this, "s3Origin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priceClass = software.amazon.jsii.Kernel.get(this, "priceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String comment, final java.lang.Object enabled, final java.lang.Object s3Origin, final java.lang.Object trustedSigners, final java.util.List<java.lang.String> aliases, final java.lang.Object logging, final java.lang.String priceClass) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comment = java.util.Objects.requireNonNull(comment, "comment is required");
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.s3Origin = java.util.Objects.requireNonNull(s3Origin, "s3Origin is required");
                this.trustedSigners = java.util.Objects.requireNonNull(trustedSigners, "trustedSigners is required");
                this.aliases = aliases;
                this.logging = logging;
                this.priceClass = priceClass;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getS3Origin() {
                return this.s3Origin;
            }

            @Override
            public final java.lang.Object getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            public final java.util.List<java.lang.String> getAliases() {
                return this.aliases;
            }

            @Override
            public final java.lang.Object getLogging() {
                return this.logging;
            }

            @Override
            public final java.lang.String getPriceClass() {
                return this.priceClass;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comment", om.valueToTree(this.getComment()));
                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("s3Origin", om.valueToTree(this.getS3Origin()));
                data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                if (this.getAliases() != null) {
                    data.set("aliases", om.valueToTree(this.getAliases()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }
                if (this.getPriceClass() != null) {
                    data.set("priceClass", om.valueToTree(this.getPriceClass()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamingDistributionConfigProperty.Jsii$Proxy that = (StreamingDistributionConfigProperty.Jsii$Proxy) o;

                if (!comment.equals(that.comment)) return false;
                if (!enabled.equals(that.enabled)) return false;
                if (!s3Origin.equals(that.s3Origin)) return false;
                if (!trustedSigners.equals(that.trustedSigners)) return false;
                if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
                if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
                return this.priceClass != null ? this.priceClass.equals(that.priceClass) : that.priceClass == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comment.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.s3Origin.hashCode());
                result = 31 * result + (this.trustedSigners.hashCode());
                result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                result = 31 * result + (this.priceClass != null ? this.priceClass.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.TrustedSignersProperty")
    @software.amazon.jsii.Jsii.Proxy(TrustedSignersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrustedSignersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStreamingDistribution.TrustedSignersProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnStreamingDistribution.TrustedSignersProperty.AwsAccountNumbers`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsAccountNumbers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrustedSignersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrustedSignersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrustedSignersProperty> {
            private java.lang.Object enabled;
            private java.util.List<java.lang.String> awsAccountNumbers;

            /**
             * Sets the value of {@link TrustedSignersProperty#getEnabled}
             * @param enabled `CfnStreamingDistribution.TrustedSignersProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TrustedSignersProperty#getEnabled}
             * @param enabled `CfnStreamingDistribution.TrustedSignersProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TrustedSignersProperty#getAwsAccountNumbers}
             * @param awsAccountNumbers `CfnStreamingDistribution.TrustedSignersProperty.AwsAccountNumbers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountNumbers(java.util.List<java.lang.String> awsAccountNumbers) {
                this.awsAccountNumbers = awsAccountNumbers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrustedSignersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrustedSignersProperty build() {
                return new Jsii$Proxy(enabled, awsAccountNumbers);
            }
        }

        /**
         * An implementation for {@link TrustedSignersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrustedSignersProperty {
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> awsAccountNumbers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsAccountNumbers = software.amazon.jsii.Kernel.get(this, "awsAccountNumbers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object enabled, final java.util.List<java.lang.String> awsAccountNumbers) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.awsAccountNumbers = awsAccountNumbers;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsAccountNumbers() {
                return this.awsAccountNumbers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAwsAccountNumbers() != null) {
                    data.set("awsAccountNumbers", om.valueToTree(this.getAwsAccountNumbers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnStreamingDistribution.TrustedSignersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrustedSignersProperty.Jsii$Proxy that = (TrustedSignersProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.awsAccountNumbers != null ? this.awsAccountNumbers.equals(that.awsAccountNumbers) : that.awsAccountNumbers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.awsAccountNumbers != null ? this.awsAccountNumbers.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnStreamingDistributionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnStreamingDistributionProps.Builder();
        }

        /**
         * `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`.
         * <p>
         * @return {@code this}
         * @param streamingDistributionConfig `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamingDistributionConfig(final software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty streamingDistributionConfig) {
            this.props.streamingDistributionConfig(streamingDistributionConfig);
            return this;
        }
        /**
         * `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`.
         * <p>
         * @return {@code this}
         * @param streamingDistributionConfig `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamingDistributionConfig(final software.amazon.awscdk.IResolvable streamingDistributionConfig) {
            this.props.streamingDistributionConfig(streamingDistributionConfig);
            return this;
        }

        /**
         * `AWS::CloudFront::StreamingDistribution.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::CloudFront::StreamingDistribution.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution build() {
            return new software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
