package software.amazon.awscdk.services.cloudfront.origins;

/**
 * (experimental) Properties for an Origin backed by a v2 load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.245Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.LoadBalancerV2OriginProps")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerV2OriginProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LoadBalancerV2OriginProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps {

    /**
     * @return a {@link Builder} of {@link LoadBalancerV2OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerV2OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerV2OriginProps> {
        private java.lang.Number httpPort;
        private java.lang.Number httpsPort;
        private software.amazon.awscdk.Duration keepaliveTimeout;
        private java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols;
        private software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy;
        private software.amazon.awscdk.Duration readTimeout;
        private java.lang.Number connectionAttempts;
        private software.amazon.awscdk.Duration connectionTimeout;
        private java.util.Map<java.lang.String, java.lang.String> customHeaders;
        private java.lang.String originPath;

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getHttpPort}
         * @param httpPort The HTTP port that CloudFront uses to connect to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpPort(java.lang.Number httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getHttpsPort}
         * @param httpsPort The HTTPS port that CloudFront uses to connect to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpsPort(java.lang.Number httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getKeepaliveTimeout}
         * @param keepaliveTimeout Specifies how long, in seconds, CloudFront persists its connection to the origin.
         *                         The valid range is from 1 to 60 seconds, inclusive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keepaliveTimeout(software.amazon.awscdk.Duration keepaliveTimeout) {
            this.keepaliveTimeout = keepaliveTimeout;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getOriginSslProtocols}
         * @param originSslProtocols The SSL versions to use when interacting with the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder originSslProtocols(java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols) {
            this.originSslProtocols = (java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy>)originSslProtocols;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getProtocolPolicy}
         * @param protocolPolicy Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocolPolicy(software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy) {
            this.protocolPolicy = protocolPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getReadTimeout}
         * @param readTimeout Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
         *                    The valid range is from 1 to 60 seconds, inclusive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readTimeout(software.amazon.awscdk.Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getConnectionAttempts}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;.
         *                           valid values are 1, 2, or 3 attempts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionAttempts(java.lang.Number connectionAttempts) {
            this.connectionAttempts = connectionAttempts;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getConnectionTimeout}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         *                          Valid values are 1-10 seconds, inclusive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionTimeout(software.amazon.awscdk.Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getCustomHeaders}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customHeaders(java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerV2OriginProps#getOriginPath}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         *                   Must begin, but not end, with '/' (e.g., '/production/images').
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerV2OriginProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LoadBalancerV2OriginProps build() {
            return new Jsii$Proxy(httpPort, httpsPort, keepaliveTimeout, originSslProtocols, protocolPolicy, readTimeout, connectionAttempts, connectionTimeout, customHeaders, originPath);
        }
    }

    /**
     * An implementation for {@link LoadBalancerV2OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerV2OriginProps {
        private final java.lang.Number httpPort;
        private final java.lang.Number httpsPort;
        private final software.amazon.awscdk.Duration keepaliveTimeout;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols;
        private final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy;
        private final software.amazon.awscdk.Duration readTimeout;
        private final java.lang.Number connectionAttempts;
        private final software.amazon.awscdk.Duration connectionTimeout;
        private final java.util.Map<java.lang.String, java.lang.String> customHeaders;
        private final java.lang.String originPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.httpsPort = software.amazon.jsii.Kernel.get(this, "httpsPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.keepaliveTimeout = software.amazon.jsii.Kernel.get(this, "keepaliveTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.originSslProtocols = software.amazon.jsii.Kernel.get(this, "originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginSslPolicy.class)));
            this.protocolPolicy = software.amazon.jsii.Kernel.get(this, "protocolPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy.class));
            this.readTimeout = software.amazon.jsii.Kernel.get(this, "readTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.connectionAttempts = software.amazon.jsii.Kernel.get(this, "connectionAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connectionTimeout = software.amazon.jsii.Kernel.get(this, "connectionTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.customHeaders = software.amazon.jsii.Kernel.get(this, "customHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originPath = software.amazon.jsii.Kernel.get(this, "originPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.Number httpPort, final java.lang.Number httpsPort, final software.amazon.awscdk.Duration keepaliveTimeout, final java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols, final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy, final software.amazon.awscdk.Duration readTimeout, final java.lang.Number connectionAttempts, final software.amazon.awscdk.Duration connectionTimeout, final java.util.Map<java.lang.String, java.lang.String> customHeaders, final java.lang.String originPath) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpPort = httpPort;
            this.httpsPort = httpsPort;
            this.keepaliveTimeout = keepaliveTimeout;
            this.originSslProtocols = (java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy>)originSslProtocols;
            this.protocolPolicy = protocolPolicy;
            this.readTimeout = readTimeout;
            this.connectionAttempts = connectionAttempts;
            this.connectionTimeout = connectionTimeout;
            this.customHeaders = customHeaders;
            this.originPath = originPath;
        }

        @Override
        public final java.lang.Number getHttpPort() {
            return this.httpPort;
        }

        @Override
        public final java.lang.Number getHttpsPort() {
            return this.httpsPort;
        }

        @Override
        public final software.amazon.awscdk.Duration getKeepaliveTimeout() {
            return this.keepaliveTimeout;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> getOriginSslProtocols() {
            return this.originSslProtocols;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy getProtocolPolicy() {
            return this.protocolPolicy;
        }

        @Override
        public final software.amazon.awscdk.Duration getReadTimeout() {
            return this.readTimeout;
        }

        @Override
        public final java.lang.Number getConnectionAttempts() {
            return this.connectionAttempts;
        }

        @Override
        public final software.amazon.awscdk.Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getCustomHeaders() {
            return this.customHeaders;
        }

        @Override
        public final java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHttpPort() != null) {
                data.set("httpPort", om.valueToTree(this.getHttpPort()));
            }
            if (this.getHttpsPort() != null) {
                data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
            }
            if (this.getKeepaliveTimeout() != null) {
                data.set("keepaliveTimeout", om.valueToTree(this.getKeepaliveTimeout()));
            }
            if (this.getOriginSslProtocols() != null) {
                data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
            }
            if (this.getProtocolPolicy() != null) {
                data.set("protocolPolicy", om.valueToTree(this.getProtocolPolicy()));
            }
            if (this.getReadTimeout() != null) {
                data.set("readTimeout", om.valueToTree(this.getReadTimeout()));
            }
            if (this.getConnectionAttempts() != null) {
                data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
            }
            if (this.getConnectionTimeout() != null) {
                data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
            }
            if (this.getCustomHeaders() != null) {
                data.set("customHeaders", om.valueToTree(this.getCustomHeaders()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront_origins.LoadBalancerV2OriginProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerV2OriginProps.Jsii$Proxy that = (LoadBalancerV2OriginProps.Jsii$Proxy) o;

            if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
            if (this.httpsPort != null ? !this.httpsPort.equals(that.httpsPort) : that.httpsPort != null) return false;
            if (this.keepaliveTimeout != null ? !this.keepaliveTimeout.equals(that.keepaliveTimeout) : that.keepaliveTimeout != null) return false;
            if (this.originSslProtocols != null ? !this.originSslProtocols.equals(that.originSslProtocols) : that.originSslProtocols != null) return false;
            if (this.protocolPolicy != null ? !this.protocolPolicy.equals(that.protocolPolicy) : that.protocolPolicy != null) return false;
            if (this.readTimeout != null ? !this.readTimeout.equals(that.readTimeout) : that.readTimeout != null) return false;
            if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
            if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
            if (this.customHeaders != null ? !this.customHeaders.equals(that.customHeaders) : that.customHeaders != null) return false;
            return this.originPath != null ? this.originPath.equals(that.originPath) : that.originPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpPort != null ? this.httpPort.hashCode() : 0;
            result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
            result = 31 * result + (this.keepaliveTimeout != null ? this.keepaliveTimeout.hashCode() : 0);
            result = 31 * result + (this.originSslProtocols != null ? this.originSslProtocols.hashCode() : 0);
            result = 31 * result + (this.protocolPolicy != null ? this.protocolPolicy.hashCode() : 0);
            result = 31 * result + (this.readTimeout != null ? this.readTimeout.hashCode() : 0);
            result = 31 * result + (this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0);
            result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
            result = 31 * result + (this.customHeaders != null ? this.customHeaders.hashCode() : 0);
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            return result;
        }
    }
}
