package software.amazon.awscdk.services.cloudfront.origins;

/**
 * (experimental) Properties to use to customize an S3 Origin.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.S3OriginProps")
@software.amazon.jsii.Jsii.Proxy(S3OriginProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface S3OriginProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) An optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
     * <p>
     * Default: - An Origin Access Identity will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity getOriginAccessIdentity() {
        return null;
    }

    /**
     * (experimental) An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
     * <p>
     * Must begin, but not end, with '/' (e.g., '/production/images').
     * <p>
     * Default: '/'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<S3OriginProps> {
        private software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity;
        private java.lang.String originPath;

        /**
         * Sets the value of {@link S3OriginProps#getOriginAccessIdentity}
         * @param originAccessIdentity An optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originAccessIdentity(software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        /**
         * Sets the value of {@link S3OriginProps#getOriginPath}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         *                   Must begin, but not end, with '/' (e.g., '/production/images').
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3OriginProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public S3OriginProps build() {
            return new Jsii$Proxy(originAccessIdentity, originPath);
        }
    }

    /**
     * An implementation for {@link S3OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OriginProps {
        private final software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity;
        private final java.lang.String originPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.originAccessIdentity = software.amazon.jsii.Kernel.get(this, "originAccessIdentity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity.class));
            this.originPath = software.amazon.jsii.Kernel.get(this, "originPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity, final java.lang.String originPath) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.originAccessIdentity = originAccessIdentity;
            this.originPath = originPath;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity getOriginAccessIdentity() {
            return this.originAccessIdentity;
        }

        @Override
        public final java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOriginAccessIdentity() != null) {
                data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront_origins.S3OriginProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3OriginProps.Jsii$Proxy that = (S3OriginProps.Jsii$Proxy) o;

            if (this.originAccessIdentity != null ? !this.originAccessIdentity.equals(that.originAccessIdentity) : that.originAccessIdentity != null) return false;
            return this.originPath != null ? this.originPath.equals(that.originPath) : that.originPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.originAccessIdentity != null ? this.originAccessIdentity.hashCode() : 0;
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            return result;
        }
    }
}
