package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) A dashboard widget that displays metrics.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.279Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.GraphWidget")
public class GraphWidget extends software.amazon.awscdk.services.cloudwatch.ConcreteWidget {

    protected GraphWidget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphWidget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GraphWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.GraphWidgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Add another metric to the left Y axis of the GraphWidget.
     * <p>
     * @param metric the metric to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addLeftMetric(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metric) {
        software.amazon.jsii.Kernel.call(this, "addLeftMetric", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(metric, "metric is required") });
    }

    /**
     * (experimental) Add another metric to the right Y axis of the GraphWidget.
     * <p>
     * @param metric the metric to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addRightMetric(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metric) {
        software.amazon.jsii.Kernel.call(this, "addRightMetric", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(metric, "metric is required") });
    }

    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.GraphWidget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.GraphWidget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.GraphWidgetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.GraphWidgetProps.Builder();
        }

        /**
         * (experimental) Height of the widget.
         * <p>
         * Default: - 6 for Alarm and Graph widgets.
         * 3 for single value widgets where most recent value of a metric is displayed.
         * <p>
         * @return {@code this}
         * @param height Height of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder height(final java.lang.Number height) {
            this.props.height(height);
            return this;
        }

        /**
         * (experimental) The region the metrics of this graph should be taken from.
         * <p>
         * Default: - Current region
         * <p>
         * @return {@code this}
         * @param region The region the metrics of this graph should be taken from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * (experimental) Title for the graph.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param title Title for the graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * (experimental) Width of the widget, in a grid of 24 units wide.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param width Width of the widget, in a grid of 24 units wide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder width(final java.lang.Number width) {
            this.props.width(width);
            return this;
        }

        /**
         * (experimental) Metrics to display on left Y axis.
         * <p>
         * Default: - No metrics
         * <p>
         * @return {@code this}
         * @param left Metrics to display on left Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder left(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> left) {
            this.props.left(left);
            return this;
        }

        /**
         * (experimental) Annotations for the left Y axis.
         * <p>
         * Default: - No annotations
         * <p>
         * @return {@code this}
         * @param leftAnnotations Annotations for the left Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder leftAnnotations(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> leftAnnotations) {
            this.props.leftAnnotations(leftAnnotations);
            return this;
        }

        /**
         * (experimental) Left Y axis.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param leftYAxis Left Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder leftYAxis(final software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis) {
            this.props.leftYAxis(leftYAxis);
            return this;
        }

        /**
         * (experimental) Position of the legend.
         * <p>
         * Default: - bottom
         * <p>
         * @return {@code this}
         * @param legendPosition Position of the legend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder legendPosition(final software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition) {
            this.props.legendPosition(legendPosition);
            return this;
        }

        /**
         * (experimental) Whether the graph should show live data.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param liveData Whether the graph should show live data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder liveData(final java.lang.Boolean liveData) {
            this.props.liveData(liveData);
            return this;
        }

        /**
         * (experimental) The default period for all metrics in this widget.
         * <p>
         * The period is the length of time represented by one data point on the graph.
         * This default can be overridden within each metric definition.
         * <p>
         * Default: cdk.Duration.seconds(300)
         * <p>
         * @return {@code this}
         * @param period The default period for all metrics in this widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * (experimental) Metrics to display on right Y axis.
         * <p>
         * Default: - No metrics
         * <p>
         * @return {@code this}
         * @param right Metrics to display on right Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder right(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> right) {
            this.props.right(right);
            return this;
        }

        /**
         * (experimental) Annotations for the right Y axis.
         * <p>
         * Default: - No annotations
         * <p>
         * @return {@code this}
         * @param rightAnnotations Annotations for the right Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rightAnnotations(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> rightAnnotations) {
            this.props.rightAnnotations(rightAnnotations);
            return this;
        }

        /**
         * (experimental) Right Y axis.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param rightYAxis Right Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rightYAxis(final software.amazon.awscdk.services.cloudwatch.YAxisProps rightYAxis) {
            this.props.rightYAxis(rightYAxis);
            return this;
        }

        /**
         * (experimental) Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
         * <p>
         * If false, values will be from the most recent period of your chosen time range;
         * if true, shows the value from the entire time range.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range. Only applicable for Bar and Pie charts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder setPeriodToTimeRange(final java.lang.Boolean setPeriodToTimeRange) {
            this.props.setPeriodToTimeRange(setPeriodToTimeRange);
            return this;
        }

        /**
         * (experimental) Whether the graph should be shown as stacked lines.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param stacked Whether the graph should be shown as stacked lines. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stacked(final java.lang.Boolean stacked) {
            this.props.stacked(stacked);
            return this;
        }

        /**
         * (experimental) The default statistic to be displayed for each metric.
         * <p>
         * This default can be overridden within the definition of each individual metric
         * <p>
         * Default: - The statistic for each metric is used
         * <p>
         * @return {@code this}
         * @param statistic The default statistic to be displayed for each metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder statistic(final java.lang.String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        /**
         * (experimental) Display this metric.
         * <p>
         * Default: TimeSeries
         * <p>
         * @return {@code this}
         * @param view Display this metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder view(final software.amazon.awscdk.services.cloudwatch.GraphWidgetView view) {
            this.props.view(view);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.GraphWidget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudwatch.GraphWidget build() {
            return new software.amazon.awscdk.services.cloudwatch.GraphWidget(
                this.props.build()
            );
        }
    }
}
