package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) Properties for a metric.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:01.284Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.MetricProps")
@software.amazon.jsii.Jsii.Proxy(MetricProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MetricProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.CommonMetricOptions {

    /**
     * (experimental) Name of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * (experimental) Namespace of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

    /**
     * @return a {@link Builder} of {@link MetricProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<MetricProps> {
        private java.lang.String metricName;
        private java.lang.String namespace;
        private java.lang.String account;
        private java.lang.String color;
        private java.util.Map<java.lang.String, java.lang.Object> dimensions;
        private java.lang.String label;
        private software.amazon.awscdk.Duration period;
        private java.lang.String region;
        private java.lang.String statistic;
        private software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Sets the value of {@link MetricProps#getMetricName}
         * @param metricName Name of the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getNamespace}
         * @param namespace Namespace of the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getAccount}
         * @param account Account which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getColor}
         * @param color The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getDimensions}
         * @param dimensions Dimensions of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dimensions(java.util.Map<java.lang.String, ? extends java.lang.Object> dimensions) {
            this.dimensions = (java.util.Map<java.lang.String, java.lang.Object>)dimensions;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getLabel}
         * @param label Label for this metric when added to a Graph in a Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getPeriod}
         * @param period The period over which the specified statistic is applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getRegion}
         * @param region Region which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getStatistic}
         * @param statistic What function to use for aggregating.
         *                  Can be one of the following:
         *                  <p>
         *                  <ul>
         *                  <li>"Minimum" | "min"</li>
         *                  <li>"Maximum" | "max"</li>
         *                  <li>"Average" | "avg"</li>
         *                  <li>"Sum" | "sum"</li>
         *                  <li>"SampleCount | "n"</li>
         *                  <li>"pNN.NN"</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link MetricProps#getUnit}
         * @param unit Unit used to filter the metric stream.
         *             Only refer to datums emitted to the metric stream with the given unit and
         *             ignore all others. Only useful when datums are being emitted to the same
         *             metric stream under different units.
         *             <p>
         *             The default is to use all matric datums in the stream, regardless of unit,
         *             which is recommended in nearly all cases.
         *             <p>
         *             CloudWatch does not honor this property for graphs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder unit(software.amazon.awscdk.services.cloudwatch.Unit unit) {
            this.unit = unit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public MetricProps build() {
            return new Jsii$Proxy(metricName, namespace, account, color, dimensions, label, period, region, statistic, unit);
        }
    }

    /**
     * An implementation for {@link MetricProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricProps {
        private final java.lang.String metricName;
        private final java.lang.String namespace;
        private final java.lang.String account;
        private final java.lang.String color;
        private final java.util.Map<java.lang.String, java.lang.Object> dimensions;
        private final java.lang.String label;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.String region;
        private final java.lang.String statistic;
        private final software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Unit.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String metricName, final java.lang.String namespace, final java.lang.String account, final java.lang.String color, final java.util.Map<java.lang.String, ? extends java.lang.Object> dimensions, final java.lang.String label, final software.amazon.awscdk.Duration period, final java.lang.String region, final java.lang.String statistic, final software.amazon.awscdk.services.cloudwatch.Unit unit) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metricName = java.util.Objects.requireNonNull(metricName, "metricName is required");
            this.namespace = java.util.Objects.requireNonNull(namespace, "namespace is required");
            this.account = account;
            this.color = color;
            this.dimensions = (java.util.Map<java.lang.String, java.lang.Object>)dimensions;
            this.label = label;
            this.period = period;
            this.region = region;
            this.statistic = statistic;
            this.unit = unit;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
            return this.unit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("namespace", om.valueToTree(this.getNamespace()));
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getDimensions() != null) {
                data.set("dimensions", om.valueToTree(this.getDimensions()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getUnit() != null) {
                data.set("unit", om.valueToTree(this.getUnit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.MetricProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricProps.Jsii$Proxy that = (MetricProps.Jsii$Proxy) o;

            if (!metricName.equals(that.metricName)) return false;
            if (!namespace.equals(that.namespace)) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metricName.hashCode();
            result = 31 * result + (this.namespace.hashCode());
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }
    }
}
