/**
 * <h1>Amazon CloudWatch Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Metric objects</h2>
 * <p>
 * Metric objects represent a metric that is emitted by AWS services or your own
 * application, such as <code>CPUUsage</code>, <code>FailureCount</code> or <code>Bandwidth</code>.
 * <p>
 * Metric objects can be constructed directly or are exposed by resources as
 * attributes. Resources that expose metrics will have functions that look
 * like <code>metricXxx()</code> which will return a Metric object, initialized with defaults
 * that make sense.
 * <p>
 * For example, <code>lambda.Function</code> objects have the <code>fn.metricErrors()</code> method, which
 * represents the amount of errors reported by that Lambda function:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object errors = fn.metricErrors();
 * </pre></blockquote>
 * <p>
 * You can also instantiate <code>Metric</code> objects to reference any
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">published metric</a>
 * that's not exposed using a convenience method on the CDK construct.
 * For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object hostedZone = HostedZone.Builder.create(this, "MyHostedZone").zoneName("example.org").build();
 * Object metric = Metric.Builder.create()
 *         .namespace("AWS/Route53")
 *         .metricName("DNSQueries")
 *         .dimensions(Map.of(
 *                 "HostedZoneId", hostedZone.getHostedZoneId()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Instantiating a new Metric object</h3>
 * <p>
 * If you want to reference a metric that is not yet exposed by an existing construct,
 * you can instantiate a <code>Metric</code> object to represent it. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object metric = Metric.Builder.create()
 *         .namespace("MyNamespace")
 *         .metricName("MyMetric")
 *         .dimensions(Map.of(
 *                 "ProcessingStep", "Download"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Metric Math</h3>
 * <p>
 * Math expressions are supported by instantiating the <code>MathExpression</code> class.
 * For example, a math expression that sums two other metrics looks like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object allProblems = MathExpression.Builder.create()
 *         .expression("errors + faults")
 *         .usingMetrics(Map.of(
 *                 "errors", myConstruct.metricErrors(),
 *                 "faults", myConstruct.metricFaults()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can use <code>MathExpression</code> objects like any other metric, including using
 * them in other math expressions:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object problemPercentage = MathExpression.Builder.create()
 *         .expression("(problems / invocations) * 100")
 *         .usingMetrics(Map.of(
 *                 "problems", allProblems,
 *                 "invocations", myConstruct.metricInvocations()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Aggregation</h3>
 * <p>
 * To graph or alarm on metrics you must aggregate them first, using a function
 * like <code>Average</code> or a percentile function like <code>P99</code>. By default, most Metric objects
 * returned by CDK libraries will be configured as <code>Average</code> over <code>300 seconds</code> (5 minutes).
 * The exception is if the metric represents a count of discrete events, such as
 * failures. In that case, the Metric object will be configured as <code>Sum</code> over <code>300 seconds</code>, i.e. it represents the number of times that event occurred over the
 * time period.
 * <p>
 * If you want to change the default aggregation of the Metric object (for example,
 * the function or the period), you can do so by passing additional parameters
 * to the metric function call:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object minuteErrorRate = fn.metricErrors(Map.of(
 *         "statistic", "avg",
 *         "period", Duration.minutes(1),
 *         "label", "Lambda failure rate"));
 * </pre></blockquote>
 * <p>
 * This function also allows changing the metric label or color (which will be
 * useful when embedding them in graphs, see below).
 * <p>
 * <blockquote>
 * <p>
 * Rates versus Sums
 * <p>
 * The reason for using <code>Sum</code> to count discrete events is that <em>some</em> events are
 * emitted as either <code>0</code> or <code>1</code> (for example <code>Errors</code> for a Lambda) and some are
 * only emitted as <code>1</code> (for example <code>NumberOfMessagesPublished</code> for an SNS
 * topic).
 * <p>
 * In case <code>0</code>-metrics are emitted, it makes sense to take the <code>Average</code> of this
 * metric: the result will be the fraction of errors over all executions.
 * <p>
 * If <code>0</code>-metrics are not emitted, the <code>Average</code> will always be equal to <code>1</code>,
 * and not be very useful.
 * <p>
 * In order to simplify the mental model of <code>Metric</code> objects, we default to
 * aggregating using <code>Sum</code>, which will be the same for both metrics types. If you
 * happen to know the Metric you want to alarm on makes sense as a rate
 * (<code>Average</code>) you can always choose to change the statistic.
 * <p>
 * </blockquote>
 * <p>
 * <h2>Alarms</h2>
 * <p>
 * Alarms can be created on metrics in one of two ways. Either create an <code>Alarm</code>
 * object, passing the <code>Metric</code> object to set the alarm on:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Alarm.Builder.create(this, "Alarm")
 *         .metric(fn.metricErrors())
 *         .threshold(100)
 *         .evaluationPeriods(2)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Alternatively, you can call <code>metric.createAlarm()</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * fn.metricErrors().createAlarm(this, "Alarm", Map.of(
 *         "threshold", 100,
 *         "evaluationPeriods", 2));
 * </pre></blockquote>
 * <p>
 * The most important properties to set while creating an Alarms are:
 * <p>
 * <ul>
 * <li><code>threshold</code>: the value to compare the metric against.</li>
 * <li><code>comparisonOperator</code>: the comparison operation to use, defaults to <code>metric &gt;= threshold</code>.</li>
 * <li><code>evaluationPeriods</code>: how many consecutive periods the metric has to be
 * breaching the the threshold for the alarm to trigger.</li>
 * </ul>
 * <p>
 * <h3>Alarm Actions</h3>
 * <p>
 * To add actions to an alarm, use the integration classes from the
 * <code>&#64;aws-cdk/aws-cloudwatch-actions</code> package. For example, to post a message to
 * an SNS topic when an alarm breaches, do the following:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_cloudwatch_actions;
 * 
 * 
 * // ...
 * Topic topic = new Topic(stack, "Topic");
 * Object alarm = Alarm.Builder.create(stack, "Alarm").build();
 * 
 * alarm.addAlarmAction(new SnsAction(topic));
 * </pre></blockquote>
 * <p>
 * <h3>Composite Alarms</h3>
 * <p>
 * <a href="https://aws.amazon.com/about-aws/whats-new/2020/03/amazon-cloudwatch-now-allows-you-to-combine-multiple-alarms/">Composite Alarms</a>
 * can be created from existing Alarm resources.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object alarmRule = AlarmRule.anyOf(AlarmRule.allOf(AlarmRule.anyOf(alarm1, AlarmRule.fromAlarm(alarm2, AlarmState.getOK()), alarm3), AlarmRule.not(AlarmRule.fromAlarm(alarm4, AlarmState.getINSUFFICIENT_DATA()))), AlarmRule.fromBoolean(false));
 * 
 * CompositeAlarm.Builder.create(this, "MyAwesomeCompositeAlarm")
 *         .alarmRule(alarmRule)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>A note on units</h3>
 * <p>
 * In CloudWatch, Metrics datums are emitted with units, such as <code>seconds</code> or
 * <code>bytes</code>. When <code>Metric</code> objects are given a <code>unit</code> attribute, it will be used to
 * <em>filter</em> the stream of metric datums for datums emitted using the same <code>unit</code>
 * attribute.
 * <p>
 * In particular, the <code>unit</code> field is <em>not</em> used to rescale datums or alarm threshold
 * values (for example, it cannot be used to specify an alarm threshold in
 * <em>Megabytes</em> if the metric stream is being emitted as <em>bytes</em>).
 * <p>
 * You almost certainly don't want to specify the <code>unit</code> property when creating
 * <code>Metric</code> objects (which will retrieve all datums regardless of their unit),
 * unless you have very specific requirements. Note that in any case, CloudWatch
 * only supports filtering by <code>unit</code> for Alarms, not in Dashboard graphs.
 * <p>
 * Please see the following GitHub issue for a discussion on real unit
 * calculations in CDK: https://github.com/aws/aws-cdk/issues/5595
 * <p>
 * <h2>Dashboards</h2>
 * <p>
 * Dashboards are set of Widgets stored server-side which can be accessed quickly
 * from the AWS console. Available widgets are graphs of a metric over time, the
 * current value of a metric, or a static piece of Markdown which explains what the
 * graphs mean.
 * <p>
 * The following widgets are available:
 * <p>
 * <ul>
 * <li><code>GraphWidget</code> -- shows any number of metrics on both the left and right
 * vertical axes.</li>
 * <li><code>AlarmWidget</code> -- shows the graph and alarm line for a single alarm.</li>
 * <li><code>SingleValueWidget</code> -- shows the current value of a set of metrics.</li>
 * <li><code>TextWidget</code> -- shows some static Markdown.</li>
 * <li><code>AlarmStatusWidget</code> -- shows the status of your alarms in a grid view.</li>
 * </ul>
 * <p>
 * <h3>Graph widget</h3>
 * <p>
 * A graph widget can display any number of metrics on either the <code>left</code> or
 * <code>right</code> vertical axis:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(GraphWidget.Builder.create()
 *         .title("Executions vs error rate")
 * 
 *         .left(asList(executionCountMetric))
 * 
 *         .right(asList(errorCountMetric.with(Map.of(
 *                 "statistic", "average",
 *                 "label", "Error rate",
 *                 "color", Color.getGREEN()))))
 *         .build());
 * </pre></blockquote>
 * <p>
 * Using the methods <code>addLeftMetric()</code> and <code>addRightMetric()</code> you can add metrics to a graph widget later on.
 * <p>
 * Graph widgets can also display annotations attached to the left or the right y-axis.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(GraphWidget.Builder.create()
 *         // ...
 *         // ...
 * 
 *         .leftAnnotations(asList(Map.of("value", 1800, "label", Duration.minutes(30).toHumanString(), "color", Color.getRED()), Map.of("value", 3600, "label", "1 hour", "color", "#2ca02c")))
 *         .build());
 * </pre></blockquote>
 * <p>
 * The graph legend can be adjusted from the default position at bottom of the widget.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(GraphWidget.Builder.create()
 *         // ...
 *         // ...
 * 
 *         .legendPosition(LegendPosition.getRIGHT())
 *         .build());
 * </pre></blockquote>
 * <p>
 * The graph can publish live data within the last minute that has not been fully aggregated.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(GraphWidget.Builder.create()
 *         // ...
 *         // ...
 * 
 *         .liveData(true)
 *         .build());
 * </pre></blockquote>
 * <p>
 * The graph view can be changed from default 'timeSeries' to 'bar' or 'pie'.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(GraphWidget.Builder.create()
 *         // ...
 *         // ...
 * 
 *         .view(GraphWidgetView.getBAR())
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Alarm widget</h3>
 * <p>
 * An alarm widget shows the graph and the alarm line of a single alarm:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(AlarmWidget.Builder.create()
 *         .title("Errors")
 *         .alarm(errorAlarm)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Single value widget</h3>
 * <p>
 * A single-value widget shows the latest value of a set of metrics (as opposed
 * to a graph of the value over time):
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(SingleValueWidget.Builder.create()
 *         .metrics(asList(visitorCount, purchaseCount))
 *         .build());
 * </pre></blockquote>
 * <p>
 * Show as many digits as can fit, before rounding.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(SingleValueWidget.Builder.create()
 *         // ..
 *         // ..
 * 
 *         .fullPrecision(true)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Text widget</h3>
 * <p>
 * A text widget shows an arbitrary piece of MarkDown. Use this to add explanations
 * to your dashboard:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(TextWidget.Builder.create()
 *         .markdown("# Key Performance Indicators")
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Alarm Status widget</h3>
 * <p>
 * An alarm status widget displays instantly the status of any type of alarms and gives the
 * ability to aggregate one or more alarms together in a small surface.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(
 * AlarmStatusWidget.Builder.create()
 *         .alarms(asList(errorAlarm))
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Query results widget</h3>
 * <p>
 * A <code>LogQueryWidget</code> shows the results of a query from Logs Insights:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * dashboard.addWidgets(LogQueryWidget.Builder.create()
 *         .logGroupNames(asList("my-log-group"))
 *         .view(LogQueryVisualizationType.getTABLE())
 *         // The lines will be automatically combined using '\n|'.
 *         .queryLines(asList("fields &#64;message", "filter &#64;message like /Error/"))
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Dashboard Layout</h3>
 * <p>
 * The widgets on a dashboard are visually laid out in a grid that is 24 columns
 * wide. Normally you specify X and Y coordinates for the widgets on a Dashboard,
 * but because this is inconvenient to do manually, the library contains a simple
 * layout system to help you lay out your dashboards the way you want them to.
 * <p>
 * Widgets have a <code>width</code> and <code>height</code> property, and they will be automatically
 * laid out either horizontally or vertically stacked to fill out the available
 * space.
 * <p>
 * Widgets are added to a Dashboard by calling <code>add(widget1, widget2, ...)</code>.
 * Widgets given in the same call will be laid out horizontally. Widgets given
 * in different calls will be laid out vertically. To make more complex layouts,
 * you can use the following widgets to pack widgets together in different ways:
 * <p>
 * <ul>
 * <li><code>Column</code>: stack two or more widgets vertically.</li>
 * <li><code>Row</code>: lay out two or more widgets horizontally.</li>
 * <li><code>Spacer</code>: take up empty space</li>
 * </ul>
 */
package software.amazon.awscdk.services.cloudwatch;
