package software.amazon.awscdk.services.codebuild;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:07.336Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.ProjectProps")
@software.amazon.jsii.Jsii.Proxy(ProjectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ProjectProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.CommonProjectProps {

    /**
     * (experimental) Defines where build artifacts will be stored.
     * <p>
     * Could be: PipelineBuildArtifacts, NoArtifacts and S3Artifacts.
     * <p>
     * Default: NoArtifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.IArtifacts getArtifacts() {
        return null;
    }

    /**
     * (experimental) The secondary artifacts for the Project.
     * <p>
     * Can also be added after the Project has been created by using the {&#64;link Project#addSecondaryArtifact} method.
     * <p>
     * Default: - No secondary artifacts.
     * <p>
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.IArtifacts> getSecondaryArtifacts() {
        return null;
    }

    /**
     * (experimental) The secondary sources for the Project.
     * <p>
     * Can be also added after the Project has been created by using the {&#64;link Project#addSecondarySource} method.
     * <p>
     * Default: - No secondary sources.
     * <p>
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.ISource> getSecondarySources() {
        return null;
    }

    /**
     * (experimental) The source of the build.
     * <p>
     * <em>Note</em>: if {&#64;link NoSource} is given as the source,
     * then you need to provide an explicit <code>buildSpec</code>.
     * <p>
     * Default: - NoSource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ISource getSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ProjectProps> {
        private software.amazon.awscdk.services.codebuild.IArtifacts artifacts;
        private java.util.List<software.amazon.awscdk.services.codebuild.IArtifacts> secondaryArtifacts;
        private java.util.List<software.amazon.awscdk.services.codebuild.ISource> secondarySources;
        private software.amazon.awscdk.services.codebuild.ISource source;
        private java.lang.Boolean allowAllOutbound;
        private java.lang.Boolean badge;
        private software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private software.amazon.awscdk.services.codebuild.Cache cache;
        private java.lang.Boolean checkSecretsInPlainTextEnvVariables;
        private java.lang.Number concurrentBuildLimit;
        private java.lang.String description;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        private java.lang.Boolean grantReportGroupPermissions;
        private software.amazon.awscdk.services.codebuild.LoggingOptions logging;
        private java.lang.String projectName;
        private software.amazon.awscdk.Duration queuedTimeout;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private software.amazon.awscdk.Duration timeout;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ProjectProps#getArtifacts}
         * @param artifacts Defines where build artifacts will be stored.
         *                  Could be: PipelineBuildArtifacts, NoArtifacts and S3Artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifacts(software.amazon.awscdk.services.codebuild.IArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getSecondaryArtifacts}
         * @param secondaryArtifacts The secondary artifacts for the Project.
         *                           Can also be added after the Project has been created by using the {&#64;link Project#addSecondaryArtifact} method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder secondaryArtifacts(java.util.List<? extends software.amazon.awscdk.services.codebuild.IArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = (java.util.List<software.amazon.awscdk.services.codebuild.IArtifacts>)secondaryArtifacts;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getSecondarySources}
         * @param secondarySources The secondary sources for the Project.
         *                         Can be also added after the Project has been created by using the {&#64;link Project#addSecondarySource} method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder secondarySources(java.util.List<? extends software.amazon.awscdk.services.codebuild.ISource> secondarySources) {
            this.secondarySources = (java.util.List<software.amazon.awscdk.services.codebuild.ISource>)secondarySources;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getSource}
         * @param source The source of the build.
         *               <em>Note</em>: if {&#64;link NoSource} is given as the source,
         *               then you need to provide an explicit <code>buildSpec</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder source(software.amazon.awscdk.services.codebuild.ISource source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether to allow the CodeBuild to send all network traffic.
         *                         If set to false, you must individually add traffic rules to allow the
         *                         CodeBuild project to connect to network targets.
         *                         <p>
         *                         Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getBadge}
         * @param badge Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
         *              For more information, see Build Badges Sample
         *              in the AWS CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder badge(java.lang.Boolean badge) {
            this.badge = badge;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getBuildSpec}
         * @param buildSpec Filename or contents of buildspec in JSON format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getCache}
         * @param cache Caching strategy to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cache(software.amazon.awscdk.services.codebuild.Cache cache) {
            this.cache = cache;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getCheckSecretsInPlainTextEnvVariables}
         * @param checkSecretsInPlainTextEnvVariables Whether to check for the presence of any secrets in the environment variables of the default type, BuildEnvironmentVariableType.PLAINTEXT. Since using a secret for the value of that kind of variable would result in it being displayed in plain text in the AWS Console, the construct will throw an exception if it detects a secret was passed there. Pass this property as false if you want to skip this validation, and keep using a secret in a plain text environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder checkSecretsInPlainTextEnvVariables(java.lang.Boolean checkSecretsInPlainTextEnvVariables) {
            this.checkSecretsInPlainTextEnvVariables = checkSecretsInPlainTextEnvVariables;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getConcurrentBuildLimit}
         * @param concurrentBuildLimit Maximum number of concurrent builds.
         *                             Minimum value is 1 and maximum is account build limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder concurrentBuildLimit(java.lang.Number concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getDescription}
         * @param description A description of the project.
         *                    Use the description to identify the purpose
         *                    of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getEncryptionKey}
         * @param encryptionKey Encryption key to use to read and write artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getEnvironment}
         * @param environment Build environment to use for the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(software.amazon.awscdk.services.codebuild.BuildEnvironment environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getEnvironmentVariables}
         * @param environmentVariables Additional environment variables to add to the build environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder environmentVariables(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getFileSystemLocations}
         * @param fileSystemLocations An  ProjectFileSystemLocation objects for a CodeBuild build project.
         *                            A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
         *                            and type of a file system created using Amazon Elastic File System.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder fileSystemLocations(java.util.List<? extends software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = (java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation>)fileSystemLocations;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getGrantReportGroupPermissions}
         * @param grantReportGroupPermissions Add permissions to this project's role to create and use test report groups with name starting with the name of this project.
         *                                    That is the standard report group that gets created when a simple name
         *                                    (in contrast to an ARN)
         *                                    is used in the 'reports' section of the buildspec of this project.
         *                                    This is usually harmless, but you can turn these off if you don't plan on using test
         *                                    reports in this project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder grantReportGroupPermissions(java.lang.Boolean grantReportGroupPermissions) {
            this.grantReportGroupPermissions = grantReportGroupPermissions;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getLogging}
         * @param logging Information about logs for the build project.
         *                A project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(software.amazon.awscdk.services.codebuild.LoggingOptions logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getProjectName}
         * @param projectName The physical, human-readable name of the CodeBuild Project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getQueuedTimeout}
         * @param queuedTimeout The number of minutes after which AWS CodeBuild stops the build if it's still in queue.
         *                      For valid values, see the timeoutInMinutes field in the AWS
         *                      CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder queuedTimeout(software.amazon.awscdk.Duration queuedTimeout) {
            this.queuedTimeout = queuedTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getRole}
         * @param role Service Role to assume while running the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getSecurityGroups}
         * @param securityGroups What security group to associate with the codebuild project's network interfaces.
         *                       If no security group is identified, one will be created automatically.
         *                       <p>
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getSubnetSelection}
         * @param subnetSelection Where to place the network interfaces within the VPC.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getTimeout}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         *                For valid values, see the timeoutInMinutes field in the AWS
         *                CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProps#getVpc}
         * @param vpc VPC network to place codebuild network interfaces.
         *            Specify this if the codebuild project needs to access resources in a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProjectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ProjectProps build() {
            return new Jsii$Proxy(artifacts, secondaryArtifacts, secondarySources, source, allowAllOutbound, badge, buildSpec, cache, checkSecretsInPlainTextEnvVariables, concurrentBuildLimit, description, encryptionKey, environment, environmentVariables, fileSystemLocations, grantReportGroupPermissions, logging, projectName, queuedTimeout, role, securityGroups, subnetSelection, timeout, vpc);
        }
    }

    /**
     * An implementation for {@link ProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectProps {
        private final software.amazon.awscdk.services.codebuild.IArtifacts artifacts;
        private final java.util.List<software.amazon.awscdk.services.codebuild.IArtifacts> secondaryArtifacts;
        private final java.util.List<software.amazon.awscdk.services.codebuild.ISource> secondarySources;
        private final software.amazon.awscdk.services.codebuild.ISource source;
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean badge;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final software.amazon.awscdk.services.codebuild.Cache cache;
        private final java.lang.Boolean checkSecretsInPlainTextEnvVariables;
        private final java.lang.Number concurrentBuildLimit;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        private final java.lang.Boolean grantReportGroupPermissions;
        private final software.amazon.awscdk.services.codebuild.LoggingOptions logging;
        private final java.lang.String projectName;
        private final software.amazon.awscdk.Duration queuedTimeout;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifacts = software.amazon.jsii.Kernel.get(this, "artifacts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IArtifacts.class));
            this.secondaryArtifacts = software.amazon.jsii.Kernel.get(this, "secondaryArtifacts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IArtifacts.class)));
            this.secondarySources = software.amazon.jsii.Kernel.get(this, "secondarySources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ISource.class)));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ISource.class));
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.badge = software.amazon.jsii.Kernel.get(this, "badge", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.cache = software.amazon.jsii.Kernel.get(this, "cache", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class));
            this.checkSecretsInPlainTextEnvVariables = software.amazon.jsii.Kernel.get(this, "checkSecretsInPlainTextEnvVariables", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.concurrentBuildLimit = software.amazon.jsii.Kernel.get(this, "concurrentBuildLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironment.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable.class)));
            this.fileSystemLocations = software.amazon.jsii.Kernel.get(this, "fileSystemLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IFileSystemLocation.class)));
            this.grantReportGroupPermissions = software.amazon.jsii.Kernel.get(this, "grantReportGroupPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.LoggingOptions.class));
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queuedTimeout = software.amazon.jsii.Kernel.get(this, "queuedTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.codebuild.IArtifacts artifacts, final java.util.List<? extends software.amazon.awscdk.services.codebuild.IArtifacts> secondaryArtifacts, final java.util.List<? extends software.amazon.awscdk.services.codebuild.ISource> secondarySources, final software.amazon.awscdk.services.codebuild.ISource source, final java.lang.Boolean allowAllOutbound, final java.lang.Boolean badge, final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec, final software.amazon.awscdk.services.codebuild.Cache cache, final java.lang.Boolean checkSecretsInPlainTextEnvVariables, final java.lang.Number concurrentBuildLimit, final java.lang.String description, final software.amazon.awscdk.services.kms.IKey encryptionKey, final software.amazon.awscdk.services.codebuild.BuildEnvironment environment, final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables, final java.util.List<? extends software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations, final java.lang.Boolean grantReportGroupPermissions, final software.amazon.awscdk.services.codebuild.LoggingOptions logging, final java.lang.String projectName, final software.amazon.awscdk.Duration queuedTimeout, final software.amazon.awscdk.services.iam.IRole role, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final software.amazon.awscdk.Duration timeout, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifacts = artifacts;
            this.secondaryArtifacts = (java.util.List<software.amazon.awscdk.services.codebuild.IArtifacts>)secondaryArtifacts;
            this.secondarySources = (java.util.List<software.amazon.awscdk.services.codebuild.ISource>)secondarySources;
            this.source = source;
            this.allowAllOutbound = allowAllOutbound;
            this.badge = badge;
            this.buildSpec = buildSpec;
            this.cache = cache;
            this.checkSecretsInPlainTextEnvVariables = checkSecretsInPlainTextEnvVariables;
            this.concurrentBuildLimit = concurrentBuildLimit;
            this.description = description;
            this.encryptionKey = encryptionKey;
            this.environment = environment;
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)environmentVariables;
            this.fileSystemLocations = (java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation>)fileSystemLocations;
            this.grantReportGroupPermissions = grantReportGroupPermissions;
            this.logging = logging;
            this.projectName = projectName;
            this.queuedTimeout = queuedTimeout;
            this.role = role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            this.subnetSelection = subnetSelection;
            this.timeout = timeout;
            this.vpc = vpc;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.IArtifacts getArtifacts() {
            return this.artifacts;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codebuild.IArtifacts> getSecondaryArtifacts() {
            return this.secondaryArtifacts;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codebuild.ISource> getSecondarySources() {
            return this.secondarySources;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.ISource getSource() {
            return this.source;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.Boolean getBadge() {
            return this.badge;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.Cache getCache() {
            return this.cache;
        }

        @Override
        public final java.lang.Boolean getCheckSecretsInPlainTextEnvVariables() {
            return this.checkSecretsInPlainTextEnvVariables;
        }

        @Override
        public final java.lang.Number getConcurrentBuildLimit() {
            return this.concurrentBuildLimit;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> getFileSystemLocations() {
            return this.fileSystemLocations;
        }

        @Override
        public final java.lang.Boolean getGrantReportGroupPermissions() {
            return this.grantReportGroupPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.LoggingOptions getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final software.amazon.awscdk.Duration getQueuedTimeout() {
            return this.queuedTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArtifacts() != null) {
                data.set("artifacts", om.valueToTree(this.getArtifacts()));
            }
            if (this.getSecondaryArtifacts() != null) {
                data.set("secondaryArtifacts", om.valueToTree(this.getSecondaryArtifacts()));
            }
            if (this.getSecondarySources() != null) {
                data.set("secondarySources", om.valueToTree(this.getSecondarySources()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }
            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getBadge() != null) {
                data.set("badge", om.valueToTree(this.getBadge()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getCache() != null) {
                data.set("cache", om.valueToTree(this.getCache()));
            }
            if (this.getCheckSecretsInPlainTextEnvVariables() != null) {
                data.set("checkSecretsInPlainTextEnvVariables", om.valueToTree(this.getCheckSecretsInPlainTextEnvVariables()));
            }
            if (this.getConcurrentBuildLimit() != null) {
                data.set("concurrentBuildLimit", om.valueToTree(this.getConcurrentBuildLimit()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getFileSystemLocations() != null) {
                data.set("fileSystemLocations", om.valueToTree(this.getFileSystemLocations()));
            }
            if (this.getGrantReportGroupPermissions() != null) {
                data.set("grantReportGroupPermissions", om.valueToTree(this.getGrantReportGroupPermissions()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getProjectName() != null) {
                data.set("projectName", om.valueToTree(this.getProjectName()));
            }
            if (this.getQueuedTimeout() != null) {
                data.set("queuedTimeout", om.valueToTree(this.getQueuedTimeout()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.ProjectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProjectProps.Jsii$Proxy that = (ProjectProps.Jsii$Proxy) o;

            if (this.artifacts != null ? !this.artifacts.equals(that.artifacts) : that.artifacts != null) return false;
            if (this.secondaryArtifacts != null ? !this.secondaryArtifacts.equals(that.secondaryArtifacts) : that.secondaryArtifacts != null) return false;
            if (this.secondarySources != null ? !this.secondarySources.equals(that.secondarySources) : that.secondarySources != null) return false;
            if (this.source != null ? !this.source.equals(that.source) : that.source != null) return false;
            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.badge != null ? !this.badge.equals(that.badge) : that.badge != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) return false;
            if (this.checkSecretsInPlainTextEnvVariables != null ? !this.checkSecretsInPlainTextEnvVariables.equals(that.checkSecretsInPlainTextEnvVariables) : that.checkSecretsInPlainTextEnvVariables != null) return false;
            if (this.concurrentBuildLimit != null ? !this.concurrentBuildLimit.equals(that.concurrentBuildLimit) : that.concurrentBuildLimit != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.fileSystemLocations != null ? !this.fileSystemLocations.equals(that.fileSystemLocations) : that.fileSystemLocations != null) return false;
            if (this.grantReportGroupPermissions != null ? !this.grantReportGroupPermissions.equals(that.grantReportGroupPermissions) : that.grantReportGroupPermissions != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) return false;
            if (this.queuedTimeout != null ? !this.queuedTimeout.equals(that.queuedTimeout) : that.queuedTimeout != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifacts != null ? this.artifacts.hashCode() : 0;
            result = 31 * result + (this.secondaryArtifacts != null ? this.secondaryArtifacts.hashCode() : 0);
            result = 31 * result + (this.secondarySources != null ? this.secondarySources.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            result = 31 * result + (this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0);
            result = 31 * result + (this.badge != null ? this.badge.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
            result = 31 * result + (this.checkSecretsInPlainTextEnvVariables != null ? this.checkSecretsInPlainTextEnvVariables.hashCode() : 0);
            result = 31 * result + (this.concurrentBuildLimit != null ? this.concurrentBuildLimit.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.fileSystemLocations != null ? this.fileSystemLocations.hashCode() : 0);
            result = 31 * result + (this.grantReportGroupPermissions != null ? this.grantReportGroupPermissions.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.queuedTimeout != null ? this.queuedTimeout.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
