/**
 * <h1>AWS CodePipeline Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Pipeline</h2>
 * <p>
 * To construct an empty Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_codepipeline;
 * 
 * 
 * Pipeline pipeline = new Pipeline(this, "MyFirstPipeline");
 * </pre></blockquote>
 * <p>
 * To give the Pipeline a nice, human-readable name:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object pipeline = Pipeline.Builder.create(this, "MyFirstPipeline")
 *         .pipelineName("MyPipeline")
 *         .build();
 * </pre></blockquote>
 * <p>
 * Be aware that in the default configuration, the <code>Pipeline</code> construct creates
 * an AWS Key Management Service (AWS KMS) Customer Master Key (CMK) for you to
 * encrypt the artifacts in the artifact bucket, which incurs a cost of
 * <strong>$1/month</strong>. This default configuration is necessary to allow cross-account
 * actions.
 * <p>
 * If you do not intend to perform cross-account deployments, you can disable
 * the creation of the Customer Master Keys by passing <code>crossAccountKeys: false</code>
 * when defining the Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object pipeline = Pipeline.Builder.create(this, "MyFirstPipeline")
 *         .crossAccountKeys(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Stages</h2>
 * <p>
 * You can provide Stages when creating the Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object pipeline = Pipeline.Builder.create(this, "MyFirstPipeline")
 *         .stages(asList(Map.of(
 *                 "stageName", "Source",
 *                 "actions", asList())))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Or append a Stage to an existing Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object sourceStage = pipeline.addStage(Map.of(
 *         "stageName", "Source",
 *         "actions", asList()));
 * </pre></blockquote>
 * <p>
 * You can insert the new Stage at an arbitrary point in the Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object someStage = pipeline.addStage(Map.of(
 *         "stageName", "SomeStage",
 *         "placement", Map.of(
 *                 // note: you can only specify one of the below properties
 *                 "rightBefore", anotherStage,
 *                 "justAfter", anotherStage)));
 * </pre></blockquote>
 * <p>
 * <h2>Actions</h2>
 * <p>
 * Actions live in a separate package, <code>&#64;aws-cdk/aws-codepipeline-actions</code>.
 * <p>
 * To add an Action to a Stage, you can provide it when creating the Stage,
 * in the <code>actions</code> property,
 * or you can use the <code>IStage.addAction()</code> method to mutate an existing Stage:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * sourceStage.addAction(someAction);
 * </pre></blockquote>
 * <p>
 * <h2>Cross-account CodePipelines</h2>
 * <p>
 * <blockquote>
 * <p>
 * Cross-account Pipeline actions require that the Pipeline has <em>not</em> been
 * created with <code>crossAccountKeys: false</code>.
 * <p>
 * </blockquote>
 * <p>
 * Most pipeline Actions accept an AWS resource object to operate on. For example:
 * <p>
 * <ul>
 * <li><code>S3DeployAction</code> accepts an <code>s3.IBucket</code>.</li>
 * <li><code>CodeBuildAction</code> accepts a <code>codebuild.IProject</code>.</li>
 * <li>etc.</li>
 * </ul>
 * <p>
 * These resources can be either newly defined (<code>new s3.Bucket(...)</code>) or imported
 * (<code>s3.Bucket.fromBucketAttributes(...)</code>) and identify the resource that should
 * be changed.
 * <p>
 * These resources can be in different accounts than the pipeline itself. For
 * example, the following action deploys to an imported S3 bucket from a
 * different account:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * stage.addAction(S3DeployAction.Builder.create()
 *         .bucket(s3.Bucket.fromBucketAttributes(this, "Bucket", new BucketAttributes()
 *                 .account("123456789012")))
 *         .build());
 * </pre></blockquote>
 * <p>
 * Actions that don't accept a resource object accept an explicit <code>account</code> parameter:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * stage.addAction(CloudFormationCreateUpdateStackAction.Builder.create()
 *         .account("123456789012")
 *         .build());
 * </pre></blockquote>
 * <p>
 * The <code>Pipeline</code> construct automatically defines an <strong>IAM Role</strong> for you in the
 * target account which the pipeline will assume to perform that action. This
 * Role will be defined in a <strong>support stack</strong> named
 * <code>&lt;PipelineStackName&gt;-support-&lt;account&gt;</code>, that will automatically be deployed
 * before the stack containing the pipeline.
 * <p>
 * If you do not want to use the generated role, you can also explicitly pass a
 * <code>role</code> when creating the action. In that case, the action will operate in the
 * account the role belongs to:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * stage.addAction(CloudFormationCreateUpdateStackAction.Builder.create()
 *         // ...
 *         .role(iam.Role.fromRoleArn(this, "ActionRole", "..."))
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h2>Cross-region CodePipelines</h2>
 * <p>
 * Similar to how you set up a cross-account Action, the AWS resource object you
 * pass to actions can also be in different <em>Regions</em>. For example, the
 * following Action deploys to an imported S3 bucket from a different Region:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * stage.addAction(S3DeployAction.Builder.create()
 *         .bucket(s3.Bucket.fromBucketAttributes(this, "Bucket", new BucketAttributes()
 *                 .region("us-west-1")))
 *         .build());
 * </pre></blockquote>
 * <p>
 * Actions that don't take an AWS resource will accept an explicit <code>region</code>
 * parameter:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * stage.addAction(CloudFormationCreateUpdateStackAction.Builder.create()
 *         // ...
 *         .region("us-west-1")
 *         .build());
 * </pre></blockquote>
 * <p>
 * The <code>Pipeline</code> construct automatically defines a <strong>replication bucket</strong> for
 * you in the target region, which the pipeline will replicate artifacts to and
 * from. This Bucket will be defined in a <strong>support stack</strong> named
 * <code>&lt;PipelineStackName&gt;-support-&lt;region&gt;</code>, that will automatically be deployed
 * before the stack containing the pipeline.
 * <p>
 * If you don't want to use these support stacks, and already have buckets in
 * place to serve as replication buckets, you can supply these at Pipeline definition
 * time using the <code>crossRegionReplicationBuckets</code> parameter. Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object pipeline = Pipeline.Builder.create(this, "MyFirstPipeline").build();crossRegionReplicationBuckets: {
 *     // note that a physical name of the replication Bucket must be known at synthesis time
 *     'us-west-1': s3.Bucket.fromBucketAttributes(this, 'UsWest1ReplicationBucket', {
 *       bucketName: 'my-us-west-1-replication-bucket',
 *       // optional KMS key
 *       encryptionKey: kms.Key.fromKeyArn(this, 'UsWest1ReplicationKey',
 *         'arn:aws:kms:us-west-1:123456789012:key/1234-5678-9012'
 *       ),
 *     }),
 *   }
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-cross-region.html">the AWS docs here</a>
 * for more information on cross-region CodePipelines.
 * <p>
 * <h3>Creating an encrypted replication bucket</h3>
 * <p>
 * If you're passing a replication bucket created in a different stack,
 * like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stack replicationStack = new Stack(app, "ReplicationStack", new StackProps()
 *         .env(new Environment()
 *                 .region("us-west-1")));
 * Object key = new Key(replicationStack, "ReplicationKey");
 * Bucket replicationBucket = new Bucket(replicationStack, "ReplicationBucket", new BucketProps()
 *         // like was said above - replication buckets need a set physical name
 *         .bucketName(PhysicalName.getGENERATE_IF_NEEDED())
 *         .encryptionKey(key));
 * 
 * // later...
 * // later...
 * Pipeline.Builder.create(pipelineStack, "Pipeline")
 *         .crossRegionReplicationBuckets(Map.of(
 *                 "us-west-1", replicationBucket))
 *         .build();
 * </pre></blockquote>
 * <p>
 * When trying to encrypt it
 * (and note that if any of the cross-region actions happen to be cross-account as well,
 * the bucket <em>has to</em> be encrypted - otherwise the pipeline will fail at runtime),
 * you cannot use a key directly - KMS keys don't have physical names,
 * and so you can't reference them across environments.
 * <p>
 * In this case, you need to use an alias in place of the key when creating the bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object key = new Key(replicationStack, "ReplicationKey");
 * Object alias = Alias.Builder.create(replicationStack, "ReplicationAlias")
 *         // aliasName is required
 *         .aliasName(PhysicalName.getGENERATE_IF_NEEDED())
 *         .targetKey(key)
 *         .build();
 * Bucket replicationBucket = new Bucket(replicationStack, "ReplicationBucket", new BucketProps()
 *         .bucketName(PhysicalName.getGENERATE_IF_NEEDED())
 *         .encryptionKey(alias));
 * </pre></blockquote>
 * <p>
 * <h2>Variables</h2>
 * <p>
 * The library supports the CodePipeline Variables feature.
 * Each action class that emits variables has a separate variables interface,
 * accessed as a property of the action instance called <code>variables</code>.
 * You instantiate the action class and assign it to a local variable;
 * when you want to use a variable in the configuration of a different action,
 * you access the appropriate property of the interface returned from <code>variables</code>,
 * which represents a single variable.
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // MyAction is some action type that produces variables
 * Object myAction = MyAction.Builder.create().build();
 * OtherAction.Builder.create()
 *         // ...
 *         .config(myAction.variables.getMyVariable())
 *         .build();
 * </pre></blockquote>
 * <p>
 * The namespace name that will be used will be automatically generated by the pipeline construct,
 * based on the stage and action name;
 * you can pass a custom name when creating the action instance:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object myAction = MyAction.Builder.create()
 *         // ...
 *         .variablesNamespace("MyNamespace")
 *         .build();
 * </pre></blockquote>
 * <p>
 * There are also global variables available,
 * not tied to any action;
 * these are accessed through static properties of the <code>GlobalVariables</code> class:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * OtherAction.Builder.create()
 *         // ...
 *         .config(codepipeline.GlobalVariables.getExecutionId())
 *         .build();
 * </pre></blockquote>
 * <p>
 * Check the documentation of the <code>&#64;aws-cdk/aws-codepipeline-actions</code>
 * for details on how to use the variables for each action class.
 * <p>
 * See the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-variables.html">CodePipeline documentation</a>
 * for more details on how to use the variables feature.
 * <p>
 * <h2>Events</h2>
 * <p>
 * <h3>Using a pipeline as an event target</h3>
 * <p>
 * A pipeline can be used as a target for a CloudWatch event rule:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_events_targets;
 * import software.amazon.awscdk.aws_events;
 * 
 * 
 * // kick off the pipeline every day
 * Rule rule = new Rule(this, "Daily", new RuleProps()
 *         .schedule(events.Schedule.rate(Duration.days(1))));
 * 
 * rule.addTarget(new CodePipeline(pipeline));
 * </pre></blockquote>
 * <p>
 * When a pipeline is used as an event target, the
 * "codepipeline:StartPipelineExecution" permission is granted to the AWS
 * CloudWatch Events service.
 * <p>
 * <h3>Event sources</h3>
 * <p>
 * Pipelines emit CloudWatch events. To define event rules for events emitted by
 * the pipeline, stages or action, use the <code>onXxx</code> methods on the respective
 * construct:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * myPipeline.onStateChange("MyPipelineStateChange", target);
 * myStage.onStateChange("MyStageStateChange", target);
 * myAction.onStateChange("MyActionStateChange", target);
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.codepipeline;
