package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Options for a ClientVpnRoute.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.048Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ClientVpnRouteOptions")
@software.amazon.jsii.Jsii.Proxy(ClientVpnRouteOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClientVpnRouteOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The IPv4 address range, in CIDR notation, of the route destination.
     * <p>
     * For example:
     * <p>
     * <ul>
     * <li>To add a route for Internet access, enter 0.0.0.0/0</li>
     * <li>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</li>
     * <li>To add a route for an on-premises network, enter the AWS Site-to-Site VPN
     * connection's IPv4 CIDR range</li>
     * <li>To add a route for the local network, enter the client CIDR range</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getCidr();

    /**
     * (experimental) The target for the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ClientVpnRouteTarget getTarget();

    /**
     * (experimental) A brief description of the authorization rule.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClientVpnRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClientVpnRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClientVpnRouteOptions> {
        private java.lang.String cidr;
        private software.amazon.awscdk.services.ec2.ClientVpnRouteTarget target;
        private java.lang.String description;

        /**
         * Sets the value of {@link ClientVpnRouteOptions#getCidr}
         * @param cidr The IPv4 address range, in CIDR notation, of the route destination. This parameter is required.
         *             For example:
         *             <p>
         *             <ul>
         *             <li>To add a route for Internet access, enter 0.0.0.0/0</li>
         *             <li>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</li>
         *             <li>To add a route for an on-premises network, enter the AWS Site-to-Site VPN
         *             connection's IPv4 CIDR range</li>
         *             <li>To add a route for the local network, enter the client CIDR range</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnRouteOptions#getTarget}
         * @param target The target for the route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnRouteOptions#getDescription}
         * @param description A brief description of the authorization rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClientVpnRouteOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClientVpnRouteOptions build() {
            return new Jsii$Proxy(cidr, target, description);
        }
    }

    /**
     * An implementation for {@link ClientVpnRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientVpnRouteOptions {
        private final java.lang.String cidr;
        private final software.amazon.awscdk.services.ec2.ClientVpnRouteTarget target;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String cidr, final software.amazon.awscdk.services.ec2.ClientVpnRouteTarget target, final java.lang.String description) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidr = java.util.Objects.requireNonNull(cidr, "cidr is required");
            this.target = java.util.Objects.requireNonNull(target, "target is required");
            this.description = description;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ClientVpnRouteTarget getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cidr", om.valueToTree(this.getCidr()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.ClientVpnRouteOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClientVpnRouteOptions.Jsii$Proxy that = (ClientVpnRouteOptions.Jsii$Proxy) o;

            if (!cidr.equals(that.cidr)) return false;
            if (!target.equals(that.target)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cidr.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
