package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Additional options for an InitSource that builds an asset from local files.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.094Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InitSourceAssetOptions")
@software.amazon.jsii.Jsii.Proxy(InitSourceAssetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface InitSourceAssetOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.InitSourceOptions, software.amazon.awscdk.services.s3.assets.AssetOptions {

    /**
     * @return a {@link Builder} of {@link InitSourceAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitSourceAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<InitSourceAssetOptions> {
        private java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private java.lang.String assetHash;
        private software.amazon.awscdk.AssetHashType assetHashType;
        private software.amazon.awscdk.BundlingOptions bundling;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        private software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Sets the value of {@link InitSourceAssetOptions#getServiceRestartHandles}
         * @param serviceRestartHandles Restart the given services after this archive has been extracted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder serviceRestartHandles(java.util.List<? extends software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles) {
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)serviceRestartHandles;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getReaders}
         * @param readers A list of principals that should be able to read this asset from S3.
         *                You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder readers(java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)readers;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getAssetHashType}
         * @param assetHashType Specifies the type of hash to calculate for this asset.
         *                      If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         *                      <code>AssetHashType.CUSTOM</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHashType(software.amazon.awscdk.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getBundling}
         * @param bundling Bundle the asset by executing a command in a Docker container.
         *                 The asset path will be mounted at <code>/asset-input</code>. The Docker
         *                 container is responsible for putting content at <code>/asset-output</code>.
         *                 The content at <code>/asset-output</code> will be zipped and used as the
         *                 final asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundling(software.amazon.awscdk.BundlingOptions bundling) {
            this.bundling = bundling;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder followSymlinks(software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for exclude patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignoreMode(software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitSourceAssetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public InitSourceAssetOptions build() {
            return new Jsii$Proxy(serviceRestartHandles, readers, assetHash, assetHashType, bundling, exclude, followSymlinks, ignoreMode);
        }
    }

    /**
     * An implementation for {@link InitSourceAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitSourceAssetOptions {
        private final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private final java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.AssetHashType assetHashType;
        private final software.amazon.awscdk.BundlingOptions bundling;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        private final software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceRestartHandles = software.amazon.jsii.Kernel.get(this, "serviceRestartHandles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class)));
            this.readers = software.amazon.jsii.Kernel.get(this, "readers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class)));
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.AssetHashType.class));
            this.bundling = software.amazon.jsii.Kernel.get(this, "bundling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.BundlingOptions.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SymlinkFollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IgnoreMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles, final java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers, final java.lang.String assetHash, final software.amazon.awscdk.AssetHashType assetHashType, final software.amazon.awscdk.BundlingOptions bundling, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.SymlinkFollowMode followSymlinks, final software.amazon.awscdk.IgnoreMode ignoreMode) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)serviceRestartHandles;
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)readers;
            this.assetHash = assetHash;
            this.assetHashType = assetHashType;
            this.bundling = bundling;
            this.exclude = exclude;
            this.followSymlinks = followSymlinks;
            this.ignoreMode = ignoreMode;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
            return this.serviceRestartHandles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IGrantable> getReaders() {
            return this.readers;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final software.amazon.awscdk.BundlingOptions getBundling() {
            return this.bundling;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        public final software.amazon.awscdk.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getServiceRestartHandles() != null) {
                data.set("serviceRestartHandles", om.valueToTree(this.getServiceRestartHandles()));
            }
            if (this.getReaders() != null) {
                data.set("readers", om.valueToTree(this.getReaders()));
            }
            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBundling() != null) {
                data.set("bundling", om.valueToTree(this.getBundling()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InitSourceAssetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitSourceAssetOptions.Jsii$Proxy that = (InitSourceAssetOptions.Jsii$Proxy) o;

            if (this.serviceRestartHandles != null ? !this.serviceRestartHandles.equals(that.serviceRestartHandles) : that.serviceRestartHandles != null) return false;
            if (this.readers != null ? !this.readers.equals(that.readers) : that.readers != null) return false;
            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.bundling != null ? !this.bundling.equals(that.bundling) : that.bundling != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.followSymlinks != null ? !this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks != null) return false;
            return this.ignoreMode != null ? this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.serviceRestartHandles != null ? this.serviceRestartHandles.hashCode() : 0;
            result = 31 * result + (this.readers != null ? this.readers.hashCode() : 0);
            result = 31 * result + (this.assetHash != null ? this.assetHash.hashCode() : 0);
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.bundling != null ? this.bundling.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            return result;
        }
    }
}
