package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Properties for looking up an image.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.103Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.LookupMachineImageProps")
@software.amazon.jsii.Jsii.Proxy(LookupMachineImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LookupMachineImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Name of the image (may contain wildcards).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * (experimental) Additional filters on the AMI.
     * <p>
     * Default: - No additional filters
     * <p>
     * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.util.List<java.lang.String>> getFilters() {
        return null;
    }

    /**
     * (experimental) Owner account IDs or aliases.
     * <p>
     * Default: - All owners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOwners() {
        return null;
    }

    /**
     * (experimental) Custom userdata for this image.
     * <p>
     * Default: - Empty user data appropriate for the platform type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * (experimental) Look for Windows images.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWindows() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LookupMachineImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LookupMachineImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LookupMachineImageProps> {
        private java.lang.String name;
        private java.util.Map<java.lang.String, java.util.List<java.lang.String>> filters;
        private java.util.List<java.lang.String> owners;
        private software.amazon.awscdk.services.ec2.UserData userData;
        private java.lang.Boolean windows;

        /**
         * Sets the value of {@link LookupMachineImageProps#getName}
         * @param name Name of the image (may contain wildcards). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link LookupMachineImageProps#getFilters}
         * @param filters Additional filters on the AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder filters(java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> filters) {
            this.filters = (java.util.Map<java.lang.String, java.util.List<java.lang.String>>)filters;
            return this;
        }

        /**
         * Sets the value of {@link LookupMachineImageProps#getOwners}
         * @param owners Owner account IDs or aliases.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owners(java.util.List<java.lang.String> owners) {
            this.owners = owners;
            return this;
        }

        /**
         * Sets the value of {@link LookupMachineImageProps#getUserData}
         * @param userData Custom userdata for this image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link LookupMachineImageProps#getWindows}
         * @param windows Look for Windows images.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder windows(java.lang.Boolean windows) {
            this.windows = windows;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LookupMachineImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LookupMachineImageProps build() {
            return new Jsii$Proxy(name, filters, owners, userData, windows);
        }
    }

    /**
     * An implementation for {@link LookupMachineImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LookupMachineImageProps {
        private final java.lang.String name;
        private final java.util.Map<java.lang.String, java.util.List<java.lang.String>> filters;
        private final java.util.List<java.lang.String> owners;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final java.lang.Boolean windows;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
            this.owners = software.amazon.jsii.Kernel.get(this, "owners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
            this.windows = software.amazon.jsii.Kernel.get(this, "windows", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String name, final java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> filters, final java.util.List<java.lang.String> owners, final software.amazon.awscdk.services.ec2.UserData userData, final java.lang.Boolean windows) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.filters = (java.util.Map<java.lang.String, java.util.List<java.lang.String>>)filters;
            this.owners = owners;
            this.userData = userData;
            this.windows = windows;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.List<java.lang.String>> getFilters() {
            return this.filters;
        }

        @Override
        public final java.util.List<java.lang.String> getOwners() {
            return this.owners;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public final java.lang.Boolean getWindows() {
            return this.windows;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getFilters() != null) {
                data.set("filters", om.valueToTree(this.getFilters()));
            }
            if (this.getOwners() != null) {
                data.set("owners", om.valueToTree(this.getOwners()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getWindows() != null) {
                data.set("windows", om.valueToTree(this.getWindows()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.LookupMachineImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LookupMachineImageProps.Jsii$Proxy that = (LookupMachineImageProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
            if (this.owners != null ? !this.owners.equals(that.owners) : that.owners != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            return this.windows != null ? this.windows.equals(that.windows) : that.windows == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
            result = 31 * result + (this.owners != null ? this.owners.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.windows != null ? this.windows.hashCode() : 0);
            return result;
        }
    }
}
