package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Define an AWS Virtual Private Cloud.
 * <p>
 * See the package-level documentation of this package for an overview
 * of the various dimensions in which you can configure your VPC.
 * <p>
 * For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object vpc = Vpc.Builder.create(this, "TheVPC")
 *         .cidr("10.0.0.0/16")
 *         .build();
 * // Iterate the private subnets
 * Object selection = vpc.selectSubnets(Map.of(
 *         "subnetType", ec2.SubnetType.getPRIVATE()));
 * for (Object subnet : selection.getSubnets()) {
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.130Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.Vpc")
public class Vpc extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IVpc {

    protected Vpc(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Vpc(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_CIDR_RANGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Vpc.class, "DEFAULT_CIDR_RANGE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_SUBNETS = java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Vpc.class, "DEFAULT_SUBNETS", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetConfiguration.class))));
        DEFAULT_SUBNETS_NO_NAT = java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Vpc.class, "DEFAULT_SUBNETS_NO_NAT", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetConfiguration.class))));
    }

    /**
     * (experimental) Vpc creates a VPC that spans a whole region.
     * <p>
     * It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone.
     * Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway.
     * Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Vpc(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Vpc creates a VPC that spans a whole region.
     * <p>
     * It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone.
     * Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway.
     * Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Vpc(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing VPC from by querying the AWS environment this stack is deployed to.
     * <p>
     * This function only needs to be used to use VPCs not defined in your CDK
     * application. If you are looking to share a VPC between stacks, you can
     * pass the <code>Vpc</code> object between stacks and use it as normal.
     * <p>
     * Calling this method will lead to a lookup when the CDK CLI is executed.
     * You can therefore not use any values that will only be available at
     * CloudFormation execution time (i.e., Tokens).
     * <p>
     * The VPC information will be cached in <code>cdk.context.json</code> and the same VPC
     * will be used on future runs. To refresh the lookup, you will have to
     * evict the value from the cache using the <code>cdk context</code> command. See
     * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VpcLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Vpc.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Import a VPC by supplying all attributes directly.
     * <p>
     * NOTE: using <code>fromVpcAttributes()</code> with deploy-time parameters (like a <code>Fn.importValue()</code> or
     * <code>CfnParameter</code> to represent a list of subnet IDs) sometimes accidentally works. It happens
     * to work for constructs that need a list of subnets (like <code>AutoScalingGroup</code> and <code>eks.Cluster</code>)
     * but it does not work for constructs that need individual subnets (like
     * <code>Instance</code>). See https://github.com/aws/aws-cdk/issues/4118 for more
     * information.
     * <p>
     * Prefer to use <code>Vpc.fromLookup()</code> instead.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc fromVpcAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VpcAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Vpc.class, "fromVpcAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Adds a new client VPN endpoint to this VPC.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ClientVpnEndpoint addClientVpnEndpoint(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ClientVpnEndpointOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addClientVpnEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ClientVpnEndpoint.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a new flow log to this VPC.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLog addFlowLog(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.FlowLogOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addFlowLog", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLog.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Adds a new flow log to this VPC.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLog addFlowLog(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addFlowLog", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLog.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Adds a new gateway endpoint to this VPC.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addGatewayEndpoint(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addGatewayEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a new interface endpoint to this VPC.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint addInterfaceEndpoint(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addInterfaceEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a new VPN connection to this VPC.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VpnConnection addVpnConnection(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VpnConnectionOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addVpnConnection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpnConnection.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a VPN Gateway to this VPC.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void enableVpnGateway(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.EnableVpnGatewayOptions options) {
        software.amazon.jsii.Kernel.call(this, "enableVpnGateway", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Return the subnets appropriate for the placement strategy.
     * <p>
     * @param selection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> selectSubnetObjects(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "selectSubnetObjects", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)), new Object[] { selection }));
    }

    /**
     * (experimental) Return the subnets appropriate for the placement strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> selectSubnetObjects() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "selectSubnetObjects", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class))));
    }

    /**
     * (experimental) Returns IDs of selected subnets.
     * <p>
     * @param selection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return software.amazon.jsii.Kernel.call(this, "selectSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SelectedSubnets.class), new Object[] { selection });
    }

    /**
     * (experimental) Returns IDs of selected subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets() {
        return software.amazon.jsii.Kernel.call(this, "selectSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SelectedSubnets.class));
    }

    /**
     * (experimental) The default CIDR range used when creating VPCs.
     * <p>
     * This can be overridden using VpcProps when creating a VPCNetwork resource.
     * e.g. new VpcResource(this, { cidr: '192.168.0.0./16' })
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_CIDR_RANGE;

    /**
     * (experimental) The default subnet configuration.
     * <p>
     * 1 Public and 1 Private subnet per AZ evenly split
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> DEFAULT_SUBNETS;

    /**
     * (experimental) The default subnet configuration if natGateways specified to be 0.
     * <p>
     * 1 Public and 1 Isolated Subnet per AZ evenly split
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> DEFAULT_SUBNETS_NO_NAT;

    /**
     * (experimental) AZs for this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Indicates if instances launched in this VPC will have public DNS hostnames.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getDnsHostnamesEnabled() {
        return software.amazon.jsii.Kernel.get(this, "dnsHostnamesEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Indicates if DNS support is enabled for this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getDnsSupportEnabled() {
        return software.amazon.jsii.Kernel.get(this, "dnsSupportEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Dependencies for internet connectivity.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.constructs.IDependable getInternetConnectivityEstablished() {
        return software.amazon.jsii.Kernel.get(this, "internetConnectivityEstablished", software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class));
    }

    /**
     * (experimental) List of isolated subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getIsolatedSubnets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "isolatedSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class))));
    }

    /**
     * (experimental) List of private subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getPrivateSubnets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "privateSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class))));
    }

    /**
     * (experimental) List of public subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getPublicSubnets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "publicSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class))));
    }

    /**
     * (experimental) CIDR range for this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcCidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "vpcCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVpcCidrBlockAssociations() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "vpcCidrBlockAssociations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcDefaultNetworkAcl() {
        return software.amazon.jsii.Kernel.get(this, "vpcDefaultNetworkAcl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcDefaultSecurityGroup() {
        return software.amazon.jsii.Kernel.get(this, "vpcDefaultSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Identifier for this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVpcIpv6CidrBlocks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "vpcIpv6CidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Internet Gateway for the VPC.
     * <p>
     * Note that in case the VPC is configured only
     * with ISOLATED subnets, this attribute will be <code>undefined</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getInternetGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "internetGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns the id of the VPN Gateway (if enabled).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) If this is set to true, don't error out on trying to select subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getIncompleteSubnetDefinition() {
        return software.amazon.jsii.Kernel.get(this, "incompleteSubnetDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) If this is set to true, don't error out on trying to select subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setIncompleteSubnetDefinition(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "incompleteSubnetDefinition", java.util.Objects.requireNonNull(value, "incompleteSubnetDefinition is required"));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ec2.Vpc}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Vpc> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.VpcProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) The CIDR range to use for the VPC, e.g. '10.0.0.0/16'.
         * <p>
         * Should be a minimum of /28 and maximum size of /16. The range will be
         * split across all subnets per Availability Zone.
         * <p>
         * Default: Vpc.DEFAULT_CIDR_RANGE
         * <p>
         * @return {@code this}
         * @param cidr The CIDR range to use for the VPC, e.g. '10.0.0.0/16'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cidr(final java.lang.String cidr) {
            this.props().cidr(cidr);
            return this;
        }

        /**
         * (experimental) The default tenancy of instances launched into the VPC.
         * <p>
         * By setting this to dedicated tenancy, instances will be launched on
         * hardware dedicated to a single AWS customer, unless specifically specified
         * at instance launch time. Please note, not all instance types are usable
         * with Dedicated tenancy.
         * <p>
         * Default: DefaultInstanceTenancy.Default (shared) tenancy
         * <p>
         * @return {@code this}
         * @param defaultInstanceTenancy The default tenancy of instances launched into the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultInstanceTenancy(final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy) {
            this.props().defaultInstanceTenancy(defaultInstanceTenancy);
            return this;
        }

        /**
         * (experimental) Indicates whether the instances launched in the VPC get public DNS hostnames.
         * <p>
         * If this attribute is true, instances in the VPC get public DNS hostnames,
         * but only if the enableDnsSupport attribute is also set to true.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableDnsHostnames Indicates whether the instances launched in the VPC get public DNS hostnames. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableDnsHostnames(final java.lang.Boolean enableDnsHostnames) {
            this.props().enableDnsHostnames(enableDnsHostnames);
            return this;
        }

        /**
         * (experimental) Indicates whether the DNS resolution is supported for the VPC.
         * <p>
         * If this attribute is false, the Amazon-provided DNS server in the VPC that
         * resolves public DNS hostnames to IP addresses is not enabled. If this
         * attribute is true, queries to the Amazon provided DNS server at the
         * 169.254.169.253 IP address, or the reserved IP address at the base of the
         * VPC IPv4 network range plus two will succeed.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableDnsSupport Indicates whether the DNS resolution is supported for the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableDnsSupport(final java.lang.Boolean enableDnsSupport) {
            this.props().enableDnsSupport(enableDnsSupport);
            return this;
        }

        /**
         * (experimental) Flow logs to add to this VPC.
         * <p>
         * Default: - No flow logs.
         * <p>
         * @return {@code this}
         * @param flowLogs Flow logs to add to this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder flowLogs(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ec2.FlowLogOptions> flowLogs) {
            this.props().flowLogs(flowLogs);
            return this;
        }

        /**
         * (experimental) Gateway endpoints to add to this VPC.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param gatewayEndpoints Gateway endpoints to add to this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gatewayEndpoints(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints) {
            this.props().gatewayEndpoints(gatewayEndpoints);
            return this;
        }

        /**
         * (experimental) Define the maximum number of AZs to use in this region.
         * <p>
         * If the region has more AZs than you want to use (for example, because of
         * EIP limits), pick a lower number here. The AZs will be sorted and picked
         * from the start of the list.
         * <p>
         * If you pick a higher number than the number of AZs in the region, all AZs
         * in the region will be selected. To use "all AZs" available to your
         * account, use a high number (such as 99).
         * <p>
         * Be aware that environment-agnostic stacks will be created with access to
         * only 2 AZs, so to use more than 2 AZs, be sure to specify the account and
         * region on your stack.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param maxAzs Define the maximum number of AZs to use in this region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxAzs(final java.lang.Number maxAzs) {
            this.props().maxAzs(maxAzs);
            return this;
        }

        /**
         * (experimental) What type of NAT provider to use.
         * <p>
         * Select between NAT gateways or NAT instances. NAT gateways
         * may not be available in all AWS regions.
         * <p>
         * Default: NatProvider.gateway()
         * <p>
         * @return {@code this}
         * @param natGatewayProvider What type of NAT provider to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder natGatewayProvider(final software.amazon.awscdk.services.ec2.NatProvider natGatewayProvider) {
            this.props().natGatewayProvider(natGatewayProvider);
            return this;
        }

        /**
         * (experimental) The number of NAT Gateways/Instances to create.
         * <p>
         * The type of NAT gateway or instance will be determined by the
         * <code>natGatewayProvider</code> parameter.
         * <p>
         * You can set this number lower than the number of Availability Zones in your
         * VPC in order to save on NAT cost. Be aware you may be charged for
         * cross-AZ data traffic instead.
         * <p>
         * Default: - One NAT gateway/instance per Availability Zone
         * <p>
         * @return {@code this}
         * @param natGateways The number of NAT Gateways/Instances to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder natGateways(final java.lang.Number natGateways) {
            this.props().natGateways(natGateways);
            return this;
        }

        /**
         * (experimental) Configures the subnets which will have NAT Gateways/Instances.
         * <p>
         * You can pick a specific group of subnets by specifying the group name;
         * the picked subnets must be public subnets.
         * <p>
         * Only necessary if you have more than one public subnet group.
         * <p>
         * Default: - All public subnets.
         * <p>
         * @return {@code this}
         * @param natGatewaySubnets Configures the subnets which will have NAT Gateways/Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder natGatewaySubnets(final software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets) {
            this.props().natGatewaySubnets(natGatewaySubnets);
            return this;
        }

        /**
         * (experimental) Configure the subnets to build for each AZ.
         * <p>
         * Each entry in this list configures a Subnet Group; each group will contain a
         * subnet for each Availability Zone.
         * <p>
         * For example, if you want 1 public subnet, 1 private subnet, and 1 isolated
         * subnet in each AZ provide the following:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * Vpc.Builder.create(this, "VPC")
         *         .subnetConfiguration(asList(Map.of(
         *                 "cidrMask", 24,
         *                 "name", "ingress",
         *                 "subnetType", ec2.SubnetType.getPUBLIC()), Map.of(
         *                 "cidrMask", 24,
         *                 "name", "application",
         *                 "subnetType", ec2.SubnetType.getPRIVATE()), Map.of(
         *                 "cidrMask", 28,
         *                 "name", "rds",
         *                 "subnetType", ec2.SubnetType.getISOLATED())))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - The VPC CIDR will be evenly divided between 1 public and 1
         * private subnet per AZ.
         * <p>
         * @return {@code this}
         * @param subnetConfiguration Configure the subnets to build for each AZ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetConfiguration(final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration) {
            this.props().subnetConfiguration(subnetConfiguration);
            return this;
        }

        /**
         * (experimental) VPN connections to this VPC.
         * <p>
         * Default: - No connections.
         * <p>
         * @return {@code this}
         * @param vpnConnections VPN connections to this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpnConnections(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections) {
            this.props().vpnConnections(vpnConnections);
            return this;
        }

        /**
         * (experimental) Indicates whether a VPN gateway should be created and attached to this VPC.
         * <p>
         * Default: - true when vpnGatewayAsn or vpnConnections is specified
         * <p>
         * @return {@code this}
         * @param vpnGateway Indicates whether a VPN gateway should be created and attached to this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpnGateway(final java.lang.Boolean vpnGateway) {
            this.props().vpnGateway(vpnGateway);
            return this;
        }

        /**
         * (experimental) The private Autonomous System Number (ASN) for the VPN gateway.
         * <p>
         * Default: - Amazon default ASN.
         * <p>
         * @return {@code this}
         * @param vpnGatewayAsn The private Autonomous System Number (ASN) for the VPN gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpnGatewayAsn(final java.lang.Number vpnGatewayAsn) {
            this.props().vpnGatewayAsn(vpnGatewayAsn);
            return this;
        }

        /**
         * (experimental) Where to propagate VPN routes.
         * <p>
         * Default: - On the route tables associated with private subnets. If no
         * private subnets exists, isolated subnets are used. If no isolated subnets
         * exists, public subnets are used.
         * <p>
         * @return {@code this}
         * @param vpnRoutePropagation Where to propagate VPN routes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpnRoutePropagation(final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation) {
            this.props().vpnRoutePropagation(vpnRoutePropagation);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Vpc}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.Vpc build() {
            return new software.amazon.awscdk.services.ec2.Vpc(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.VpcProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.VpcProps.Builder();
            }
            return this.props;
        }
    }
}
