package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The properties for adding an AutoScalingGroup.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.165Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AddAutoScalingGroupCapacityOptions")
@software.amazon.jsii.Jsii.Proxy(AddAutoScalingGroupCapacityOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AddAutoScalingGroupCapacityOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Specifies whether the containers can access the container instance role.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCanContainersAccessInstanceRole() {
        return null;
    }

    /**
     * (experimental) Specify the machine image type.
     * <p>
     * Default: MachineImageType.AMAZON_LINUX_2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.MachineImageType getMachineImageType() {
        return null;
    }

    /**
     * (experimental) Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSpotInstanceDraining() {
        return null;
    }

    /**
     * (experimental) If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
     * <p>
     * Default: The SNS Topic will not be encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getTopicEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddAutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddAutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AddAutoScalingGroupCapacityOptions> {
        private java.lang.Boolean canContainersAccessInstanceRole;
        private software.amazon.awscdk.services.ecs.MachineImageType machineImageType;
        private java.lang.Boolean spotInstanceDraining;
        private software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getCanContainersAccessInstanceRole}
         * @param canContainersAccessInstanceRole Specifies whether the containers can access the container instance role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder canContainersAccessInstanceRole(java.lang.Boolean canContainersAccessInstanceRole) {
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            return this;
        }

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getMachineImageType}
         * @param machineImageType Specify the machine image type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImageType(software.amazon.awscdk.services.ecs.MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getSpotInstanceDraining}
         * @param spotInstanceDraining Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder spotInstanceDraining(java.lang.Boolean spotInstanceDraining) {
            this.spotInstanceDraining = spotInstanceDraining;
            return this;
        }

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getTopicEncryptionKey}
         * @param topicEncryptionKey If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topicEncryptionKey(software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            this.topicEncryptionKey = topicEncryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddAutoScalingGroupCapacityOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AddAutoScalingGroupCapacityOptions build() {
            return new Jsii$Proxy(canContainersAccessInstanceRole, machineImageType, spotInstanceDraining, topicEncryptionKey);
        }
    }

    /**
     * An implementation for {@link AddAutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddAutoScalingGroupCapacityOptions {
        private final java.lang.Boolean canContainersAccessInstanceRole;
        private final software.amazon.awscdk.services.ecs.MachineImageType machineImageType;
        private final java.lang.Boolean spotInstanceDraining;
        private final software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.canContainersAccessInstanceRole = software.amazon.jsii.Kernel.get(this, "canContainersAccessInstanceRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.machineImageType = software.amazon.jsii.Kernel.get(this, "machineImageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.MachineImageType.class));
            this.spotInstanceDraining = software.amazon.jsii.Kernel.get(this, "spotInstanceDraining", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.topicEncryptionKey = software.amazon.jsii.Kernel.get(this, "topicEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean canContainersAccessInstanceRole, final software.amazon.awscdk.services.ecs.MachineImageType machineImageType, final java.lang.Boolean spotInstanceDraining, final software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            this.machineImageType = machineImageType;
            this.spotInstanceDraining = spotInstanceDraining;
            this.topicEncryptionKey = topicEncryptionKey;
        }

        @Override
        public final java.lang.Boolean getCanContainersAccessInstanceRole() {
            return this.canContainersAccessInstanceRole;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.MachineImageType getMachineImageType() {
            return this.machineImageType;
        }

        @Override
        public final java.lang.Boolean getSpotInstanceDraining() {
            return this.spotInstanceDraining;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getTopicEncryptionKey() {
            return this.topicEncryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCanContainersAccessInstanceRole() != null) {
                data.set("canContainersAccessInstanceRole", om.valueToTree(this.getCanContainersAccessInstanceRole()));
            }
            if (this.getMachineImageType() != null) {
                data.set("machineImageType", om.valueToTree(this.getMachineImageType()));
            }
            if (this.getSpotInstanceDraining() != null) {
                data.set("spotInstanceDraining", om.valueToTree(this.getSpotInstanceDraining()));
            }
            if (this.getTopicEncryptionKey() != null) {
                data.set("topicEncryptionKey", om.valueToTree(this.getTopicEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AddAutoScalingGroupCapacityOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddAutoScalingGroupCapacityOptions.Jsii$Proxy that = (AddAutoScalingGroupCapacityOptions.Jsii$Proxy) o;

            if (this.canContainersAccessInstanceRole != null ? !this.canContainersAccessInstanceRole.equals(that.canContainersAccessInstanceRole) : that.canContainersAccessInstanceRole != null) return false;
            if (this.machineImageType != null ? !this.machineImageType.equals(that.machineImageType) : that.machineImageType != null) return false;
            if (this.spotInstanceDraining != null ? !this.spotInstanceDraining.equals(that.spotInstanceDraining) : that.spotInstanceDraining != null) return false;
            return this.topicEncryptionKey != null ? this.topicEncryptionKey.equals(that.topicEncryptionKey) : that.topicEncryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.canContainersAccessInstanceRole != null ? this.canContainersAccessInstanceRole.hashCode() : 0;
            result = 31 * result + (this.machineImageType != null ? this.machineImageType.hashCode() : 0);
            result = 31 * result + (this.spotInstanceDraining != null ? this.spotInstanceDraining.hashCode() : 0);
            result = 31 * result + (this.topicEncryptionKey != null ? this.topicEncryptionKey.hashCode() : 0);
            return result;
        }
    }
}
