package software.amazon.awscdk.services.ecs;

/**
 * (experimental) An Auto Scaling Group Capacity Provider.
 * <p>
 * This allows an ECS cluster to target
 * a specific EC2 Auto Scaling Group for the placement of tasks. Optionally (and
 * recommended), ECS can manage the number of instances in the ASG to fit the
 * tasks, and can ensure that instances are not prematurely terminated while
 * there are still tasks running on them.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.168Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AsgCapacityProvider")
public class AsgCapacityProvider extends software.constructs.Construct {

    protected AsgCapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AsgCapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AsgCapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AsgCapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Auto Scaling Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup getAutoScalingGroup() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class));
    }

    /**
     * (experimental) Capacity provider name.
     * <p>
     * Default: Chosen by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCapacityProviderName() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Whether managed termination protection is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableManagedTerminationProtection() {
        return software.amazon.jsii.Kernel.get(this, "enableManagedTerminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecs.AsgCapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AsgCapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.AsgCapacityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.AsgCapacityProviderProps.Builder();
        }

        /**
         * (experimental) Specifies whether the containers can access the container instance role.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param canContainersAccessInstanceRole Specifies whether the containers can access the container instance role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder canContainersAccessInstanceRole(final java.lang.Boolean canContainersAccessInstanceRole) {
            this.props.canContainersAccessInstanceRole(canContainersAccessInstanceRole);
            return this;
        }

        /**
         * (experimental) Specify the machine image type.
         * <p>
         * Default: MachineImageType.AMAZON_LINUX_2
         * <p>
         * @return {@code this}
         * @param machineImageType Specify the machine image type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImageType(final software.amazon.awscdk.services.ecs.MachineImageType machineImageType) {
            this.props.machineImageType(machineImageType);
            return this;
        }

        /**
         * (experimental) Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param spotInstanceDraining Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder spotInstanceDraining(final java.lang.Boolean spotInstanceDraining) {
            this.props.spotInstanceDraining(spotInstanceDraining);
            return this;
        }

        /**
         * (experimental) If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
         * <p>
         * Default: The SNS Topic will not be encrypted.
         * <p>
         * @return {@code this}
         * @param topicEncryptionKey If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topicEncryptionKey(final software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            this.props.topicEncryptionKey(topicEncryptionKey);
            return this;
        }

        /**
         * (experimental) The autoscaling group to add as a Capacity Provider.
         * <p>
         * @return {@code this}
         * @param autoScalingGroup The autoscaling group to add as a Capacity Provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingGroup(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.props.autoScalingGroup(autoScalingGroup);
            return this;
        }

        /**
         * (experimental) The name for the capacity provider.
         * <p>
         * Default: CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param capacityProviderName The name for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder capacityProviderName(final java.lang.String capacityProviderName) {
            this.props.capacityProviderName(capacityProviderName);
            return this;
        }

        /**
         * (experimental) Whether to enable managed scaling.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableManagedScaling Whether to enable managed scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableManagedScaling(final java.lang.Boolean enableManagedScaling) {
            this.props.enableManagedScaling(enableManagedScaling);
            return this;
        }

        /**
         * (experimental) Whether to enable managed termination protection.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableManagedTerminationProtection Whether to enable managed termination protection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableManagedTerminationProtection(final java.lang.Boolean enableManagedTerminationProtection) {
            this.props.enableManagedTerminationProtection(enableManagedTerminationProtection);
            return this;
        }

        /**
         * (experimental) Maximum scaling step size.
         * <p>
         * In most cases this should be left alone.
         * <p>
         * Default: 1000
         * <p>
         * @return {@code this}
         * @param maximumScalingStepSize Maximum scaling step size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maximumScalingStepSize(final java.lang.Number maximumScalingStepSize) {
            this.props.maximumScalingStepSize(maximumScalingStepSize);
            return this;
        }

        /**
         * (experimental) Minimum scaling step size.
         * <p>
         * In most cases this should be left alone.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param minimumScalingStepSize Minimum scaling step size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minimumScalingStepSize(final java.lang.Number minimumScalingStepSize) {
            this.props.minimumScalingStepSize(minimumScalingStepSize);
            return this;
        }

        /**
         * (experimental) Target capacity percent.
         * <p>
         * In most cases this should be left alone.
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param targetCapacityPercent Target capacity percent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targetCapacityPercent(final java.lang.Number targetCapacityPercent) {
            this.props.targetCapacityPercent(targetCapacityPercent);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.AsgCapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecs.AsgCapacityProvider build() {
            return new software.amazon.awscdk.services.ecs.AsgCapacityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
