package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The options for creating an Auto Scaling Group Capacity Provider.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.168Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AsgCapacityProviderProps")
@software.amazon.jsii.Jsii.Proxy(AsgCapacityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AsgCapacityProviderProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions {

    /**
     * (experimental) The autoscaling group to add as a Capacity Provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup();

    /**
     * (experimental) The name for the capacity provider.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProviderName() {
        return null;
    }

    /**
     * (experimental) Whether to enable managed scaling.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableManagedScaling() {
        return null;
    }

    /**
     * (experimental) Whether to enable managed termination protection.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableManagedTerminationProtection() {
        return null;
    }

    /**
     * (experimental) Maximum scaling step size.
     * <p>
     * In most cases this should be left alone.
     * <p>
     * Default: 1000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumScalingStepSize() {
        return null;
    }

    /**
     * (experimental) Minimum scaling step size.
     * <p>
     * In most cases this should be left alone.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumScalingStepSize() {
        return null;
    }

    /**
     * (experimental) Target capacity percent.
     * <p>
     * In most cases this should be left alone.
     * <p>
     * Default: 100
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetCapacityPercent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AsgCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AsgCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AsgCapacityProviderProps> {
        private software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private java.lang.String capacityProviderName;
        private java.lang.Boolean enableManagedScaling;
        private java.lang.Boolean enableManagedTerminationProtection;
        private java.lang.Number maximumScalingStepSize;
        private java.lang.Number minimumScalingStepSize;
        private java.lang.Number targetCapacityPercent;
        private java.lang.Boolean canContainersAccessInstanceRole;
        private software.amazon.awscdk.services.ecs.MachineImageType machineImageType;
        private java.lang.Boolean spotInstanceDraining;
        private software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getAutoScalingGroup}
         * @param autoScalingGroup The autoscaling group to add as a Capacity Provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getCapacityProviderName}
         * @param capacityProviderName The name for the capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder capacityProviderName(java.lang.String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getEnableManagedScaling}
         * @param enableManagedScaling Whether to enable managed scaling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableManagedScaling(java.lang.Boolean enableManagedScaling) {
            this.enableManagedScaling = enableManagedScaling;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getEnableManagedTerminationProtection}
         * @param enableManagedTerminationProtection Whether to enable managed termination protection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableManagedTerminationProtection(java.lang.Boolean enableManagedTerminationProtection) {
            this.enableManagedTerminationProtection = enableManagedTerminationProtection;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getMaximumScalingStepSize}
         * @param maximumScalingStepSize Maximum scaling step size.
         *                               In most cases this should be left alone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maximumScalingStepSize(java.lang.Number maximumScalingStepSize) {
            this.maximumScalingStepSize = maximumScalingStepSize;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getMinimumScalingStepSize}
         * @param minimumScalingStepSize Minimum scaling step size.
         *                               In most cases this should be left alone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minimumScalingStepSize(java.lang.Number minimumScalingStepSize) {
            this.minimumScalingStepSize = minimumScalingStepSize;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getTargetCapacityPercent}
         * @param targetCapacityPercent Target capacity percent.
         *                              In most cases this should be left alone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targetCapacityPercent(java.lang.Number targetCapacityPercent) {
            this.targetCapacityPercent = targetCapacityPercent;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getCanContainersAccessInstanceRole}
         * @param canContainersAccessInstanceRole Specifies whether the containers can access the container instance role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder canContainersAccessInstanceRole(java.lang.Boolean canContainersAccessInstanceRole) {
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getMachineImageType}
         * @param machineImageType Specify the machine image type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImageType(software.amazon.awscdk.services.ecs.MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getSpotInstanceDraining}
         * @param spotInstanceDraining Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder spotInstanceDraining(java.lang.Boolean spotInstanceDraining) {
            this.spotInstanceDraining = spotInstanceDraining;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getTopicEncryptionKey}
         * @param topicEncryptionKey If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topicEncryptionKey(software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            this.topicEncryptionKey = topicEncryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AsgCapacityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AsgCapacityProviderProps build() {
            return new Jsii$Proxy(autoScalingGroup, capacityProviderName, enableManagedScaling, enableManagedTerminationProtection, maximumScalingStepSize, minimumScalingStepSize, targetCapacityPercent, canContainersAccessInstanceRole, machineImageType, spotInstanceDraining, topicEncryptionKey);
        }
    }

    /**
     * An implementation for {@link AsgCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsgCapacityProviderProps {
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private final java.lang.String capacityProviderName;
        private final java.lang.Boolean enableManagedScaling;
        private final java.lang.Boolean enableManagedTerminationProtection;
        private final java.lang.Number maximumScalingStepSize;
        private final java.lang.Number minimumScalingStepSize;
        private final java.lang.Number targetCapacityPercent;
        private final java.lang.Boolean canContainersAccessInstanceRole;
        private final software.amazon.awscdk.services.ecs.MachineImageType machineImageType;
        private final java.lang.Boolean spotInstanceDraining;
        private final software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroup = software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
            this.capacityProviderName = software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableManagedScaling = software.amazon.jsii.Kernel.get(this, "enableManagedScaling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableManagedTerminationProtection = software.amazon.jsii.Kernel.get(this, "enableManagedTerminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maximumScalingStepSize = software.amazon.jsii.Kernel.get(this, "maximumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minimumScalingStepSize = software.amazon.jsii.Kernel.get(this, "minimumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.targetCapacityPercent = software.amazon.jsii.Kernel.get(this, "targetCapacityPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.canContainersAccessInstanceRole = software.amazon.jsii.Kernel.get(this, "canContainersAccessInstanceRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.machineImageType = software.amazon.jsii.Kernel.get(this, "machineImageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.MachineImageType.class));
            this.spotInstanceDraining = software.amazon.jsii.Kernel.get(this, "spotInstanceDraining", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.topicEncryptionKey = software.amazon.jsii.Kernel.get(this, "topicEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup, final java.lang.String capacityProviderName, final java.lang.Boolean enableManagedScaling, final java.lang.Boolean enableManagedTerminationProtection, final java.lang.Number maximumScalingStepSize, final java.lang.Number minimumScalingStepSize, final java.lang.Number targetCapacityPercent, final java.lang.Boolean canContainersAccessInstanceRole, final software.amazon.awscdk.services.ecs.MachineImageType machineImageType, final java.lang.Boolean spotInstanceDraining, final software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroup = java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required");
            this.capacityProviderName = capacityProviderName;
            this.enableManagedScaling = enableManagedScaling;
            this.enableManagedTerminationProtection = enableManagedTerminationProtection;
            this.maximumScalingStepSize = maximumScalingStepSize;
            this.minimumScalingStepSize = minimumScalingStepSize;
            this.targetCapacityPercent = targetCapacityPercent;
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            this.machineImageType = machineImageType;
            this.spotInstanceDraining = spotInstanceDraining;
            this.topicEncryptionKey = topicEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final java.lang.String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        @Override
        public final java.lang.Boolean getEnableManagedScaling() {
            return this.enableManagedScaling;
        }

        @Override
        public final java.lang.Boolean getEnableManagedTerminationProtection() {
            return this.enableManagedTerminationProtection;
        }

        @Override
        public final java.lang.Number getMaximumScalingStepSize() {
            return this.maximumScalingStepSize;
        }

        @Override
        public final java.lang.Number getMinimumScalingStepSize() {
            return this.minimumScalingStepSize;
        }

        @Override
        public final java.lang.Number getTargetCapacityPercent() {
            return this.targetCapacityPercent;
        }

        @Override
        public final java.lang.Boolean getCanContainersAccessInstanceRole() {
            return this.canContainersAccessInstanceRole;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.MachineImageType getMachineImageType() {
            return this.machineImageType;
        }

        @Override
        public final java.lang.Boolean getSpotInstanceDraining() {
            return this.spotInstanceDraining;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getTopicEncryptionKey() {
            return this.topicEncryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroup", om.valueToTree(this.getAutoScalingGroup()));
            if (this.getCapacityProviderName() != null) {
                data.set("capacityProviderName", om.valueToTree(this.getCapacityProviderName()));
            }
            if (this.getEnableManagedScaling() != null) {
                data.set("enableManagedScaling", om.valueToTree(this.getEnableManagedScaling()));
            }
            if (this.getEnableManagedTerminationProtection() != null) {
                data.set("enableManagedTerminationProtection", om.valueToTree(this.getEnableManagedTerminationProtection()));
            }
            if (this.getMaximumScalingStepSize() != null) {
                data.set("maximumScalingStepSize", om.valueToTree(this.getMaximumScalingStepSize()));
            }
            if (this.getMinimumScalingStepSize() != null) {
                data.set("minimumScalingStepSize", om.valueToTree(this.getMinimumScalingStepSize()));
            }
            if (this.getTargetCapacityPercent() != null) {
                data.set("targetCapacityPercent", om.valueToTree(this.getTargetCapacityPercent()));
            }
            if (this.getCanContainersAccessInstanceRole() != null) {
                data.set("canContainersAccessInstanceRole", om.valueToTree(this.getCanContainersAccessInstanceRole()));
            }
            if (this.getMachineImageType() != null) {
                data.set("machineImageType", om.valueToTree(this.getMachineImageType()));
            }
            if (this.getSpotInstanceDraining() != null) {
                data.set("spotInstanceDraining", om.valueToTree(this.getSpotInstanceDraining()));
            }
            if (this.getTopicEncryptionKey() != null) {
                data.set("topicEncryptionKey", om.valueToTree(this.getTopicEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AsgCapacityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AsgCapacityProviderProps.Jsii$Proxy that = (AsgCapacityProviderProps.Jsii$Proxy) o;

            if (!autoScalingGroup.equals(that.autoScalingGroup)) return false;
            if (this.capacityProviderName != null ? !this.capacityProviderName.equals(that.capacityProviderName) : that.capacityProviderName != null) return false;
            if (this.enableManagedScaling != null ? !this.enableManagedScaling.equals(that.enableManagedScaling) : that.enableManagedScaling != null) return false;
            if (this.enableManagedTerminationProtection != null ? !this.enableManagedTerminationProtection.equals(that.enableManagedTerminationProtection) : that.enableManagedTerminationProtection != null) return false;
            if (this.maximumScalingStepSize != null ? !this.maximumScalingStepSize.equals(that.maximumScalingStepSize) : that.maximumScalingStepSize != null) return false;
            if (this.minimumScalingStepSize != null ? !this.minimumScalingStepSize.equals(that.minimumScalingStepSize) : that.minimumScalingStepSize != null) return false;
            if (this.targetCapacityPercent != null ? !this.targetCapacityPercent.equals(that.targetCapacityPercent) : that.targetCapacityPercent != null) return false;
            if (this.canContainersAccessInstanceRole != null ? !this.canContainersAccessInstanceRole.equals(that.canContainersAccessInstanceRole) : that.canContainersAccessInstanceRole != null) return false;
            if (this.machineImageType != null ? !this.machineImageType.equals(that.machineImageType) : that.machineImageType != null) return false;
            if (this.spotInstanceDraining != null ? !this.spotInstanceDraining.equals(that.spotInstanceDraining) : that.spotInstanceDraining != null) return false;
            return this.topicEncryptionKey != null ? this.topicEncryptionKey.equals(that.topicEncryptionKey) : that.topicEncryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroup.hashCode();
            result = 31 * result + (this.capacityProviderName != null ? this.capacityProviderName.hashCode() : 0);
            result = 31 * result + (this.enableManagedScaling != null ? this.enableManagedScaling.hashCode() : 0);
            result = 31 * result + (this.enableManagedTerminationProtection != null ? this.enableManagedTerminationProtection.hashCode() : 0);
            result = 31 * result + (this.maximumScalingStepSize != null ? this.maximumScalingStepSize.hashCode() : 0);
            result = 31 * result + (this.minimumScalingStepSize != null ? this.minimumScalingStepSize.hashCode() : 0);
            result = 31 * result + (this.targetCapacityPercent != null ? this.targetCapacityPercent.hashCode() : 0);
            result = 31 * result + (this.canContainersAccessInstanceRole != null ? this.canContainersAccessInstanceRole.hashCode() : 0);
            result = 31 * result + (this.machineImageType != null ? this.machineImageType.hashCode() : 0);
            result = 31 * result + (this.spotInstanceDraining != null ? this.spotInstanceDraining.hashCode() : 0);
            result = 31 * result + (this.topicEncryptionKey != null ? this.topicEncryptionKey.hashCode() : 0);
            return result;
        }
    }
}
