package software.amazon.awscdk.services.ecs;

/**
 * (experimental) Specifies the awslogs log driver configuration options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.170Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AwsLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(AwsLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AwsLogDriverProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Prefix for the log streams.
     * <p>
     * The awslogs-stream-prefix option allows you to associate a log stream
     * with the specified prefix, the container name, and the ID of the Amazon
     * ECS task to which the container belongs. If you specify a prefix with
     * this option, then the log stream takes the following format:
     * <p>
     * <blockquote><pre>
     *  prefix-name/container-name/ecs-task-id
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamPrefix();

    /**
     * (experimental) This option defines a multiline start pattern in Python strftime format.
     * <p>
     * A log message consists of a line that matches the pattern and any
     * following lines that don’t match the pattern. Thus the matched line is
     * the delimiter between log messages.
     * <p>
     * Default: - No multiline matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatetimeFormat() {
        return null;
    }

    /**
     * (experimental) The log group to log to.
     * <p>
     * Default: - A log group is automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * (experimental) The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct.
     * <p>
     * Default: - Logs never expire.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * (experimental) The delivery mode of log messages from the container to awslogs.
     * <p>
     * Default: - AwsLogDriverMode.BLOCKING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AwsLogDriverMode getMode() {
        return null;
    }

    /**
     * (experimental) This option defines a multiline start pattern using a regular expression.
     * <p>
     * A log message consists of a line that matches the pattern and any
     * following lines that don’t match the pattern. Thus the matched line is
     * the delimiter between log messages.
     * <p>
     * This option is ignored if datetimeFormat is also configured.
     * <p>
     * Default: - No multiline matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getMultilinePattern() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AwsLogDriverProps> {
        private java.lang.String streamPrefix;
        private java.lang.String datetimeFormat;
        private software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private software.amazon.awscdk.services.ecs.AwsLogDriverMode mode;
        private java.lang.String multilinePattern;

        /**
         * Sets the value of {@link AwsLogDriverProps#getStreamPrefix}
         * @param streamPrefix Prefix for the log streams. This parameter is required.
         *                     The awslogs-stream-prefix option allows you to associate a log stream
         *                     with the specified prefix, the container name, and the ID of the Amazon
         *                     ECS task to which the container belongs. If you specify a prefix with
         *                     this option, then the log stream takes the following format:
         *                     <p>
         *                     <blockquote><pre>
         *                      prefix-name/container-name/ecs-task-id
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder streamPrefix(java.lang.String streamPrefix) {
            this.streamPrefix = streamPrefix;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getDatetimeFormat}
         * @param datetimeFormat This option defines a multiline start pattern in Python strftime format.
         *                       A log message consists of a line that matches the pattern and any
         *                       following lines that don’t match the pattern. Thus the matched line is
         *                       the delimiter between log messages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder datetimeFormat(java.lang.String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getLogGroup}
         * @param logGroup The log group to log to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getLogRetention}
         * @param logRetention The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getMode}
         * @param mode The delivery mode of log messages from the container to awslogs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mode(software.amazon.awscdk.services.ecs.AwsLogDriverMode mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getMultilinePattern}
         * @param multilinePattern This option defines a multiline start pattern using a regular expression.
         *                         A log message consists of a line that matches the pattern and any
         *                         following lines that don’t match the pattern. Thus the matched line is
         *                         the delimiter between log messages.
         *                         <p>
         *                         This option is ignored if datetimeFormat is also configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder multilinePattern(java.lang.String multilinePattern) {
            this.multilinePattern = multilinePattern;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AwsLogDriverProps build() {
            return new Jsii$Proxy(streamPrefix, datetimeFormat, logGroup, logRetention, mode, multilinePattern);
        }
    }

    /**
     * An implementation for {@link AwsLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsLogDriverProps {
        private final java.lang.String streamPrefix;
        private final java.lang.String datetimeFormat;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.services.ecs.AwsLogDriverMode mode;
        private final java.lang.String multilinePattern;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.streamPrefix = software.amazon.jsii.Kernel.get(this, "streamPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datetimeFormat = software.amazon.jsii.Kernel.get(this, "datetimeFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AwsLogDriverMode.class));
            this.multilinePattern = software.amazon.jsii.Kernel.get(this, "multilinePattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String streamPrefix, final java.lang.String datetimeFormat, final software.amazon.awscdk.services.logs.ILogGroup logGroup, final software.amazon.awscdk.services.logs.RetentionDays logRetention, final software.amazon.awscdk.services.ecs.AwsLogDriverMode mode, final java.lang.String multilinePattern) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.streamPrefix = java.util.Objects.requireNonNull(streamPrefix, "streamPrefix is required");
            this.datetimeFormat = datetimeFormat;
            this.logGroup = logGroup;
            this.logRetention = logRetention;
            this.mode = mode;
            this.multilinePattern = multilinePattern;
        }

        @Override
        public final java.lang.String getStreamPrefix() {
            return this.streamPrefix;
        }

        @Override
        public final java.lang.String getDatetimeFormat() {
            return this.datetimeFormat;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.AwsLogDriverMode getMode() {
            return this.mode;
        }

        @Override
        public final java.lang.String getMultilinePattern() {
            return this.multilinePattern;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("streamPrefix", om.valueToTree(this.getStreamPrefix()));
            if (this.getDatetimeFormat() != null) {
                data.set("datetimeFormat", om.valueToTree(this.getDatetimeFormat()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getMultilinePattern() != null) {
                data.set("multilinePattern", om.valueToTree(this.getMultilinePattern()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AwsLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsLogDriverProps.Jsii$Proxy that = (AwsLogDriverProps.Jsii$Proxy) o;

            if (!streamPrefix.equals(that.streamPrefix)) return false;
            if (this.datetimeFormat != null ? !this.datetimeFormat.equals(that.datetimeFormat) : that.datetimeFormat != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            return this.multilinePattern != null ? this.multilinePattern.equals(that.multilinePattern) : that.multilinePattern == null;
        }

        @Override
        public final int hashCode() {
            int result = this.streamPrefix.hashCode();
            result = 31 * result + (this.datetimeFormat != null ? this.datetimeFormat.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.multilinePattern != null ? this.multilinePattern.hashCode() : 0);
            return result;
        }
    }
}
