package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The properties for a task definition run on an EC2 cluster.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.225Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Ec2TaskDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(Ec2TaskDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Ec2TaskDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.CommonTaskDefinitionProps {

    /**
     * (experimental) The inference accelerators to use for the containers in the task.
     * <p>
     * Not supported in Fargate.
     * <p>
     * Default: - No inference accelerators.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> getInferenceAccelerators() {
        return null;
    }

    /**
     * (experimental) The IPC resource namespace to use for the containers in the task.
     * <p>
     * Not supported in Fargate and Windows containers.
     * <p>
     * Default: - IpcMode used by the task is not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.IpcMode getIpcMode() {
        return null;
    }

    /**
     * (experimental) The Docker networking mode to use for the containers in the task.
     * <p>
     * The valid values are none, bridge, awsvpc, and host.
     * <p>
     * Default: - NetworkMode.Bridge for EC2 tasks, AwsVpc for Fargate tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
        return null;
    }

    /**
     * (experimental) The process namespace to use for the containers in the task.
     * <p>
     * Not supported in Fargate and Windows containers.
     * <p>
     * Default: - PidMode used by the task is not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PidMode getPidMode() {
        return null;
    }

    /**
     * (experimental) An array of placement constraint objects to use for the task.
     * <p>
     * You can
     * specify a maximum of 10 constraints per task (this limit includes
     * constraints in the task definition and those specified at run time).
     * <p>
     * Default: - No placement constraints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Ec2TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Ec2TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Ec2TaskDefinitionProps> {
        private java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators;
        private software.amazon.awscdk.services.ecs.IpcMode ipcMode;
        private software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        private software.amazon.awscdk.services.ecs.PidMode pidMode;
        private java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        private software.amazon.awscdk.services.iam.IRole executionRole;
        private java.lang.String family;
        private software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        private software.amazon.awscdk.services.iam.IRole taskRole;
        private java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getInferenceAccelerators}
         * @param inferenceAccelerators The inference accelerators to use for the containers in the task.
         *                              Not supported in Fargate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder inferenceAccelerators(java.util.List<? extends software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators) {
            this.inferenceAccelerators = (java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator>)inferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getIpcMode}
         * @param ipcMode The IPC resource namespace to use for the containers in the task.
         *                Not supported in Fargate and Windows containers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ipcMode(software.amazon.awscdk.services.ecs.IpcMode ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getNetworkMode}
         * @param networkMode The Docker networking mode to use for the containers in the task.
         *                    The valid values are none, bridge, awsvpc, and host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkMode(software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getPidMode}
         * @param pidMode The process namespace to use for the containers in the task.
         *                Not supported in Fargate and Windows containers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pidMode(software.amazon.awscdk.services.ecs.PidMode pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getPlacementConstraints}
         * @param placementConstraints An array of placement constraint objects to use for the task.
         *                             You can
         *                             specify a maximum of 10 constraints per task (this limit includes
         *                             constraints in the task definition and those specified at run time).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder placementConstraints(java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.placementConstraints = (java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint>)placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getExecutionRole}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent to call AWS APIs on your behalf.
         *                      The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getFamily}
         * @param family The name of a family that this task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The configuration details for the App Mesh proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxyConfiguration(software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getTaskRole}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskRole(software.amazon.awscdk.services.iam.IRole taskRole) {
            this.taskRole = taskRole;
            return this;
        }

        /**
         * Sets the value of {@link Ec2TaskDefinitionProps#getVolumes}
         * @param volumes The list of volume definitions for the task.
         *                For more information, see
         *                <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Ec2TaskDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Ec2TaskDefinitionProps build() {
            return new Jsii$Proxy(inferenceAccelerators, ipcMode, networkMode, pidMode, placementConstraints, executionRole, family, proxyConfiguration, taskRole, volumes);
        }
    }

    /**
     * An implementation for {@link Ec2TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2TaskDefinitionProps {
        private final java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators;
        private final software.amazon.awscdk.services.ecs.IpcMode ipcMode;
        private final software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        private final software.amazon.awscdk.services.ecs.PidMode pidMode;
        private final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        private final software.amazon.awscdk.services.iam.IRole taskRole;
        private final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inferenceAccelerators = software.amazon.jsii.Kernel.get(this, "inferenceAccelerators", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.InferenceAccelerator.class)));
            this.ipcMode = software.amazon.jsii.Kernel.get(this, "ipcMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IpcMode.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.NetworkMode.class));
            this.pidMode = software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PidMode.class));
            this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementConstraint.class)));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyConfiguration = software.amazon.jsii.Kernel.get(this, "proxyConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ProxyConfiguration.class));
            this.taskRole = software.amazon.jsii.Kernel.get(this, "taskRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators, final software.amazon.awscdk.services.ecs.IpcMode ipcMode, final software.amazon.awscdk.services.ecs.NetworkMode networkMode, final software.amazon.awscdk.services.ecs.PidMode pidMode, final java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints, final software.amazon.awscdk.services.iam.IRole executionRole, final java.lang.String family, final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration, final software.amazon.awscdk.services.iam.IRole taskRole, final java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inferenceAccelerators = (java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator>)inferenceAccelerators;
            this.ipcMode = ipcMode;
            this.networkMode = networkMode;
            this.pidMode = pidMode;
            this.placementConstraints = (java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint>)placementConstraints;
            this.executionRole = executionRole;
            this.family = family;
            this.proxyConfiguration = proxyConfiguration;
            this.taskRole = taskRole;
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)volumes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> getInferenceAccelerators() {
            return this.inferenceAccelerators;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.IpcMode getIpcMode() {
            return this.ipcMode;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PidMode getPidMode() {
            return this.pidMode;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
            return this.placementConstraints;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ProxyConfiguration getProxyConfiguration() {
            return this.proxyConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getTaskRole() {
            return this.taskRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInferenceAccelerators() != null) {
                data.set("inferenceAccelerators", om.valueToTree(this.getInferenceAccelerators()));
            }
            if (this.getIpcMode() != null) {
                data.set("ipcMode", om.valueToTree(this.getIpcMode()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getPidMode() != null) {
                data.set("pidMode", om.valueToTree(this.getPidMode()));
            }
            if (this.getPlacementConstraints() != null) {
                data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getProxyConfiguration() != null) {
                data.set("proxyConfiguration", om.valueToTree(this.getProxyConfiguration()));
            }
            if (this.getTaskRole() != null) {
                data.set("taskRole", om.valueToTree(this.getTaskRole()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.Ec2TaskDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Ec2TaskDefinitionProps.Jsii$Proxy that = (Ec2TaskDefinitionProps.Jsii$Proxy) o;

            if (this.inferenceAccelerators != null ? !this.inferenceAccelerators.equals(that.inferenceAccelerators) : that.inferenceAccelerators != null) return false;
            if (this.ipcMode != null ? !this.ipcMode.equals(that.ipcMode) : that.ipcMode != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.pidMode != null ? !this.pidMode.equals(that.pidMode) : that.pidMode != null) return false;
            if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.proxyConfiguration != null ? !this.proxyConfiguration.equals(that.proxyConfiguration) : that.proxyConfiguration != null) return false;
            if (this.taskRole != null ? !this.taskRole.equals(that.taskRole) : that.taskRole != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inferenceAccelerators != null ? this.inferenceAccelerators.hashCode() : 0;
            result = 31 * result + (this.ipcMode != null ? this.ipcMode.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.pidMode != null ? this.pidMode.hashCode() : 0);
            result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.proxyConfiguration != null ? this.proxyConfiguration.hashCode() : 0);
            result = 31 * result + (this.taskRole != null ? this.taskRole.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
