package software.amazon.awscdk.services.ecs;

/**
 * (experimental) A log driver that sends log information to splunk Logs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.262Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.SplunkLogDriver")
public class SplunkLogDriver extends software.amazon.awscdk.services.ecs.LogDriver {

    protected SplunkLogDriver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SplunkLogDriver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Constructs a new instance of the SplunkLogDriver class.
     * <p>
     * @param props the splunk log driver configuration options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SplunkLogDriver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.SplunkLogDriverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called when the log driver is configured on a container.
     * <p>
     * @param _scope This parameter is required.
     * @param _containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriverConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition _containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_containerDefinition, "_containerDefinition is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecs.SplunkLogDriver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.SplunkLogDriver> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ecs.SplunkLogDriverProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ecs.SplunkLogDriverProps.Builder();
        }

        /**
         * (experimental) The env option takes an array of keys.
         * <p>
         * If there is collision between
         * label and env keys, the value of the env takes precedence. Adds additional fields
         * to the extra attributes of a logging message.
         * <p>
         * Default: - No env
         * <p>
         * @return {@code this}
         * @param env The env option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(final java.util.List<java.lang.String> env) {
            this.props.env(env);
            return this;
        }

        /**
         * (experimental) The env-regex option is similar to and compatible with env.
         * <p>
         * Its value is a regular
         * expression to match logging-related environment variables. It is used for advanced
         * log tag options.
         * <p>
         * Default: - No envRegex
         * <p>
         * @return {@code this}
         * @param envRegex The env-regex option is similar to and compatible with env. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder envRegex(final java.lang.String envRegex) {
            this.props.envRegex(envRegex);
            return this;
        }

        /**
         * (experimental) The labels option takes an array of keys.
         * <p>
         * If there is collision
         * between label and env keys, the value of the env takes precedence. Adds additional
         * fields to the extra attributes of a logging message.
         * <p>
         * Default: - No labels
         * <p>
         * @return {@code this}
         * @param labels The labels option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder labels(final java.util.List<java.lang.String> labels) {
            this.props.labels(labels);
            return this;
        }

        /**
         * (experimental) By default, Docker uses the first 12 characters of the container ID to tag log messages.
         * <p>
         * Refer to the log tag option documentation for customizing the
         * log tag format.
         * <p>
         * Default: - The first 12 characters of the container ID
         * <p>
         * @return {@code this}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tag(final java.lang.String tag) {
            this.props.tag(tag);
            return this;
        }

        /**
         * (experimental) Splunk HTTP Event Collector token.
         * <p>
         * @return {@code this}
         * @param token Splunk HTTP Event Collector token. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder token(final software.amazon.awscdk.SecretValue token) {
            this.props.token(token);
            return this;
        }

        /**
         * (experimental) Path to your Splunk Enterprise, self-service Splunk Cloud instance, or Splunk Cloud managed cluster (including port and scheme used by HTTP Event Collector) in one of the following formats: https://your_splunk_instance:8088 or https://input-prd-p-XXXXXXX.cloud.splunk.com:8088 or https://http-inputs-XXXXXXXX.splunkcloud.com.
         * <p>
         * @return {@code this}
         * @param url Path to your Splunk Enterprise, self-service Splunk Cloud instance, or Splunk Cloud managed cluster (including port and scheme used by HTTP Event Collector) in one of the following formats: https://your_splunk_instance:8088 or https://input-prd-p-XXXXXXX.cloud.splunk.com:8088 or https://http-inputs-XXXXXXXX.splunkcloud.com. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder url(final java.lang.String url) {
            this.props.url(url);
            return this;
        }

        /**
         * (experimental) Name to use for validating server certificate.
         * <p>
         * Default: - The hostname of the splunk-url
         * <p>
         * @return {@code this}
         * @param caName Name to use for validating server certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder caName(final java.lang.String caName) {
            this.props.caName(caName);
            return this;
        }

        /**
         * (experimental) Path to root certificate.
         * <p>
         * Default: - caPath not set.
         * <p>
         * @return {@code this}
         * @param caPath Path to root certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder caPath(final java.lang.String caPath) {
            this.props.caPath(caPath);
            return this;
        }

        /**
         * (experimental) Message format.
         * <p>
         * Can be inline, json or raw.
         * <p>
         * Default: - inline
         * <p>
         * @return {@code this}
         * @param format Message format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder format(final software.amazon.awscdk.services.ecs.SplunkLogFormat format) {
            this.props.format(format);
            return this;
        }

        /**
         * (experimental) Enable/disable gzip compression to send events to Splunk Enterprise or Splunk Cloud instance.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param gzip Enable/disable gzip compression to send events to Splunk Enterprise or Splunk Cloud instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gzip(final java.lang.Boolean gzip) {
            this.props.gzip(gzip);
            return this;
        }

        /**
         * (experimental) Set compression level for gzip.
         * <p>
         * Valid values are -1 (default), 0 (no compression),
         * 1 (best speed) ... 9 (best compression).
         * <p>
         * Default: - -1 (Default Compression)
         * <p>
         * @return {@code this}
         * @param gzipLevel Set compression level for gzip. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gzipLevel(final java.lang.Number gzipLevel) {
            this.props.gzipLevel(gzipLevel);
            return this;
        }

        /**
         * (experimental) Event index.
         * <p>
         * Default: - index not set.
         * <p>
         * @return {@code this}
         * @param index Event index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder index(final java.lang.String index) {
            this.props.index(index);
            return this;
        }

        /**
         * (experimental) Ignore server certificate validation.
         * <p>
         * Default: - insecureSkipVerify not set.
         * <p>
         * @return {@code this}
         * @param insecureSkipVerify Ignore server certificate validation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder insecureSkipVerify(final java.lang.String insecureSkipVerify) {
            this.props.insecureSkipVerify(insecureSkipVerify);
            return this;
        }

        /**
         * (experimental) Event source.
         * <p>
         * Default: - source not set.
         * <p>
         * @return {@code this}
         * @param source Event source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder source(final java.lang.String source) {
            this.props.source(source);
            return this;
        }

        /**
         * (experimental) Event source type.
         * <p>
         * Default: - sourceType not set.
         * <p>
         * @return {@code this}
         * @param sourceType Event source type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceType(final java.lang.String sourceType) {
            this.props.sourceType(sourceType);
            return this;
        }

        /**
         * (experimental) Verify on start, that docker can connect to Splunk server.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param verifyConnection Verify on start, that docker can connect to Splunk server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder verifyConnection(final java.lang.Boolean verifyConnection) {
            this.props.verifyConnection(verifyConnection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.SplunkLogDriver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecs.SplunkLogDriver build() {
            return new software.amazon.awscdk.services.ecs.SplunkLogDriver(
                this.props.build()
            );
        }
    }
}
