package software.amazon.awscdk.services.ecs.patterns;

/**
 * (experimental) An EC2 service running on an ECS cluster fronted by an application load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:17.279Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedEc2Service")
public class ApplicationLoadBalancedEc2Service extends software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceBase {

    protected ApplicationLoadBalancedEc2Service(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancedEc2Service(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Constructs a new instance of the ApplicationLoadBalancedEc2Service class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ApplicationLoadBalancedEc2Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2ServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Constructs a new instance of the ApplicationLoadBalancedEc2Service class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ApplicationLoadBalancedEc2Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) The EC2 service in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2Service getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ec2Service.class));
    }

    /**
     * (experimental) The EC2 Task Definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2TaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2Service}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2Service> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2ServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Certificate Manager certificate to associate with the load balancer.
         * <p>
         * Setting this option will set the load balancer protocol to HTTPS.
         * <p>
         * Default: - No certificate associated with the load balancer, if using
         * the HTTP protocol. For HTTPS, a DNS-validated certificate will be
         * created for the load balancer's specified domain name.
         * <p>
         * @return {@code this}
         * @param certificate Certificate Manager certificate to associate with the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificate(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.props().certificate(certificate);
            return this;
        }

        /**
         * (experimental) Whether to enable the deployment circuit breaker.
         * <p>
         * If this property is defined, circuit breaker will be implicitly
         * enabled.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param circuitBreaker Whether to enable the deployment circuit breaker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder circuitBreaker(final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.props().circuitBreaker(circuitBreaker);
            return this;
        }

        /**
         * (experimental) The options for configuring an Amazon ECS service to use service discovery.
         * <p>
         * Default: - AWS Cloud Map service discovery is not enabled.
         * <p>
         * @return {@code this}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudMapOptions(final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.props().cloudMapOptions(cloudMapOptions);
            return this;
        }

        /**
         * (experimental) The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        /**
         * (experimental) Specifies which deployment controller to use for the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * <p>
         * Default: - Rolling update (ECS)
         * <p>
         * @return {@code this}
         * @param deploymentController Specifies which deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deploymentController(final software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        /**
         * (experimental) The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * The minimum value is 1
         * <p>
         * Default: - If the feature flag, ECS_REMOVE_DEFAULT_DESIRED_COUNT is false, the default is 1;
         * if true, the default is 1 for all new services and uses the existing services desired count
         * when updating an existing service.
         * <p>
         * @return {@code this}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder desiredCount(final java.lang.Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        /**
         * (experimental) The domain name for the service, e.g. "api.example.com.".
         * <p>
         * Default: - No domain name.
         * <p>
         * @return {@code this}
         * @param domainName The domain name for the service, e.g. "api.example.com.". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final java.lang.String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * (experimental) The Route53 hosted zone for the domain, e.g. "example.com.".
         * <p>
         * Default: - No Route53 hosted domain zone.
         * <p>
         * @return {@code this}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainZone(final software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.props().domainZone(domainZone);
            return this;
        }

        /**
         * (experimental) Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * (experimental) The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * <p>
         * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
         * <p>
         * @return {@code this}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder healthCheckGracePeriod(final software.amazon.awscdk.Duration healthCheckGracePeriod) {
            this.props().healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        /**
         * (experimental) Listener port of the application load balancer that will serve traffic to the service.
         * <p>
         * Default: - The default listener port is determined from the protocol (port 80 for HTTP,
         * port 443 for HTTPS). A domain name and zone must be also be specified if using HTTPS.
         * <p>
         * @return {@code this}
         * @param listenerPort Listener port of the application load balancer that will serve traffic to the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder listenerPort(final java.lang.Number listenerPort) {
            this.props().listenerPort(listenerPort);
            return this;
        }

        /**
         * (experimental) The application load balancer that will serve traffic to the service.
         * <p>
         * The VPC attribute of a load balancer must be specified for it to be used
         * to create a new service with this pattern.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - a new load balancer will be created.
         * <p>
         * @return {@code this}
         * @param loadBalancer The application load balancer that will serve traffic to the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer) {
            this.props().loadBalancer(loadBalancer);
            return this;
        }

        /**
         * (experimental) The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * <p>
         * Default: - 100 if daemon, otherwise 200
         * <p>
         * @return {@code this}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxHealthyPercent(final java.lang.Number maxHealthyPercent) {
            this.props().maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        /**
         * (experimental) The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * <p>
         * Default: - 0 if daemon, otherwise 50
         * <p>
         * @return {@code this}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minHealthyPercent(final java.lang.Number minHealthyPercent) {
            this.props().minHealthyPercent(minHealthyPercent);
            return this;
        }

        /**
         * (experimental) Determines whether or not the Security Group for the Load Balancer's Listener will be open to all traffic by default.
         * <p>
         * Default: true -- The security group allows ingress from all IP addresses.
         * <p>
         * @return {@code this}
         * @param openListener Determines whether or not the Security Group for the Load Balancer's Listener will be open to all traffic by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder openListener(final java.lang.Boolean openListener) {
            this.props().openListener(openListener);
            return this;
        }

        /**
         * (experimental) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Tags can only be propagated to the tasks within the service during service creation.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        /**
         * (experimental) The protocol for connections from clients to the load balancer.
         * <p>
         * The load balancer port is determined from the protocol (port 80 for
         * HTTP, port 443 for HTTPS).  A domain name and zone must be also be
         * specified if using HTTPS.
         * <p>
         * Default: HTTP. If a certificate is specified, the protocol will be
         * set by default to HTTPS.
         * <p>
         * @return {@code this}
         * @param protocol The protocol for connections from clients to the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.props().protocol(protocol);
            return this;
        }

        /**
         * (experimental) The protocol version to use.
         * <p>
         * Default: ApplicationProtocolVersion.HTTP1
         * <p>
         * @return {@code this}
         * @param protocolVersion The protocol version to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocolVersion(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion protocolVersion) {
            this.props().protocolVersion(protocolVersion);
            return this;
        }

        /**
         * (experimental) Determines whether the Load Balancer will be internet-facing.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publicLoadBalancer(final java.lang.Boolean publicLoadBalancer) {
            this.props().publicLoadBalancer(publicLoadBalancer);
            return this;
        }

        /**
         * (experimental) Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all.
         * <p>
         * This is useful if you need to work with DNS systems that do not support alias records.
         * <p>
         * Default: ApplicationLoadBalancedServiceRecordType.ALIAS
         * <p>
         * @return {@code this}
         * @param recordType Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder recordType(final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType recordType) {
            this.props().recordType(recordType);
            return this;
        }

        /**
         * (experimental) Specifies whether the load balancer should redirect traffic on port 80 to port 443 to support HTTP->HTTPS redirects This is only valid if the protocol of the ALB is HTTPS.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param redirectHttp Specifies whether the load balancer should redirect traffic on port 80 to port 443 to support HTTP->HTTPS redirects This is only valid if the protocol of the ALB is HTTPS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder redirectHttp(final java.lang.Boolean redirectHttp) {
            this.props().redirectHttp(redirectHttp);
            return this;
        }

        /**
         * (experimental) The name of the service.
         * <p>
         * Default: - CloudFormation-generated name.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        /**
         * (experimental) The protocol for connections from the load balancer to the ECS tasks.
         * <p>
         * The default target port is determined from the protocol (port 80 for
         * HTTP, port 443 for HTTPS).
         * <p>
         * Default: HTTP.
         * <p>
         * @return {@code this}
         * @param targetProtocol The protocol for connections from the load balancer to the ECS tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targetProtocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol targetProtocol) {
            this.props().targetProtocol(targetProtocol);
            return this;
        }

        /**
         * (experimental) The properties required to create a new task definition.
         * <p>
         * TaskDefinition or TaskImageOptions must be specified, but not both.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param taskImageOptions The properties required to create a new task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskImageOptions(final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions) {
            this.props().taskImageOptions(taskImageOptions);
            return this;
        }

        /**
         * (experimental) The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * (experimental) The number of cpu units used by the task.
         * <p>
         * Valid values, which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cpu(final java.lang.Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        /**
         * (experimental) The hard limit (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the allocated memory, the container
         * is terminated.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required.
         * <p>
         * Default: - No memory limit.
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The hard limit (in MiB) of memory to present to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * (experimental) The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * When system memory is under contention, Docker attempts to keep the
         * container memory within the limit. If the container requires more memory,
         * it can consume up to the value specified by the Memory property or all of
         * the available memory on the container instance—whichever comes first.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required.
         * <p>
         * Default: - No memory reserved.
         * <p>
         * @return {@code this}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryReservationMiB(final java.lang.Number memoryReservationMiB) {
            this.props().memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        /**
         * (experimental) The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both..
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.Ec2TaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2Service}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2Service build() {
            return new software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2Service(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2ServiceProps.Builder();
            }
            return this.props;
        }
    }
}
