package software.amazon.awscdk.services.eks;

/**
 * (experimental) Attributes for EKS clusters.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:18.574Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.ClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(ClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The physical name of the Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * (experimental) The certificate-authority-data for your cluster.
     * <p>
     * Default: - if not specified `cluster.clusterCertificateAuthorityData` will
     * throw an error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterCertificateAuthorityData() {
        return null;
    }

    /**
     * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     * <p>
     * Default: - if not specified `cluster.clusterEncryptionConfigKeyArn` will
     * throw an error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEncryptionConfigKeyArn() {
        return null;
    }

    /**
     * (experimental) The API Server endpoint URL.
     * <p>
     * Default: - if not specified `cluster.clusterEndpoint` will throw an error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpoint() {
        return null;
    }

    /**
     * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
     * <p>
     * Default: - if not specified `cluster.clusterSecurityGroupId` will throw an
     * error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterSecurityGroupId() {
        return null;
    }

    /**
     * (experimental) Environment variables to use when running `kubectl` against this cluster.
     * <p>
     * Default: - no additional variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
        return null;
    }

    /**
     * (experimental) An AWS Lambda Layer which includes `kubectl`, Helm and the AWS CLI.
     * <p>
     * This layer
     * is used by the kubectl handler to apply manifests and install helm charts.
     * <p>
     * The handler expects the layer to include the following executables:
     * <p>
     * <blockquote><pre>
     * helm/helm
     * kubectl/kubectl
     * awscli/aws
     * </pre></blockquote>
     * <p>
     * Default: - a layer bundled with this module.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
        return null;
    }

    /**
     * (experimental) Amount of memory to allocate to the provider's lambda function.
     * <p>
     * Default: Size.gibibytes(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getKubectlMemory() {
        return null;
    }

    /**
     * (experimental) Subnets to host the `kubectl` compute resources.
     * <p>
     * If not specified, the k8s
     * endpoint is expected to be accessible publicly.
     * <p>
     * Default: - k8s endpoint is expected to be accessible publicly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getKubectlPrivateSubnetIds() {
        return null;
    }

    /**
     * (experimental) An IAM role with cluster administrator and "system:masters" permissions.
     * <p>
     * Default: - if not specified, it not be possible to issue `kubectl` commands
     * against an imported cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getKubectlRoleArn() {
        return null;
    }

    /**
     * (experimental) A security group to use for `kubectl` execution.
     * <p>
     * If not specified, the k8s
     * endpoint is expected to be accessible publicly.
     * <p>
     * Default: - k8s endpoint is expected to be accessible publicly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getKubectlSecurityGroupId() {
        return null;
    }

    /**
     * (experimental) An Open ID Connect provider for this cluster that can be used to configure service accounts.
     * <p>
     * You can either import an existing provider using <code>iam.OpenIdConnectProvider.fromProviderArn</code>,
     * or create a new provider using <code>new eks.OpenIdConnectProvider</code>
     * <p>
     * Default: - if not specified `cluster.openIdConnectProvider` and `cluster.addServiceAccount` will throw an error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider() {
        return null;
    }

    /**
     * (experimental) Indicates whether Kubernetes resources added through `addManifest()` can be automatically pruned.
     * <p>
     * When this is enabled (default), prune labels will be
     * allocated and injected to each resource. These labels will then be used
     * when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrune() {
        return null;
    }

    /**
     * (experimental) Additional security groups associated with this cluster.
     * <p>
     * Default: - if not specified, no additional security groups will be
     * considered in `cluster.connections`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * (experimental) The VPC in which this Cluster was created.
     * <p>
     * Default: - if not specified `cluster.vpc` will throw an error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterAttributes> {
        private java.lang.String clusterName;
        private java.lang.String clusterCertificateAuthorityData;
        private java.lang.String clusterEncryptionConfigKeyArn;
        private java.lang.String clusterEndpoint;
        private java.lang.String clusterSecurityGroupId;
        private java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        private software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        private software.amazon.awscdk.Size kubectlMemory;
        private java.util.List<java.lang.String> kubectlPrivateSubnetIds;
        private java.lang.String kubectlRoleArn;
        private java.lang.String kubectlSecurityGroupId;
        private software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider;
        private java.lang.Boolean prune;
        private java.util.List<java.lang.String> securityGroupIds;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ClusterAttributes#getClusterName}
         * @param clusterName The physical name of the Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterCertificateAuthorityData}
         * @param clusterCertificateAuthorityData The certificate-authority-data for your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterCertificateAuthorityData(java.lang.String clusterCertificateAuthorityData) {
            this.clusterCertificateAuthorityData = clusterCertificateAuthorityData;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterEncryptionConfigKeyArn}
         * @param clusterEncryptionConfigKeyArn Amazon Resource Name (ARN) or alias of the customer master key (CMK).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterEncryptionConfigKeyArn(java.lang.String clusterEncryptionConfigKeyArn) {
            this.clusterEncryptionConfigKeyArn = clusterEncryptionConfigKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterEndpoint}
         * @param clusterEndpoint The API Server endpoint URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterEndpoint(java.lang.String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterSecurityGroupId}
         * @param clusterSecurityGroupId The cluster security group that was created by Amazon EKS for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterSecurityGroupId(java.lang.String clusterSecurityGroupId) {
            this.clusterSecurityGroupId = clusterSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlEnvironment}
         * @param kubectlEnvironment Environment variables to use when running `kubectl` against this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlEnvironment(java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment) {
            this.kubectlEnvironment = kubectlEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlLayer}
         * @param kubectlLayer An AWS Lambda Layer which includes `kubectl`, Helm and the AWS CLI.
         *                     This layer
         *                     is used by the kubectl handler to apply manifests and install helm charts.
         *                     <p>
         *                     The handler expects the layer to include the following executables:
         *                     <p>
         *                     <blockquote><pre>
         *                     helm/helm
         *                     kubectl/kubectl
         *                     awscli/aws
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlLayer(software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer) {
            this.kubectlLayer = kubectlLayer;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlMemory}
         * @param kubectlMemory Amount of memory to allocate to the provider's lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlMemory(software.amazon.awscdk.Size kubectlMemory) {
            this.kubectlMemory = kubectlMemory;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlPrivateSubnetIds}
         * @param kubectlPrivateSubnetIds Subnets to host the `kubectl` compute resources.
         *                                If not specified, the k8s
         *                                endpoint is expected to be accessible publicly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlPrivateSubnetIds(java.util.List<java.lang.String> kubectlPrivateSubnetIds) {
            this.kubectlPrivateSubnetIds = kubectlPrivateSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlRoleArn}
         * @param kubectlRoleArn An IAM role with cluster administrator and "system:masters" permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlRoleArn(java.lang.String kubectlRoleArn) {
            this.kubectlRoleArn = kubectlRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlSecurityGroupId}
         * @param kubectlSecurityGroupId A security group to use for `kubectl` execution.
         *                               If not specified, the k8s
         *                               endpoint is expected to be accessible publicly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlSecurityGroupId(java.lang.String kubectlSecurityGroupId) {
            this.kubectlSecurityGroupId = kubectlSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getOpenIdConnectProvider}
         * @param openIdConnectProvider An Open ID Connect provider for this cluster that can be used to configure service accounts.
         *                              You can either import an existing provider using <code>iam.OpenIdConnectProvider.fromProviderArn</code>,
         *                              or create a new provider using <code>new eks.OpenIdConnectProvider</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder openIdConnectProvider(software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider) {
            this.openIdConnectProvider = openIdConnectProvider;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getPrune}
         * @param prune Indicates whether Kubernetes resources added through `addManifest()` can be automatically pruned.
         *              When this is enabled (default), prune labels will be
         *              allocated and injected to each resource. These labels will then be used
         *              when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getSecurityGroupIds}
         * @param securityGroupIds Additional security groups associated with this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getVpc}
         * @param vpc The VPC in which this Cluster was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClusterAttributes build() {
            return new Jsii$Proxy(clusterName, clusterCertificateAuthorityData, clusterEncryptionConfigKeyArn, clusterEndpoint, clusterSecurityGroupId, kubectlEnvironment, kubectlLayer, kubectlMemory, kubectlPrivateSubnetIds, kubectlRoleArn, kubectlSecurityGroupId, openIdConnectProvider, prune, securityGroupIds, vpc);
        }
    }

    /**
     * An implementation for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterAttributes {
        private final java.lang.String clusterName;
        private final java.lang.String clusterCertificateAuthorityData;
        private final java.lang.String clusterEncryptionConfigKeyArn;
        private final java.lang.String clusterEndpoint;
        private final java.lang.String clusterSecurityGroupId;
        private final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        private final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        private final software.amazon.awscdk.Size kubectlMemory;
        private final java.util.List<java.lang.String> kubectlPrivateSubnetIds;
        private final java.lang.String kubectlRoleArn;
        private final java.lang.String kubectlSecurityGroupId;
        private final software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider;
        private final java.lang.Boolean prune;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterCertificateAuthorityData = software.amazon.jsii.Kernel.get(this, "clusterCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEncryptionConfigKeyArn = software.amazon.jsii.Kernel.get(this, "clusterEncryptionConfigKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpoint = software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterSecurityGroupId = software.amazon.jsii.Kernel.get(this, "clusterSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kubectlEnvironment = software.amazon.jsii.Kernel.get(this, "kubectlEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kubectlLayer = software.amazon.jsii.Kernel.get(this, "kubectlLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.kubectlMemory = software.amazon.jsii.Kernel.get(this, "kubectlMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.kubectlPrivateSubnetIds = software.amazon.jsii.Kernel.get(this, "kubectlPrivateSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kubectlRoleArn = software.amazon.jsii.Kernel.get(this, "kubectlRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kubectlSecurityGroupId = software.amazon.jsii.Kernel.get(this, "kubectlSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openIdConnectProvider = software.amazon.jsii.Kernel.get(this, "openIdConnectProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IOpenIdConnectProvider.class));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String clusterName, final java.lang.String clusterCertificateAuthorityData, final java.lang.String clusterEncryptionConfigKeyArn, final java.lang.String clusterEndpoint, final java.lang.String clusterSecurityGroupId, final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment, final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer, final software.amazon.awscdk.Size kubectlMemory, final java.util.List<java.lang.String> kubectlPrivateSubnetIds, final java.lang.String kubectlRoleArn, final java.lang.String kubectlSecurityGroupId, final software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider, final java.lang.Boolean prune, final java.util.List<java.lang.String> securityGroupIds, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(clusterName, "clusterName is required");
            this.clusterCertificateAuthorityData = clusterCertificateAuthorityData;
            this.clusterEncryptionConfigKeyArn = clusterEncryptionConfigKeyArn;
            this.clusterEndpoint = clusterEndpoint;
            this.clusterSecurityGroupId = clusterSecurityGroupId;
            this.kubectlEnvironment = kubectlEnvironment;
            this.kubectlLayer = kubectlLayer;
            this.kubectlMemory = kubectlMemory;
            this.kubectlPrivateSubnetIds = kubectlPrivateSubnetIds;
            this.kubectlRoleArn = kubectlRoleArn;
            this.kubectlSecurityGroupId = kubectlSecurityGroupId;
            this.openIdConnectProvider = openIdConnectProvider;
            this.prune = prune;
            this.securityGroupIds = securityGroupIds;
            this.vpc = vpc;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getClusterCertificateAuthorityData() {
            return this.clusterCertificateAuthorityData;
        }

        @Override
        public final java.lang.String getClusterEncryptionConfigKeyArn() {
            return this.clusterEncryptionConfigKeyArn;
        }

        @Override
        public final java.lang.String getClusterEndpoint() {
            return this.clusterEndpoint;
        }

        @Override
        public final java.lang.String getClusterSecurityGroupId() {
            return this.clusterSecurityGroupId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
            return this.kubectlEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
            return this.kubectlLayer;
        }

        @Override
        public final software.amazon.awscdk.Size getKubectlMemory() {
            return this.kubectlMemory;
        }

        @Override
        public final java.util.List<java.lang.String> getKubectlPrivateSubnetIds() {
            return this.kubectlPrivateSubnetIds;
        }

        @Override
        public final java.lang.String getKubectlRoleArn() {
            return this.kubectlRoleArn;
        }

        @Override
        public final java.lang.String getKubectlSecurityGroupId() {
            return this.kubectlSecurityGroupId;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider() {
            return this.openIdConnectProvider;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            if (this.getClusterCertificateAuthorityData() != null) {
                data.set("clusterCertificateAuthorityData", om.valueToTree(this.getClusterCertificateAuthorityData()));
            }
            if (this.getClusterEncryptionConfigKeyArn() != null) {
                data.set("clusterEncryptionConfigKeyArn", om.valueToTree(this.getClusterEncryptionConfigKeyArn()));
            }
            if (this.getClusterEndpoint() != null) {
                data.set("clusterEndpoint", om.valueToTree(this.getClusterEndpoint()));
            }
            if (this.getClusterSecurityGroupId() != null) {
                data.set("clusterSecurityGroupId", om.valueToTree(this.getClusterSecurityGroupId()));
            }
            if (this.getKubectlEnvironment() != null) {
                data.set("kubectlEnvironment", om.valueToTree(this.getKubectlEnvironment()));
            }
            if (this.getKubectlLayer() != null) {
                data.set("kubectlLayer", om.valueToTree(this.getKubectlLayer()));
            }
            if (this.getKubectlMemory() != null) {
                data.set("kubectlMemory", om.valueToTree(this.getKubectlMemory()));
            }
            if (this.getKubectlPrivateSubnetIds() != null) {
                data.set("kubectlPrivateSubnetIds", om.valueToTree(this.getKubectlPrivateSubnetIds()));
            }
            if (this.getKubectlRoleArn() != null) {
                data.set("kubectlRoleArn", om.valueToTree(this.getKubectlRoleArn()));
            }
            if (this.getKubectlSecurityGroupId() != null) {
                data.set("kubectlSecurityGroupId", om.valueToTree(this.getKubectlSecurityGroupId()));
            }
            if (this.getOpenIdConnectProvider() != null) {
                data.set("openIdConnectProvider", om.valueToTree(this.getOpenIdConnectProvider()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.ClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterAttributes.Jsii$Proxy that = (ClusterAttributes.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (this.clusterCertificateAuthorityData != null ? !this.clusterCertificateAuthorityData.equals(that.clusterCertificateAuthorityData) : that.clusterCertificateAuthorityData != null) return false;
            if (this.clusterEncryptionConfigKeyArn != null ? !this.clusterEncryptionConfigKeyArn.equals(that.clusterEncryptionConfigKeyArn) : that.clusterEncryptionConfigKeyArn != null) return false;
            if (this.clusterEndpoint != null ? !this.clusterEndpoint.equals(that.clusterEndpoint) : that.clusterEndpoint != null) return false;
            if (this.clusterSecurityGroupId != null ? !this.clusterSecurityGroupId.equals(that.clusterSecurityGroupId) : that.clusterSecurityGroupId != null) return false;
            if (this.kubectlEnvironment != null ? !this.kubectlEnvironment.equals(that.kubectlEnvironment) : that.kubectlEnvironment != null) return false;
            if (this.kubectlLayer != null ? !this.kubectlLayer.equals(that.kubectlLayer) : that.kubectlLayer != null) return false;
            if (this.kubectlMemory != null ? !this.kubectlMemory.equals(that.kubectlMemory) : that.kubectlMemory != null) return false;
            if (this.kubectlPrivateSubnetIds != null ? !this.kubectlPrivateSubnetIds.equals(that.kubectlPrivateSubnetIds) : that.kubectlPrivateSubnetIds != null) return false;
            if (this.kubectlRoleArn != null ? !this.kubectlRoleArn.equals(that.kubectlRoleArn) : that.kubectlRoleArn != null) return false;
            if (this.kubectlSecurityGroupId != null ? !this.kubectlSecurityGroupId.equals(that.kubectlSecurityGroupId) : that.kubectlSecurityGroupId != null) return false;
            if (this.openIdConnectProvider != null ? !this.openIdConnectProvider.equals(that.openIdConnectProvider) : that.openIdConnectProvider != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.clusterCertificateAuthorityData != null ? this.clusterCertificateAuthorityData.hashCode() : 0);
            result = 31 * result + (this.clusterEncryptionConfigKeyArn != null ? this.clusterEncryptionConfigKeyArn.hashCode() : 0);
            result = 31 * result + (this.clusterEndpoint != null ? this.clusterEndpoint.hashCode() : 0);
            result = 31 * result + (this.clusterSecurityGroupId != null ? this.clusterSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.kubectlEnvironment != null ? this.kubectlEnvironment.hashCode() : 0);
            result = 31 * result + (this.kubectlLayer != null ? this.kubectlLayer.hashCode() : 0);
            result = 31 * result + (this.kubectlMemory != null ? this.kubectlMemory.hashCode() : 0);
            result = 31 * result + (this.kubectlPrivateSubnetIds != null ? this.kubectlPrivateSubnetIds.hashCode() : 0);
            result = 31 * result + (this.kubectlRoleArn != null ? this.kubectlRoleArn.hashCode() : 0);
            result = 31 * result + (this.kubectlSecurityGroupId != null ? this.kubectlSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.openIdConnectProvider != null ? this.openIdConnectProvider.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
