package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * (experimental) Elastic Load Balancing provides the following security policies for Application Load Balancers.
 * <p>
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 * <p>
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 * <p>
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:29.978Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.SslPolicy")
public enum SslPolicy {
    /**
     * (experimental) The recommended security policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RECOMMENDED,
    /**
     * (experimental) Strong foward secrecy ciphers and TLV1.2 only (2020 edition). Same as FORWARD_SECRECY_TLS12_RES, but only supports GCM versions of the TLS ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FORWARD_SECRECY_TLS12_RES_GCM,
    /**
     * (experimental) Strong forward secrecy ciphers and TLS1.2 only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FORWARD_SECRECY_TLS12_RES,
    /**
     * (experimental) Forward secrecy ciphers and TLS1.2 only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FORWARD_SECRECY_TLS12,
    /**
     * (experimental) Forward secrecy ciphers only with TLS1.1 and higher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FORWARD_SECRECY_TLS11,
    /**
     * (experimental) Forward secrecy ciphers only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FORWARD_SECRECY,
    /**
     * (experimental) TLS1.2 only and no SHA ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TLS12,
    /**
     * (experimental) TLS1.2 only with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TLS12_EXT,
    /**
     * (experimental) TLS1.1 and higher with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TLS11,
    /**
     * (experimental) Support for DES-CBC3-SHA.
     * <p>
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LEGACY,
}
