/**
 * <h1>Amazon Elasticsearch Service Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * Features                           | Stability
 * -----------------------------------|----------------------------------------------------------------
 * CFN Resources                      | <img alt="Stable" src="https://img.shields.io/badge/stable-success.svg?style=for-the-badge">
 * Higher level constructs for Domain | <img alt="Stable" src="https://img.shields.io/badge/stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * <strong>CFN Resources:</strong> All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always
 * stable and safe to use.
 * <p>
 * </blockquote><!-- --><blockquote>
 * <p>
 * <strong>Stable:</strong> Higher level constructs in this module that are marked stable will not undergo any
 * breaking changes. They will strictly follow the <a href="https://semver.org/">Semantic Versioning</a> model.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Quick start</h2>
 * <p>
 * Create a development cluster by simply specifying the version:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_elasticsearch;
 * 
 * 
 * Domain devDomain = new Domain(this, "Domain", new DomainProps()
 *         .version(es.ElasticsearchVersion.getV7_1()));
 * </pre></blockquote>
 * <p>
 * To perform version upgrades without replacing the entire domain, specify the <code>enableVersionUpgrade</code> property.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_elasticsearch;
 * 
 * 
 * Domain devDomain = new Domain(this, "Domain", new DomainProps()
 *         .version(es.ElasticsearchVersion.getV7_10())
 *         .enableVersionUpgrade(true));
 * </pre></blockquote>
 * <p>
 * Create a production grade cluster by also specifying things like capacity and az distribution
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object prodDomain = Domain.Builder.create(this, "Domain")
 *         .version(es.ElasticsearchVersion.getV7_1())
 *         .capacity(Map.of(
 *                 "masterNodes", 5,
 *                 "dataNodes", 20))
 *         .ebs(Map.of(
 *                 "volumeSize", 20))
 *         .zoneAwareness(Map.of(
 *                 "availabilityZoneCount", 3))
 *         .logging(Map.of(
 *                 "slowSearchLogEnabled", true,
 *                 "appLogEnabled", true,
 *                 "slowIndexLogEnabled", true))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This creates an Elasticsearch cluster and automatically sets up log groups for
 * logging the domain logs and slow search logs.
 * <p>
 * <h2>A note about SLR</h2>
 * <p>
 * Some cluster configurations (e.g VPC access) require the existence of the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/slr-es.html"><code>AWSServiceRoleForAmazonElasticsearchService</code></a> Service-Linked Role.
 * <p>
 * When performing such operations via the AWS Console, this SLR is created automatically when needed. However, this is not the behavior when using CloudFormation. If an SLR is needed, but doesn't exist, you will encounter a failure message simlar to:
 * <p>
 * <blockquote><pre>
 * Before you can proceed, you must enable a service-linked role to give Amazon ES...
 * </pre></blockquote>
 * <p>
 * To resolve this, you need to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html#create-service-linked-role">create</a> the SLR. We recommend using the AWS CLI:
 * <p>
 * <blockquote><pre>
 * aws iam create-service-linked-role --aws-service-name es.amazonaws.com
 * </pre></blockquote>
 * <p>
 * You can also create it using the CDK, <strong>but note that only the first application deploying this will succeed</strong>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * CfnServiceLinkedRole slr = new CfnServiceLinkedRole(this, "ElasticSLR", new CfnServiceLinkedRoleProps()
 *         .awsServiceName("es.amazonaws.com"));
 * </pre></blockquote>
 * <p>
 * <h2>Importing existing domains</h2>
 * <p>
 * To import an existing domain into your CDK application, use the <code>Domain.fromDomainEndpoint</code> factory method.
 * This method accepts a domain endpoint of an already existing domain:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * String domainEndpoint = "https://my-domain-jcjotrt6f7otem4sqcwbch3c4u.us-east-1.es.amazonaws.com";
 * Object domain = Domain.fromDomainEndpoint(this, "ImportedDomain", domainEndpoint);
 * </pre></blockquote>
 * <p>
 * <h2>Permissions</h2>
 * <p>
 * <h3>IAM</h3>
 * <p>
 * Helper methods also exist for managing access to the domain.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object lambda = Function.Builder.create(this, "Lambda").build();
 * 
 * // Grant write access to the app-search index
 * domain.grantIndexWrite("app-search", lambda);
 * 
 * // Grant read access to the 'app-search/_search' path
 * domain.grantPathRead("app-search/_search", lambda);
 * </pre></blockquote>
 * <p>
 * <h2>Encryption</h2>
 * <p>
 * The domain can also be created with encryption enabled:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object domain = Domain.Builder.create(this, "Domain")
 *         .version(es.ElasticsearchVersion.getV7_4())
 *         .ebs(Map.of(
 *                 "volumeSize", 100,
 *                 "volumeType", EbsDeviceVolumeType.getGENERAL_PURPOSE_SSD()))
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(Map.of(
 *                 "enabled", true))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This sets up the domain with node to node encryption and encryption at
 * rest. You can also choose to supply your own KMS key to use for encryption at
 * rest.
 * <p>
 * <h2>VPC Support</h2>
 * <p>
 * Elasticsearch domains can be placed inside a VPC, providing a secure communication between Amazon ES and other services within the VPC without the need for an internet gateway, NAT device, or VPN connection.
 * <p>
 * <blockquote>
 * <p>
 * Visit <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html">VPC Support for Amazon Elasticsearch Service Domains</a> for more details.
 * <p>
 * </blockquote>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object vpc = new Vpc(this, "Vpc");
 * Object domainProps = Map.of(
 *         "version", es.ElasticsearchVersion.getV7_1(),
 *         "removalPolicy", RemovalPolicy.getDESTROY(),
 *         "vpc", vpc,
 *         // must be enabled since our VPC contains multiple private subnets.
 *         "zoneAwareness", Map.of(
 *                 "enabled", true),
 *         "capacity", Map.of(
 *                 // must be an even number since the default az count is 2.
 *                 "dataNodes", 2));
 * new Domain(this, "Domain", domainProps);
 * </pre></blockquote>
 * <p>
 * In addition, you can use the <code>vpcSubnets</code> property to control which specific subnets will be used, and the <code>securityGroups</code> property to control
 * which security groups will be attached to the domain. By default, CDK will select all <em>private</em> subnets in the VPC, and create one dedicated security group.
 * <p>
 * <h2>Metrics</h2>
 * <p>
 * Helper methods exist to access common domain metrics for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object freeStorageSpace = domain.metricFreeStorageSpace();
 * Object masterSysMemoryUtilization = domain.metric("MasterSysMemoryUtilization");
 * </pre></blockquote>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Fine grained access control</h2>
 * <p>
 * The domain can also be created with a master user configured. The password can
 * be supplied or dynamically created if not supplied.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object domain = Domain.Builder.create(this, "Domain")
 *         .version(es.ElasticsearchVersion.getV7_1())
 *         .enforceHttps(true)
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(Map.of(
 *                 "enabled", true))
 *         .fineGrainedAccessControl(Map.of(
 *                 "masterUserName", "master-user"))
 *         .build();
 * 
 * Object masterUserPassword = domain.getMasterUserPassword();
 * </pre></blockquote>
 * <p>
 * <h2>Using unsigned basic auth</h2>
 * <p>
 * For convenience, the domain can be configured to allow unsigned HTTP requests
 * that use basic auth. Unless the domain is configured to be part of a VPC this
 * means anyone can access the domain using the configured master username and
 * password.
 * <p>
 * To enable unsigned basic auth access the domain is configured with an access
 * policy that allows anyonmous requests, HTTPS required, node to node encryption,
 * encryption at rest and fine grained access control.
 * <p>
 * If the above settings are not set they will be configured as part of enabling
 * unsigned basic auth. If they are set with conflicting values, an error will be
 * thrown.
 * <p>
 * If no master user is configured a default master user is created with the
 * username <code>admin</code>.
 * <p>
 * If no password is configured a default master user password is created and
 * stored in the AWS Secrets Manager as secret. The secret has the prefix
 * <code>&lt;domain id&gt;MasterUser</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object domain = Domain.Builder.create(this, "Domain")
 *         .version(es.ElasticsearchVersion.getV7_1())
 *         .useUnsignedBasicAuth(true)
 *         .build();
 * 
 * Object masterUserPassword = domain.getMasterUserPassword();
 * </pre></blockquote>
 * <p>
 * <h2>Audit logs</h2>
 * <p>
 * Audit logs can be enabled for a domain, but only when fine grained access control is enabled.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object domain = Domain.Builder.create(this, "Domain")
 *         .version(es.ElasticsearchVersion.getV7_1())
 *         .enforceHttps(true)
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(Map.of(
 *                 "enabled", true))
 *         .fineGrainedAccessControl(Map.of(
 *                 "masterUserName", "master-user"))
 *         .logging(Map.of(
 *                 "auditLogEnabled", true,
 *                 "slowSearchLogEnabled", true,
 *                 "appLogEnabled", true,
 *                 "slowIndexLogEnabled", true))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>UltraWarm</h2>
 * <p>
 * UltraWarm nodes can be enabled to provide a cost-effective way to store large amounts of read-only data.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object domain = Domain.Builder.create(this, "Domain")
 *         .version(es.ElasticsearchVersion.getV7_10())
 *         .capacity(Map.of(
 *                 "masterNodes", 2,
 *                 "warmNodes", 2,
 *                 "warmInstanceType", "ultrawarm1.medium.elasticsearch"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Custom endpoint</h2>
 * <p>
 * Custom endpoints can be configured to reach the ES domain under a custom domain name.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Domain.Builder.create(stack, "Domain")
 *         .version(ElasticsearchVersion.getV7_7())
 *         .customEndpoint(Map.of(
 *                 "domainName", "search.example.com"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * It is also possible to specify a custom certificate instead of the auto-generated one.
 * <p>
 * Additionally, an automatic CNAME-Record is created if a hosted zone is provided for the custom endpoint
 */
package software.amazon.awscdk.services.elasticsearch;
