package software.amazon.awscdk.services.fsx;

/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:31.268Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem")
public class CfnFileSystem extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fsx.CfnFileSystem.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FSx::FileSystem`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.CfnFileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLustreMountName() {
        return software.amazon.jsii.Kernel.get(this, "attrLustreMountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::FSx::FileSystem.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemType() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemType", java.util.Objects.requireNonNull(value, "fileSystemType is required"));
    }

    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", java.util.Objects.requireNonNull(value, "subnetIds is required"));
    }

    /**
     * `AWS::FSx::FileSystem.BackupId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::FSx::FileSystem.BackupId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupId", value);
    }

    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLustreConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lustreConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLustreConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnFileSystem.LustreConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "lustreConfiguration", value);
    }

    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLustreConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lustreConfiguration", value);
    }

    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacity() {
        return software.amazon.jsii.Kernel.get(this, "storageCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "storageCapacity", value);
    }

    /**
     * `AWS::FSx::FileSystem.StorageType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::FSx::FileSystem.StorageType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWindowsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "windowsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWindowsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnFileSystem.WindowsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "windowsConfiguration", value);
    }

    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWindowsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "windowsConfiguration", value);
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.LustreConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LustreConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LustreConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutoImportPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutoImportPolicy() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutomaticBackupRetentionDays`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupRetentionDays() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.CopyTagsToBackups`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToBackups() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.DailyAutomaticBackupStartTime`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDailyAutomaticBackupStartTime() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.DeploymentType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentType() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.DriveCacheType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDriveCacheType() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.ExportPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExportPath() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportedFileChunkSize`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getImportedFileChunkSize() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImportPath() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.PerUnitStorageThroughput`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPerUnitStorageThroughput() {
            return null;
        }

        /**
         * `CfnFileSystem.LustreConfigurationProperty.WeeklyMaintenanceStartTime`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LustreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LustreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LustreConfigurationProperty> {
            private java.lang.String autoImportPolicy;
            private java.lang.Number automaticBackupRetentionDays;
            private java.lang.Object copyTagsToBackups;
            private java.lang.String dailyAutomaticBackupStartTime;
            private java.lang.String deploymentType;
            private java.lang.String driveCacheType;
            private java.lang.String exportPath;
            private java.lang.Number importedFileChunkSize;
            private java.lang.String importPath;
            private java.lang.Number perUnitStorageThroughput;
            private java.lang.String weeklyMaintenanceStartTime;

            /**
             * Sets the value of {@link LustreConfigurationProperty#getAutoImportPolicy}
             * @param autoImportPolicy `CfnFileSystem.LustreConfigurationProperty.AutoImportPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportPolicy(java.lang.String autoImportPolicy) {
                this.autoImportPolicy = autoImportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getAutomaticBackupRetentionDays}
             * @param automaticBackupRetentionDays `CfnFileSystem.LustreConfigurationProperty.AutomaticBackupRetentionDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticBackupRetentionDays(java.lang.Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups `CfnFileSystem.LustreConfigurationProperty.CopyTagsToBackups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(java.lang.Boolean copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups `CfnFileSystem.LustreConfigurationProperty.CopyTagsToBackups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(software.amazon.awscdk.IResolvable copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDailyAutomaticBackupStartTime}
             * @param dailyAutomaticBackupStartTime `CfnFileSystem.LustreConfigurationProperty.DailyAutomaticBackupStartTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyAutomaticBackupStartTime(java.lang.String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDeploymentType}
             * @param deploymentType `CfnFileSystem.LustreConfigurationProperty.DeploymentType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getDriveCacheType}
             * @param driveCacheType `CfnFileSystem.LustreConfigurationProperty.DriveCacheType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder driveCacheType(java.lang.String driveCacheType) {
                this.driveCacheType = driveCacheType;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getExportPath}
             * @param exportPath `CfnFileSystem.LustreConfigurationProperty.ExportPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportPath(java.lang.String exportPath) {
                this.exportPath = exportPath;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getImportedFileChunkSize}
             * @param importedFileChunkSize `CfnFileSystem.LustreConfigurationProperty.ImportedFileChunkSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder importedFileChunkSize(java.lang.Number importedFileChunkSize) {
                this.importedFileChunkSize = importedFileChunkSize;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getImportPath}
             * @param importPath `CfnFileSystem.LustreConfigurationProperty.ImportPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder importPath(java.lang.String importPath) {
                this.importPath = importPath;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getPerUnitStorageThroughput}
             * @param perUnitStorageThroughput `CfnFileSystem.LustreConfigurationProperty.PerUnitStorageThroughput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perUnitStorageThroughput(java.lang.Number perUnitStorageThroughput) {
                this.perUnitStorageThroughput = perUnitStorageThroughput;
                return this;
            }

            /**
             * Sets the value of {@link LustreConfigurationProperty#getWeeklyMaintenanceStartTime}
             * @param weeklyMaintenanceStartTime `CfnFileSystem.LustreConfigurationProperty.WeeklyMaintenanceStartTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklyMaintenanceStartTime(java.lang.String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LustreConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LustreConfigurationProperty build() {
                return new Jsii$Proxy(autoImportPolicy, automaticBackupRetentionDays, copyTagsToBackups, dailyAutomaticBackupStartTime, deploymentType, driveCacheType, exportPath, importedFileChunkSize, importPath, perUnitStorageThroughput, weeklyMaintenanceStartTime);
            }
        }

        /**
         * An implementation for {@link LustreConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LustreConfigurationProperty {
            private final java.lang.String autoImportPolicy;
            private final java.lang.Number automaticBackupRetentionDays;
            private final java.lang.Object copyTagsToBackups;
            private final java.lang.String dailyAutomaticBackupStartTime;
            private final java.lang.String deploymentType;
            private final java.lang.String driveCacheType;
            private final java.lang.String exportPath;
            private final java.lang.Number importedFileChunkSize;
            private final java.lang.String importPath;
            private final java.lang.Number perUnitStorageThroughput;
            private final java.lang.String weeklyMaintenanceStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoImportPolicy = software.amazon.jsii.Kernel.get(this, "autoImportPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.automaticBackupRetentionDays = software.amazon.jsii.Kernel.get(this, "automaticBackupRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.copyTagsToBackups = software.amazon.jsii.Kernel.get(this, "copyTagsToBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dailyAutomaticBackupStartTime = software.amazon.jsii.Kernel.get(this, "dailyAutomaticBackupStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.driveCacheType = software.amazon.jsii.Kernel.get(this, "driveCacheType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportPath = software.amazon.jsii.Kernel.get(this, "exportPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.importedFileChunkSize = software.amazon.jsii.Kernel.get(this, "importedFileChunkSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.importPath = software.amazon.jsii.Kernel.get(this, "importPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.perUnitStorageThroughput = software.amazon.jsii.Kernel.get(this, "perUnitStorageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String autoImportPolicy, final java.lang.Number automaticBackupRetentionDays, final java.lang.Object copyTagsToBackups, final java.lang.String dailyAutomaticBackupStartTime, final java.lang.String deploymentType, final java.lang.String driveCacheType, final java.lang.String exportPath, final java.lang.Number importedFileChunkSize, final java.lang.String importPath, final java.lang.Number perUnitStorageThroughput, final java.lang.String weeklyMaintenanceStartTime) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoImportPolicy = autoImportPolicy;
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                this.copyTagsToBackups = copyTagsToBackups;
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                this.deploymentType = deploymentType;
                this.driveCacheType = driveCacheType;
                this.exportPath = exportPath;
                this.importedFileChunkSize = importedFileChunkSize;
                this.importPath = importPath;
                this.perUnitStorageThroughput = perUnitStorageThroughput;
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            }

            @Override
            public final java.lang.String getAutoImportPolicy() {
                return this.autoImportPolicy;
            }

            @Override
            public final java.lang.Number getAutomaticBackupRetentionDays() {
                return this.automaticBackupRetentionDays;
            }

            @Override
            public final java.lang.Object getCopyTagsToBackups() {
                return this.copyTagsToBackups;
            }

            @Override
            public final java.lang.String getDailyAutomaticBackupStartTime() {
                return this.dailyAutomaticBackupStartTime;
            }

            @Override
            public final java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            public final java.lang.String getDriveCacheType() {
                return this.driveCacheType;
            }

            @Override
            public final java.lang.String getExportPath() {
                return this.exportPath;
            }

            @Override
            public final java.lang.Number getImportedFileChunkSize() {
                return this.importedFileChunkSize;
            }

            @Override
            public final java.lang.String getImportPath() {
                return this.importPath;
            }

            @Override
            public final java.lang.Number getPerUnitStorageThroughput() {
                return this.perUnitStorageThroughput;
            }

            @Override
            public final java.lang.String getWeeklyMaintenanceStartTime() {
                return this.weeklyMaintenanceStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoImportPolicy() != null) {
                    data.set("autoImportPolicy", om.valueToTree(this.getAutoImportPolicy()));
                }
                if (this.getAutomaticBackupRetentionDays() != null) {
                    data.set("automaticBackupRetentionDays", om.valueToTree(this.getAutomaticBackupRetentionDays()));
                }
                if (this.getCopyTagsToBackups() != null) {
                    data.set("copyTagsToBackups", om.valueToTree(this.getCopyTagsToBackups()));
                }
                if (this.getDailyAutomaticBackupStartTime() != null) {
                    data.set("dailyAutomaticBackupStartTime", om.valueToTree(this.getDailyAutomaticBackupStartTime()));
                }
                if (this.getDeploymentType() != null) {
                    data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                }
                if (this.getDriveCacheType() != null) {
                    data.set("driveCacheType", om.valueToTree(this.getDriveCacheType()));
                }
                if (this.getExportPath() != null) {
                    data.set("exportPath", om.valueToTree(this.getExportPath()));
                }
                if (this.getImportedFileChunkSize() != null) {
                    data.set("importedFileChunkSize", om.valueToTree(this.getImportedFileChunkSize()));
                }
                if (this.getImportPath() != null) {
                    data.set("importPath", om.valueToTree(this.getImportPath()));
                }
                if (this.getPerUnitStorageThroughput() != null) {
                    data.set("perUnitStorageThroughput", om.valueToTree(this.getPerUnitStorageThroughput()));
                }
                if (this.getWeeklyMaintenanceStartTime() != null) {
                    data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.LustreConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LustreConfigurationProperty.Jsii$Proxy that = (LustreConfigurationProperty.Jsii$Proxy) o;

                if (this.autoImportPolicy != null ? !this.autoImportPolicy.equals(that.autoImportPolicy) : that.autoImportPolicy != null) return false;
                if (this.automaticBackupRetentionDays != null ? !this.automaticBackupRetentionDays.equals(that.automaticBackupRetentionDays) : that.automaticBackupRetentionDays != null) return false;
                if (this.copyTagsToBackups != null ? !this.copyTagsToBackups.equals(that.copyTagsToBackups) : that.copyTagsToBackups != null) return false;
                if (this.dailyAutomaticBackupStartTime != null ? !this.dailyAutomaticBackupStartTime.equals(that.dailyAutomaticBackupStartTime) : that.dailyAutomaticBackupStartTime != null) return false;
                if (this.deploymentType != null ? !this.deploymentType.equals(that.deploymentType) : that.deploymentType != null) return false;
                if (this.driveCacheType != null ? !this.driveCacheType.equals(that.driveCacheType) : that.driveCacheType != null) return false;
                if (this.exportPath != null ? !this.exportPath.equals(that.exportPath) : that.exportPath != null) return false;
                if (this.importedFileChunkSize != null ? !this.importedFileChunkSize.equals(that.importedFileChunkSize) : that.importedFileChunkSize != null) return false;
                if (this.importPath != null ? !this.importPath.equals(that.importPath) : that.importPath != null) return false;
                if (this.perUnitStorageThroughput != null ? !this.perUnitStorageThroughput.equals(that.perUnitStorageThroughput) : that.perUnitStorageThroughput != null) return false;
                return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoImportPolicy != null ? this.autoImportPolicy.hashCode() : 0;
                result = 31 * result + (this.automaticBackupRetentionDays != null ? this.automaticBackupRetentionDays.hashCode() : 0);
                result = 31 * result + (this.copyTagsToBackups != null ? this.copyTagsToBackups.hashCode() : 0);
                result = 31 * result + (this.dailyAutomaticBackupStartTime != null ? this.dailyAutomaticBackupStartTime.hashCode() : 0);
                result = 31 * result + (this.deploymentType != null ? this.deploymentType.hashCode() : 0);
                result = 31 * result + (this.driveCacheType != null ? this.driveCacheType.hashCode() : 0);
                result = 31 * result + (this.exportPath != null ? this.exportPath.hashCode() : 0);
                result = 31 * result + (this.importedFileChunkSize != null ? this.importedFileChunkSize.hashCode() : 0);
                result = 31 * result + (this.importPath != null ? this.importPath.hashCode() : 0);
                result = 31 * result + (this.perUnitStorageThroughput != null ? this.perUnitStorageThroughput.hashCode() : 0);
                result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelfManagedActiveDirectoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DnsIps`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsIps() {
            return null;
        }

        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DomainName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
            return null;
        }

        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.FileSystemAdministratorsGroup`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemAdministratorsGroup() {
            return null;
        }

        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.OrganizationalUnitDistinguishedName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationalUnitDistinguishedName() {
            return null;
        }

        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.Password`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.UserName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelfManagedActiveDirectoryConfigurationProperty> {
            private java.util.List<java.lang.String> dnsIps;
            private java.lang.String domainName;
            private java.lang.String fileSystemAdministratorsGroup;
            private java.lang.String organizationalUnitDistinguishedName;
            private java.lang.String password;
            private java.lang.String userName;

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getDnsIps}
             * @param dnsIps `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DnsIps`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsIps(java.util.List<java.lang.String> dnsIps) {
                this.dnsIps = dnsIps;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getDomainName}
             * @param domainName `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DomainName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getFileSystemAdministratorsGroup}
             * @param fileSystemAdministratorsGroup `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.FileSystemAdministratorsGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemAdministratorsGroup(java.lang.String fileSystemAdministratorsGroup) {
                this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getOrganizationalUnitDistinguishedName}
             * @param organizationalUnitDistinguishedName `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.OrganizationalUnitDistinguishedName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnitDistinguishedName(java.lang.String organizationalUnitDistinguishedName) {
                this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getPassword}
             * @param password `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.Password`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getUserName}
             * @param userName `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.UserName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userName(java.lang.String userName) {
                this.userName = userName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelfManagedActiveDirectoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelfManagedActiveDirectoryConfigurationProperty build() {
                return new Jsii$Proxy(dnsIps, domainName, fileSystemAdministratorsGroup, organizationalUnitDistinguishedName, password, userName);
            }
        }

        /**
         * An implementation for {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfManagedActiveDirectoryConfigurationProperty {
            private final java.util.List<java.lang.String> dnsIps;
            private final java.lang.String domainName;
            private final java.lang.String fileSystemAdministratorsGroup;
            private final java.lang.String organizationalUnitDistinguishedName;
            private final java.lang.String password;
            private final java.lang.String userName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsIps = software.amazon.jsii.Kernel.get(this, "dnsIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileSystemAdministratorsGroup = software.amazon.jsii.Kernel.get(this, "fileSystemAdministratorsGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationalUnitDistinguishedName = software.amazon.jsii.Kernel.get(this, "organizationalUnitDistinguishedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.util.List<java.lang.String> dnsIps, final java.lang.String domainName, final java.lang.String fileSystemAdministratorsGroup, final java.lang.String organizationalUnitDistinguishedName, final java.lang.String password, final java.lang.String userName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsIps = dnsIps;
                this.domainName = domainName;
                this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
                this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
                this.password = password;
                this.userName = userName;
            }

            @Override
            public final java.util.List<java.lang.String> getDnsIps() {
                return this.dnsIps;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getFileSystemAdministratorsGroup() {
                return this.fileSystemAdministratorsGroup;
            }

            @Override
            public final java.lang.String getOrganizationalUnitDistinguishedName() {
                return this.organizationalUnitDistinguishedName;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUserName() {
                return this.userName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDnsIps() != null) {
                    data.set("dnsIps", om.valueToTree(this.getDnsIps()));
                }
                if (this.getDomainName() != null) {
                    data.set("domainName", om.valueToTree(this.getDomainName()));
                }
                if (this.getFileSystemAdministratorsGroup() != null) {
                    data.set("fileSystemAdministratorsGroup", om.valueToTree(this.getFileSystemAdministratorsGroup()));
                }
                if (this.getOrganizationalUnitDistinguishedName() != null) {
                    data.set("organizationalUnitDistinguishedName", om.valueToTree(this.getOrganizationalUnitDistinguishedName()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUserName() != null) {
                    data.set("userName", om.valueToTree(this.getUserName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy that = (SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy) o;

                if (this.dnsIps != null ? !this.dnsIps.equals(that.dnsIps) : that.dnsIps != null) return false;
                if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
                if (this.fileSystemAdministratorsGroup != null ? !this.fileSystemAdministratorsGroup.equals(that.fileSystemAdministratorsGroup) : that.fileSystemAdministratorsGroup != null) return false;
                if (this.organizationalUnitDistinguishedName != null ? !this.organizationalUnitDistinguishedName.equals(that.organizationalUnitDistinguishedName) : that.organizationalUnitDistinguishedName != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsIps != null ? this.dnsIps.hashCode() : 0;
                result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
                result = 31 * result + (this.fileSystemAdministratorsGroup != null ? this.fileSystemAdministratorsGroup.hashCode() : 0);
                result = 31 * result + (this.organizationalUnitDistinguishedName != null ? this.organizationalUnitDistinguishedName.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnFileSystem.WindowsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WindowsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WindowsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ThroughputCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThroughputCapacity();

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ActiveDirectoryId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActiveDirectoryId() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.Aliases`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.AutomaticBackupRetentionDays`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupRetentionDays() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.CopyTagsToBackups`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToBackups() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DailyAutomaticBackupStartTime`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDailyAutomaticBackupStartTime() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DeploymentType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentType() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.PreferredSubnetId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreferredSubnetId() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.SelfManagedActiveDirectoryConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedActiveDirectoryConfiguration() {
            return null;
        }

        /**
         * `CfnFileSystem.WindowsConfigurationProperty.WeeklyMaintenanceStartTime`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WindowsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WindowsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WindowsConfigurationProperty> {
            private java.lang.Number throughputCapacity;
            private java.lang.String activeDirectoryId;
            private java.util.List<java.lang.String> aliases;
            private java.lang.Number automaticBackupRetentionDays;
            private java.lang.Object copyTagsToBackups;
            private java.lang.String dailyAutomaticBackupStartTime;
            private java.lang.String deploymentType;
            private java.lang.String preferredSubnetId;
            private java.lang.Object selfManagedActiveDirectoryConfiguration;
            private java.lang.String weeklyMaintenanceStartTime;

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getThroughputCapacity}
             * @param throughputCapacity `CfnFileSystem.WindowsConfigurationProperty.ThroughputCapacity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputCapacity(java.lang.Number throughputCapacity) {
                this.throughputCapacity = throughputCapacity;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getActiveDirectoryId}
             * @param activeDirectoryId `CfnFileSystem.WindowsConfigurationProperty.ActiveDirectoryId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeDirectoryId(java.lang.String activeDirectoryId) {
                this.activeDirectoryId = activeDirectoryId;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getAliases}
             * @param aliases `CfnFileSystem.WindowsConfigurationProperty.Aliases`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliases(java.util.List<java.lang.String> aliases) {
                this.aliases = aliases;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getAutomaticBackupRetentionDays}
             * @param automaticBackupRetentionDays `CfnFileSystem.WindowsConfigurationProperty.AutomaticBackupRetentionDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticBackupRetentionDays(java.lang.Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups `CfnFileSystem.WindowsConfigurationProperty.CopyTagsToBackups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(java.lang.Boolean copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups `CfnFileSystem.WindowsConfigurationProperty.CopyTagsToBackups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(software.amazon.awscdk.IResolvable copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getDailyAutomaticBackupStartTime}
             * @param dailyAutomaticBackupStartTime `CfnFileSystem.WindowsConfigurationProperty.DailyAutomaticBackupStartTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyAutomaticBackupStartTime(java.lang.String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getDeploymentType}
             * @param deploymentType `CfnFileSystem.WindowsConfigurationProperty.DeploymentType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getPreferredSubnetId}
             * @param preferredSubnetId `CfnFileSystem.WindowsConfigurationProperty.PreferredSubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredSubnetId(java.lang.String preferredSubnetId) {
                this.preferredSubnetId = preferredSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getSelfManagedActiveDirectoryConfiguration}
             * @param selfManagedActiveDirectoryConfiguration `CfnFileSystem.WindowsConfigurationProperty.SelfManagedActiveDirectoryConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedActiveDirectoryConfiguration(software.amazon.awscdk.services.fsx.CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getSelfManagedActiveDirectoryConfiguration}
             * @param selfManagedActiveDirectoryConfiguration `CfnFileSystem.WindowsConfigurationProperty.SelfManagedActiveDirectoryConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedActiveDirectoryConfiguration(software.amazon.awscdk.IResolvable selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WindowsConfigurationProperty#getWeeklyMaintenanceStartTime}
             * @param weeklyMaintenanceStartTime `CfnFileSystem.WindowsConfigurationProperty.WeeklyMaintenanceStartTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklyMaintenanceStartTime(java.lang.String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WindowsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WindowsConfigurationProperty build() {
                return new Jsii$Proxy(throughputCapacity, activeDirectoryId, aliases, automaticBackupRetentionDays, copyTagsToBackups, dailyAutomaticBackupStartTime, deploymentType, preferredSubnetId, selfManagedActiveDirectoryConfiguration, weeklyMaintenanceStartTime);
            }
        }

        /**
         * An implementation for {@link WindowsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowsConfigurationProperty {
            private final java.lang.Number throughputCapacity;
            private final java.lang.String activeDirectoryId;
            private final java.util.List<java.lang.String> aliases;
            private final java.lang.Number automaticBackupRetentionDays;
            private final java.lang.Object copyTagsToBackups;
            private final java.lang.String dailyAutomaticBackupStartTime;
            private final java.lang.String deploymentType;
            private final java.lang.String preferredSubnetId;
            private final java.lang.Object selfManagedActiveDirectoryConfiguration;
            private final java.lang.String weeklyMaintenanceStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.throughputCapacity = software.amazon.jsii.Kernel.get(this, "throughputCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.activeDirectoryId = software.amazon.jsii.Kernel.get(this, "activeDirectoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.automaticBackupRetentionDays = software.amazon.jsii.Kernel.get(this, "automaticBackupRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.copyTagsToBackups = software.amazon.jsii.Kernel.get(this, "copyTagsToBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dailyAutomaticBackupStartTime = software.amazon.jsii.Kernel.get(this, "dailyAutomaticBackupStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preferredSubnetId = software.amazon.jsii.Kernel.get(this, "preferredSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selfManagedActiveDirectoryConfiguration = software.amazon.jsii.Kernel.get(this, "selfManagedActiveDirectoryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number throughputCapacity, final java.lang.String activeDirectoryId, final java.util.List<java.lang.String> aliases, final java.lang.Number automaticBackupRetentionDays, final java.lang.Object copyTagsToBackups, final java.lang.String dailyAutomaticBackupStartTime, final java.lang.String deploymentType, final java.lang.String preferredSubnetId, final java.lang.Object selfManagedActiveDirectoryConfiguration, final java.lang.String weeklyMaintenanceStartTime) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.throughputCapacity = java.util.Objects.requireNonNull(throughputCapacity, "throughputCapacity is required");
                this.activeDirectoryId = activeDirectoryId;
                this.aliases = aliases;
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                this.copyTagsToBackups = copyTagsToBackups;
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                this.deploymentType = deploymentType;
                this.preferredSubnetId = preferredSubnetId;
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            }

            @Override
            public final java.lang.Number getThroughputCapacity() {
                return this.throughputCapacity;
            }

            @Override
            public final java.lang.String getActiveDirectoryId() {
                return this.activeDirectoryId;
            }

            @Override
            public final java.util.List<java.lang.String> getAliases() {
                return this.aliases;
            }

            @Override
            public final java.lang.Number getAutomaticBackupRetentionDays() {
                return this.automaticBackupRetentionDays;
            }

            @Override
            public final java.lang.Object getCopyTagsToBackups() {
                return this.copyTagsToBackups;
            }

            @Override
            public final java.lang.String getDailyAutomaticBackupStartTime() {
                return this.dailyAutomaticBackupStartTime;
            }

            @Override
            public final java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            public final java.lang.String getPreferredSubnetId() {
                return this.preferredSubnetId;
            }

            @Override
            public final java.lang.Object getSelfManagedActiveDirectoryConfiguration() {
                return this.selfManagedActiveDirectoryConfiguration;
            }

            @Override
            public final java.lang.String getWeeklyMaintenanceStartTime() {
                return this.weeklyMaintenanceStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("throughputCapacity", om.valueToTree(this.getThroughputCapacity()));
                if (this.getActiveDirectoryId() != null) {
                    data.set("activeDirectoryId", om.valueToTree(this.getActiveDirectoryId()));
                }
                if (this.getAliases() != null) {
                    data.set("aliases", om.valueToTree(this.getAliases()));
                }
                if (this.getAutomaticBackupRetentionDays() != null) {
                    data.set("automaticBackupRetentionDays", om.valueToTree(this.getAutomaticBackupRetentionDays()));
                }
                if (this.getCopyTagsToBackups() != null) {
                    data.set("copyTagsToBackups", om.valueToTree(this.getCopyTagsToBackups()));
                }
                if (this.getDailyAutomaticBackupStartTime() != null) {
                    data.set("dailyAutomaticBackupStartTime", om.valueToTree(this.getDailyAutomaticBackupStartTime()));
                }
                if (this.getDeploymentType() != null) {
                    data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                }
                if (this.getPreferredSubnetId() != null) {
                    data.set("preferredSubnetId", om.valueToTree(this.getPreferredSubnetId()));
                }
                if (this.getSelfManagedActiveDirectoryConfiguration() != null) {
                    data.set("selfManagedActiveDirectoryConfiguration", om.valueToTree(this.getSelfManagedActiveDirectoryConfiguration()));
                }
                if (this.getWeeklyMaintenanceStartTime() != null) {
                    data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnFileSystem.WindowsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WindowsConfigurationProperty.Jsii$Proxy that = (WindowsConfigurationProperty.Jsii$Proxy) o;

                if (!throughputCapacity.equals(that.throughputCapacity)) return false;
                if (this.activeDirectoryId != null ? !this.activeDirectoryId.equals(that.activeDirectoryId) : that.activeDirectoryId != null) return false;
                if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
                if (this.automaticBackupRetentionDays != null ? !this.automaticBackupRetentionDays.equals(that.automaticBackupRetentionDays) : that.automaticBackupRetentionDays != null) return false;
                if (this.copyTagsToBackups != null ? !this.copyTagsToBackups.equals(that.copyTagsToBackups) : that.copyTagsToBackups != null) return false;
                if (this.dailyAutomaticBackupStartTime != null ? !this.dailyAutomaticBackupStartTime.equals(that.dailyAutomaticBackupStartTime) : that.dailyAutomaticBackupStartTime != null) return false;
                if (this.deploymentType != null ? !this.deploymentType.equals(that.deploymentType) : that.deploymentType != null) return false;
                if (this.preferredSubnetId != null ? !this.preferredSubnetId.equals(that.preferredSubnetId) : that.preferredSubnetId != null) return false;
                if (this.selfManagedActiveDirectoryConfiguration != null ? !this.selfManagedActiveDirectoryConfiguration.equals(that.selfManagedActiveDirectoryConfiguration) : that.selfManagedActiveDirectoryConfiguration != null) return false;
                return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.throughputCapacity.hashCode();
                result = 31 * result + (this.activeDirectoryId != null ? this.activeDirectoryId.hashCode() : 0);
                result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
                result = 31 * result + (this.automaticBackupRetentionDays != null ? this.automaticBackupRetentionDays.hashCode() : 0);
                result = 31 * result + (this.copyTagsToBackups != null ? this.copyTagsToBackups.hashCode() : 0);
                result = 31 * result + (this.dailyAutomaticBackupStartTime != null ? this.dailyAutomaticBackupStartTime.hashCode() : 0);
                result = 31 * result + (this.deploymentType != null ? this.deploymentType.hashCode() : 0);
                result = 31 * result + (this.preferredSubnetId != null ? this.preferredSubnetId.hashCode() : 0);
                result = 31 * result + (this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.hashCode() : 0);
                result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.CfnFileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.CfnFileSystem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.CfnFileSystemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.CfnFileSystemProps.Builder();
        }

        /**
         * `AWS::FSx::FileSystem.FileSystemType`.
         * <p>
         * @return {@code this}
         * @param fileSystemType `AWS::FSx::FileSystem.FileSystemType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemType(final java.lang.String fileSystemType) {
            this.props.fileSystemType(fileSystemType);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.SubnetIds`.
         * <p>
         * @return {@code this}
         * @param subnetIds `AWS::FSx::FileSystem.SubnetIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.BackupId`.
         * <p>
         * @return {@code this}
         * @param backupId `AWS::FSx::FileSystem.BackupId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(final java.lang.String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.KmsKeyId`.
         * <p>
         * @return {@code this}
         * @param kmsKeyId `AWS::FSx::FileSystem.KmsKeyId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.LustreConfiguration`.
         * <p>
         * @return {@code this}
         * @param lustreConfiguration `AWS::FSx::FileSystem.LustreConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(final software.amazon.awscdk.services.fsx.CfnFileSystem.LustreConfigurationProperty lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }
        /**
         * `AWS::FSx::FileSystem.LustreConfiguration`.
         * <p>
         * @return {@code this}
         * @param lustreConfiguration `AWS::FSx::FileSystem.LustreConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(final software.amazon.awscdk.IResolvable lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.SecurityGroupIds`.
         * <p>
         * @return {@code this}
         * @param securityGroupIds `AWS::FSx::FileSystem.SecurityGroupIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.StorageCapacity`.
         * <p>
         * @return {@code this}
         * @param storageCapacity `AWS::FSx::FileSystem.StorageCapacity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacity(final java.lang.Number storageCapacity) {
            this.props.storageCapacity(storageCapacity);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.StorageType`.
         * <p>
         * @return {@code this}
         * @param storageType `AWS::FSx::FileSystem.StorageType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props.storageType(storageType);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::FSx::FileSystem.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::FSx::FileSystem.WindowsConfiguration`.
         * <p>
         * @return {@code this}
         * @param windowsConfiguration `AWS::FSx::FileSystem.WindowsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowsConfiguration(final software.amazon.awscdk.services.fsx.CfnFileSystem.WindowsConfigurationProperty windowsConfiguration) {
            this.props.windowsConfiguration(windowsConfiguration);
            return this;
        }
        /**
         * `AWS::FSx::FileSystem.WindowsConfiguration`.
         * <p>
         * @return {@code this}
         * @param windowsConfiguration `AWS::FSx::FileSystem.WindowsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowsConfiguration(final software.amazon.awscdk.IResolvable windowsConfiguration) {
            this.props.windowsConfiguration(windowsConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.fsx.CfnFileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.CfnFileSystem build() {
            return new software.amazon.awscdk.services.fsx.CfnFileSystem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
