package software.amazon.awscdk.services.fsx;

/**
 * (experimental) The configuration for the Amazon FSx for Lustre file system.
 * <p>
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:31.270Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreConfiguration")
@software.amazon.jsii.Jsii.Proxy(LustreConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LustreConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The type of backing file system deployment used by FSx.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.LustreDeploymentType getDeploymentType();

    /**
     * (experimental) The path in Amazon S3 where the root of your Amazon FSx file system is exported.
     * <p>
     * The path must use the same
     * Amazon S3 bucket as specified in ImportPath. If you only specify a bucket name, such as s3://import-bucket, you
     * get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is
     * overwritten on export. If you provide a custom prefix in the export path, such as
     * s3://import-bucket/[custom-optional-prefix], Amazon FSx exports the contents of your file system to that export
     * prefix in the Amazon S3 bucket.
     * <p>
     * Default: s3://import-bucket/FSxLustre[creation-timestamp]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getExportPath() {
        return null;
    }

    /**
     * (experimental) For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
     * <p>
     * Allowed values are between 1 and 512,000.
     * <p>
     * Default: 1024
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getImportedFileChunkSizeMiB() {
        return null;
    }

    /**
     * (experimental) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system.
     * <p>
     * Must be of the format "s3://{bucketName}/optional-prefix" and cannot
     * exceed 900 characters.
     * <p>
     * Default: - no bucket is imported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getImportPath() {
        return null;
    }

    /**
     * (experimental) Required for the PERSISTENT_1 deployment type, describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB.
     * <p>
     * Valid values are 50, 100, 200.
     * <p>
     * Default: - no default, conditionally required for PERSISTENT_1 deployment type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPerUnitStorageThroughput() {
        return null;
    }

    /**
     * (experimental) The preferred day and time to perform weekly maintenance.
     * <p>
     * The first digit is the day of the week, starting at 1
     * for Monday, then the following are hours and minutes in the UTC time zone, 24 hour clock. For example: '2:20:30'
     * is Tuesdays at 20:30.
     * <p>
     * Default: - no preference
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.LustreMaintenanceTime getWeeklyMaintenanceStartTime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LustreConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LustreConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LustreConfiguration> {
        private software.amazon.awscdk.services.fsx.LustreDeploymentType deploymentType;
        private java.lang.String exportPath;
        private java.lang.Number importedFileChunkSizeMiB;
        private java.lang.String importPath;
        private java.lang.Number perUnitStorageThroughput;
        private software.amazon.awscdk.services.fsx.LustreMaintenanceTime weeklyMaintenanceStartTime;

        /**
         * Sets the value of {@link LustreConfiguration#getDeploymentType}
         * @param deploymentType The type of backing file system deployment used by FSx. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deploymentType(software.amazon.awscdk.services.fsx.LustreDeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getExportPath}
         * @param exportPath The path in Amazon S3 where the root of your Amazon FSx file system is exported.
         *                   The path must use the same
         *                   Amazon S3 bucket as specified in ImportPath. If you only specify a bucket name, such as s3://import-bucket, you
         *                   get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is
         *                   overwritten on export. If you provide a custom prefix in the export path, such as
         *                   s3://import-bucket/[custom-optional-prefix], Amazon FSx exports the contents of your file system to that export
         *                   prefix in the Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exportPath(java.lang.String exportPath) {
            this.exportPath = exportPath;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getImportedFileChunkSizeMiB}
         * @param importedFileChunkSizeMiB For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
         *                                 Allowed values are between 1 and 512,000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder importedFileChunkSizeMiB(java.lang.Number importedFileChunkSizeMiB) {
            this.importedFileChunkSizeMiB = importedFileChunkSizeMiB;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getImportPath}
         * @param importPath The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system.
         *                   Must be of the format "s3://{bucketName}/optional-prefix" and cannot
         *                   exceed 900 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder importPath(java.lang.String importPath) {
            this.importPath = importPath;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getPerUnitStorageThroughput}
         * @param perUnitStorageThroughput Required for the PERSISTENT_1 deployment type, describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB.
         *                                 Valid values are 50, 100, 200.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder perUnitStorageThroughput(java.lang.Number perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getWeeklyMaintenanceStartTime}
         * @param weeklyMaintenanceStartTime The preferred day and time to perform weekly maintenance.
         *                                   The first digit is the day of the week, starting at 1
         *                                   for Monday, then the following are hours and minutes in the UTC time zone, 24 hour clock. For example: '2:20:30'
         *                                   is Tuesdays at 20:30.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder weeklyMaintenanceStartTime(software.amazon.awscdk.services.fsx.LustreMaintenanceTime weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LustreConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LustreConfiguration build() {
            return new Jsii$Proxy(deploymentType, exportPath, importedFileChunkSizeMiB, importPath, perUnitStorageThroughput, weeklyMaintenanceStartTime);
        }
    }

    /**
     * An implementation for {@link LustreConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LustreConfiguration {
        private final software.amazon.awscdk.services.fsx.LustreDeploymentType deploymentType;
        private final java.lang.String exportPath;
        private final java.lang.Number importedFileChunkSizeMiB;
        private final java.lang.String importPath;
        private final java.lang.Number perUnitStorageThroughput;
        private final software.amazon.awscdk.services.fsx.LustreMaintenanceTime weeklyMaintenanceStartTime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.LustreDeploymentType.class));
            this.exportPath = software.amazon.jsii.Kernel.get(this, "exportPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.importedFileChunkSizeMiB = software.amazon.jsii.Kernel.get(this, "importedFileChunkSizeMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.importPath = software.amazon.jsii.Kernel.get(this, "importPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.perUnitStorageThroughput = software.amazon.jsii.Kernel.get(this, "perUnitStorageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.LustreMaintenanceTime.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.fsx.LustreDeploymentType deploymentType, final java.lang.String exportPath, final java.lang.Number importedFileChunkSizeMiB, final java.lang.String importPath, final java.lang.Number perUnitStorageThroughput, final software.amazon.awscdk.services.fsx.LustreMaintenanceTime weeklyMaintenanceStartTime) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentType = java.util.Objects.requireNonNull(deploymentType, "deploymentType is required");
            this.exportPath = exportPath;
            this.importedFileChunkSizeMiB = importedFileChunkSizeMiB;
            this.importPath = importPath;
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final software.amazon.awscdk.services.fsx.LustreDeploymentType getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final java.lang.String getExportPath() {
            return this.exportPath;
        }

        @Override
        public final java.lang.Number getImportedFileChunkSizeMiB() {
            return this.importedFileChunkSizeMiB;
        }

        @Override
        public final java.lang.String getImportPath() {
            return this.importPath;
        }

        @Override
        public final java.lang.Number getPerUnitStorageThroughput() {
            return this.perUnitStorageThroughput;
        }

        @Override
        public final software.amazon.awscdk.services.fsx.LustreMaintenanceTime getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
            if (this.getExportPath() != null) {
                data.set("exportPath", om.valueToTree(this.getExportPath()));
            }
            if (this.getImportedFileChunkSizeMiB() != null) {
                data.set("importedFileChunkSizeMiB", om.valueToTree(this.getImportedFileChunkSizeMiB()));
            }
            if (this.getImportPath() != null) {
                data.set("importPath", om.valueToTree(this.getImportPath()));
            }
            if (this.getPerUnitStorageThroughput() != null) {
                data.set("perUnitStorageThroughput", om.valueToTree(this.getPerUnitStorageThroughput()));
            }
            if (this.getWeeklyMaintenanceStartTime() != null) {
                data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.LustreConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LustreConfiguration.Jsii$Proxy that = (LustreConfiguration.Jsii$Proxy) o;

            if (!deploymentType.equals(that.deploymentType)) return false;
            if (this.exportPath != null ? !this.exportPath.equals(that.exportPath) : that.exportPath != null) return false;
            if (this.importedFileChunkSizeMiB != null ? !this.importedFileChunkSizeMiB.equals(that.importedFileChunkSizeMiB) : that.importedFileChunkSizeMiB != null) return false;
            if (this.importPath != null ? !this.importPath.equals(that.importPath) : that.importPath != null) return false;
            if (this.perUnitStorageThroughput != null ? !this.perUnitStorageThroughput.equals(that.perUnitStorageThroughput) : that.perUnitStorageThroughput != null) return false;
            return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentType.hashCode();
            result = 31 * result + (this.exportPath != null ? this.exportPath.hashCode() : 0);
            result = 31 * result + (this.importedFileChunkSizeMiB != null ? this.importedFileChunkSizeMiB.hashCode() : 0);
            result = 31 * result + (this.importPath != null ? this.importPath.hashCode() : 0);
            result = 31 * result + (this.perUnitStorageThroughput != null ? this.perUnitStorageThroughput.hashCode() : 0);
            result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
            return result;
        }
    }
}
