package software.amazon.awscdk.services.iam;

/**
 * (experimental) A PolicyDocument is a collection of statements.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:31.423Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.PolicyDocument")
public class PolicyDocument extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IResolvable {

    protected PolicyDocument(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyDocument(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PolicyDocument(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocumentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PolicyDocument() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Creates a new PolicyDocument based on the object provided.
     * <p>
     * This will accept an object created from the <code>.toJSON()</code> call
     * <p>
     * @param obj the PolicyDocument in object form. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument fromJson(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.PolicyDocument.class, "fromJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class), new Object[] { obj });
    }

    /**
     * (experimental) Adds a statement to the policy document.
     * <p>
     * @param statement the statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addStatements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        software.amazon.jsii.Kernel.call(this, "addStatements", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * (experimental) Produce the Token's value at resolution time.
     * <p>
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * (experimental) JSON-ify the document.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) Encode the policy document as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Validate that all policy statements in the policy document satisfies the requirements for any policy.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForAnyPolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForAnyPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Validate that all policy statements in the policy document satisfies the requirements for an identity-based policy.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForIdentityPolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForIdentityPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Validate that all policy statements in the policy document satisfies the requirements for a resource-based policy.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForResourcePolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForResourcePolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.
     * <p>
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Whether the policy document contains any statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsEmpty() {
        return software.amazon.jsii.Kernel.get(this, "isEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) The number of statements already added to this policy.
     * <p>
     * Can be used, for example, to generate unique "sid"s within the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number getStatementCount() {
        return software.amazon.jsii.Kernel.get(this, "statementCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iam.PolicyDocument}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.PolicyDocument> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder props;

        private Builder() {
        }

        /**
         * (experimental) Automatically assign Statement Ids to all statements.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param assignSids Automatically assign Statement Ids to all statements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assignSids(final java.lang.Boolean assignSids) {
            this.props().assignSids(assignSids);
            return this;
        }

        /**
         * (experimental) Initial statements to add to the policy document.
         * <p>
         * Default: - No statements
         * <p>
         * @return {@code this}
         * @param statements Initial statements to add to the policy document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder statements(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.PolicyDocument}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iam.PolicyDocument build() {
            return new software.amazon.awscdk.services.iam.PolicyDocument(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder();
            }
            return this.props;
        }
    }
}
