package software.amazon.awscdk.services.logs;

/**
 * (experimental) Define a CloudWatch Log Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:31.738Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogGroup")
public class LogGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.logs.ILogGroup {

    protected LogGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LogGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.LogGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LogGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing LogGroup given its ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param logGroupArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup fromLogGroupArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String logGroupArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.LogGroup.class, "fromLogGroupArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(logGroupArn, "logGroupArn is required") });
    }

    /**
     * (experimental) Import an existing LogGroup given its name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param logGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup fromLogGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String logGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.LogGroup.class, "fromLogGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(logGroupName, "logGroupName is required") });
    }

    /**
     * (experimental) Create a new Metric Filter on this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     * @param props Properties for creating the MetricFilter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.MetricFilter addMetricFilter(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.MetricFilterOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addMetricFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.MetricFilter.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create a new Log Stream for this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     * @param props Properties for creating the LogStream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogStream addStream(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.StreamOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogStream.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Create a new Log Stream for this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogStream addStream(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogStream.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Create a new Subscription Filter on this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     * @param props Properties for creating the SubscriptionFilter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SubscriptionFilter addSubscriptionFilter(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SubscriptionFilterOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addSubscriptionFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SubscriptionFilter.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Extract a metric from structured log events in the LogGroup.
     * <p>
     * Creates a MetricFilter on this LogGroup that will extract the value
     * of the indicated JSON field in all records where it occurs.
     * <p>
     * The metric will be available in CloudWatch Metrics under the
     * indicated namespace and name.
     * <p>
     * @return A Metric object representing the extracted metric
     * @param jsonField JSON field to extract (example: '$.myfield'). This parameter is required.
     * @param metricNamespace Namespace to emit the metric under. This parameter is required.
     * @param metricName Name to emit the metric under. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric extractMetric(final @org.jetbrains.annotations.NotNull java.lang.String jsonField, final @org.jetbrains.annotations.NotNull java.lang.String metricNamespace, final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "extractMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required"), java.util.Objects.requireNonNull(metricNamespace, "metricNamespace is required"), java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (experimental) Give the indicated permissions on this log group and all streams.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * (experimental) Give permissions to create and write to streams in this log group.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) The ARN of this log group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of this log group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName() {
        return software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.logs.LogGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.LogGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.logs.LogGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) The KMS Key to encrypt the log group with.
         * <p>
         * Default: - log group is encrypted with the default master key
         * <p>
         * @return {@code this}
         * @param encryptionKey The KMS Key to encrypt the log group with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * (experimental) Name of the log group.
         * <p>
         * Default: Automatically generated
         * <p>
         * @return {@code this}
         * @param logGroupName Name of the log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroupName(final java.lang.String logGroupName) {
            this.props().logGroupName(logGroupName);
            return this;
        }

        /**
         * (experimental) Determine the removal policy of this log group.
         * <p>
         * Normally you want to retain the log group so you can diagnose issues
         * from logs even after a deployment that no longer includes the log group.
         * In that case, use the normal date-based retention policy to age out your
         * logs.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @param removalPolicy Determine the removal policy of this log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) How long, in days, the log contents will be retained.
         * <p>
         * To retain all logs, set this value to RetentionDays.INFINITE.
         * <p>
         * Default: RetentionDays.TWO_YEARS
         * <p>
         * @return {@code this}
         * @param retention How long, in days, the log contents will be retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retention(final software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.props().retention(retention);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.LogGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.logs.LogGroup build() {
            return new software.amazon.awscdk.services.logs.LogGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.logs.LogGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.logs.LogGroupProps.Builder();
            }
            return this.props;
        }
    }
}
