package software.amazon.awscdk.services.rds;

/**
 * (experimental) The interface representing a database cluster (as opposed to instance) engine.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:32.018Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.IClusterEngine")
@software.amazon.jsii.Jsii.Proxy(IClusterEngine.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IClusterEngine extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.rds.IEngine {

    /**
     * (experimental) The application used by this engine to perform rotation for a multi-user scenario.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication();

    /**
     * (experimental) The application used by this engine to perform rotation for a single-user scenario.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication();

    /**
     * (experimental) The log types that are available with this engine type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSupportedLogTypes();

    /**
     * (experimental) Method called when the engine is used to create a new cluster.
     * <p>
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterEngineConfig bindToCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterEngineBindOptions options);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.rds.IClusterEngine.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The type of the engine, for example "mysql".
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEngineType() {
            return software.amazon.jsii.Kernel.get(this, "engineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The default name of the master database user if one was not provided explicitly.
         * <p>
         * The global default of 'admin' will be used if this is <code>undefined</code>.
         * Note that 'admin' is a reserved word in PostgreSQL and cannot be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable java.lang.String getDefaultUsername() {
            return software.amazon.jsii.Kernel.get(this, "defaultUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The family this engine belongs to, like "MYSQL", or "POSTGRESQL".
         * <p>
         * This property is used when creating a Database Proxy.
         * Most engines don't belong to any family
         * (and because of that, you can't create Database Proxies for their Clusters or Instances).
         * <p>
         * Default: - the engine doesn't belong to any family
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable java.lang.String getEngineFamily() {
            return software.amazon.jsii.Kernel.get(this, "engineFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The exact version of the engine that is used, for example "5.1.42".
         * <p>
         * Default: - use the default version for this engine type
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.EngineVersion getEngineVersion() {
            return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.EngineVersion.class));
        }

        /**
         * (experimental) The family to use for ParameterGroups using this engine.
         * <p>
         * This is usually equal to "<engineType><engineMajorVersion>",
         * but can sometimes be a variation of that.
         * You can pass this property when creating new ParameterGroup.
         * <p>
         * Default: - the ParameterGroup family is not known
         * (which means the major version of the engine is also not known)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable java.lang.String getParameterGroupFamily() {
            return software.amazon.jsii.Kernel.get(this, "parameterGroupFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The application used by this engine to perform rotation for a multi-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "multiUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * (experimental) The application used by this engine to perform rotation for a single-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "singleUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * (experimental) The log types that are available with this engine type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSupportedLogTypes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "supportedLogTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * (experimental) Method called when the engine is used to create a new cluster.
         * <p>
         * @param scope This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterEngineConfig bindToCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterEngineBindOptions options) {
            return software.amazon.jsii.Kernel.call(this, "bindToCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ClusterEngineConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }

    /**
     * Internal default implementation for {@link IClusterEngine}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IClusterEngine, software.amazon.awscdk.services.rds.IEngine.Jsii$Default {

        /**
         * (experimental) The type of the engine, for example "mysql".
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getEngineType() {
            return software.amazon.jsii.Kernel.get(this, "engineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The default name of the master database user if one was not provided explicitly.
         * <p>
         * The global default of 'admin' will be used if this is <code>undefined</code>.
         * Note that 'admin' is a reserved word in PostgreSQL and cannot be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultUsername() {
            return software.amazon.jsii.Kernel.get(this, "defaultUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The family this engine belongs to, like "MYSQL", or "POSTGRESQL".
         * <p>
         * This property is used when creating a Database Proxy.
         * Most engines don't belong to any family
         * (and because of that, you can't create Database Proxies for their Clusters or Instances).
         * <p>
         * Default: - the engine doesn't belong to any family
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEngineFamily() {
            return software.amazon.jsii.Kernel.get(this, "engineFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The exact version of the engine that is used, for example "5.1.42".
         * <p>
         * Default: - use the default version for this engine type
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.EngineVersion getEngineVersion() {
            return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.EngineVersion.class));
        }

        /**
         * (experimental) The family to use for ParameterGroups using this engine.
         * <p>
         * This is usually equal to "<engineType><engineMajorVersion>",
         * but can sometimes be a variation of that.
         * You can pass this property when creating new ParameterGroup.
         * <p>
         * Default: - the ParameterGroup family is not known
         * (which means the major version of the engine is also not known)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterGroupFamily() {
            return software.amazon.jsii.Kernel.get(this, "parameterGroupFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The application used by this engine to perform rotation for a multi-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "multiUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * (experimental) The application used by this engine to perform rotation for a single-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "singleUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * (experimental) The log types that are available with this engine type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSupportedLogTypes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "supportedLogTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * (experimental) Method called when the engine is used to create a new cluster.
         * <p>
         * @param scope This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterEngineConfig bindToCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterEngineBindOptions options) {
            return software.amazon.jsii.Kernel.call(this, "bindToCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ClusterEngineConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }
}
