package software.amazon.awscdk.services.rds;

/**
 * (experimental) The result of binding a `ProxyTarget` to a `DatabaseProxy`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:32.029Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ProxyTargetConfig")
@software.amazon.jsii.Jsii.Proxy(ProxyTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ProxyTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The engine family of the database instance or cluster this proxy connects with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getEngineFamily();

    /**
     * (experimental) The database clusters to which this proxy connects.
     * <p>
     * Either this or <code>dbInstances</code> will be set and the other <code>undefined</code>.
     * <p>
     * Default: - `undefined` if `dbInstances` is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.rds.IDatabaseCluster> getDbClusters() {
        return null;
    }

    /**
     * (experimental) The database instances to which this proxy connects.
     * <p>
     * Either this or <code>dbClusters</code> will be set and the other <code>undefined</code>.
     * <p>
     * Default: - `undefined` if `dbClusters` is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.rds.IDatabaseInstance> getDbInstances() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProxyTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProxyTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ProxyTargetConfig> {
        private java.lang.String engineFamily;
        private java.util.List<software.amazon.awscdk.services.rds.IDatabaseCluster> dbClusters;
        private java.util.List<software.amazon.awscdk.services.rds.IDatabaseInstance> dbInstances;

        /**
         * Sets the value of {@link ProxyTargetConfig#getEngineFamily}
         * @param engineFamily The engine family of the database instance or cluster this proxy connects with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder engineFamily(java.lang.String engineFamily) {
            this.engineFamily = engineFamily;
            return this;
        }

        /**
         * Sets the value of {@link ProxyTargetConfig#getDbClusters}
         * @param dbClusters The database clusters to which this proxy connects.
         *                   Either this or <code>dbInstances</code> will be set and the other <code>undefined</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dbClusters(java.util.List<? extends software.amazon.awscdk.services.rds.IDatabaseCluster> dbClusters) {
            this.dbClusters = (java.util.List<software.amazon.awscdk.services.rds.IDatabaseCluster>)dbClusters;
            return this;
        }

        /**
         * Sets the value of {@link ProxyTargetConfig#getDbInstances}
         * @param dbInstances The database instances to which this proxy connects.
         *                    Either this or <code>dbClusters</code> will be set and the other <code>undefined</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dbInstances(java.util.List<? extends software.amazon.awscdk.services.rds.IDatabaseInstance> dbInstances) {
            this.dbInstances = (java.util.List<software.amazon.awscdk.services.rds.IDatabaseInstance>)dbInstances;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProxyTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ProxyTargetConfig build() {
            return new Jsii$Proxy(engineFamily, dbClusters, dbInstances);
        }
    }

    /**
     * An implementation for {@link ProxyTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProxyTargetConfig {
        private final java.lang.String engineFamily;
        private final java.util.List<software.amazon.awscdk.services.rds.IDatabaseCluster> dbClusters;
        private final java.util.List<software.amazon.awscdk.services.rds.IDatabaseInstance> dbInstances;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engineFamily = software.amazon.jsii.Kernel.get(this, "engineFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusters = software.amazon.jsii.Kernel.get(this, "dbClusters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IDatabaseCluster.class)));
            this.dbInstances = software.amazon.jsii.Kernel.get(this, "dbInstances", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IDatabaseInstance.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String engineFamily, final java.util.List<? extends software.amazon.awscdk.services.rds.IDatabaseCluster> dbClusters, final java.util.List<? extends software.amazon.awscdk.services.rds.IDatabaseInstance> dbInstances) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engineFamily = java.util.Objects.requireNonNull(engineFamily, "engineFamily is required");
            this.dbClusters = (java.util.List<software.amazon.awscdk.services.rds.IDatabaseCluster>)dbClusters;
            this.dbInstances = (java.util.List<software.amazon.awscdk.services.rds.IDatabaseInstance>)dbInstances;
        }

        @Override
        public final java.lang.String getEngineFamily() {
            return this.engineFamily;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.rds.IDatabaseCluster> getDbClusters() {
            return this.dbClusters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.rds.IDatabaseInstance> getDbInstances() {
            return this.dbInstances;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engineFamily", om.valueToTree(this.getEngineFamily()));
            if (this.getDbClusters() != null) {
                data.set("dbClusters", om.valueToTree(this.getDbClusters()));
            }
            if (this.getDbInstances() != null) {
                data.set("dbInstances", om.valueToTree(this.getDbInstances()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ProxyTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProxyTargetConfig.Jsii$Proxy that = (ProxyTargetConfig.Jsii$Proxy) o;

            if (!engineFamily.equals(that.engineFamily)) return false;
            if (this.dbClusters != null ? !this.dbClusters.equals(that.dbClusters) : that.dbClusters != null) return false;
            return this.dbInstances != null ? this.dbInstances.equals(that.dbInstances) : that.dbInstances == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engineFamily.hashCode();
            result = 31 * result + (this.dbClusters != null ? this.dbClusters.hashCode() : 0);
            result = 31 * result + (this.dbInstances != null ? this.dbInstances.hashCode() : 0);
            return result;
        }
    }
}
