package software.amazon.awscdk.services.rds;

/**
 * (experimental) Properties that describe an existing cluster instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:32.030Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ServerlessClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(ServerlessClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ServerlessClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Identifier for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

    /**
     * (experimental) Cluster endpoint address.
     * <p>
     * Default: - no endpoint address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpointAddress() {
        return null;
    }

    /**
     * (experimental) The database port.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) Reader endpoint address.
     * <p>
     * Default: - no reader address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getReaderEndpointAddress() {
        return null;
    }

    /**
     * (experimental) The secret attached to the database cluster.
     * <p>
     * Default: - no secret
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return null;
    }

    /**
     * (experimental) The security groups of the database cluster.
     * <p>
     * Default: - no security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServerlessClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerlessClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ServerlessClusterAttributes> {
        private java.lang.String clusterIdentifier;
        private java.lang.String clusterEndpointAddress;
        private java.lang.Number port;
        private java.lang.String readerEndpointAddress;
        private software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getClusterIdentifier}
         * @param clusterIdentifier Identifier for the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getClusterEndpointAddress}
         * @param clusterEndpointAddress Cluster endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterEndpointAddress(java.lang.String clusterEndpointAddress) {
            this.clusterEndpointAddress = clusterEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getPort}
         * @param port The database port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getReaderEndpointAddress}
         * @param readerEndpointAddress Reader endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readerEndpointAddress(java.lang.String readerEndpointAddress) {
            this.readerEndpointAddress = readerEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getSecret}
         * @param secret The secret attached to the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getSecurityGroups}
         * @param securityGroups The security groups of the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerlessClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ServerlessClusterAttributes build() {
            return new Jsii$Proxy(clusterIdentifier, clusterEndpointAddress, port, readerEndpointAddress, secret, securityGroups);
        }
    }

    /**
     * An implementation for {@link ServerlessClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessClusterAttributes {
        private final java.lang.String clusterIdentifier;
        private final java.lang.String clusterEndpointAddress;
        private final java.lang.Number port;
        private final java.lang.String readerEndpointAddress;
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpointAddress = software.amazon.jsii.Kernel.get(this, "clusterEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readerEndpointAddress = software.amazon.jsii.Kernel.get(this, "readerEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String clusterIdentifier, final java.lang.String clusterEndpointAddress, final java.lang.Number port, final java.lang.String readerEndpointAddress, final software.amazon.awscdk.services.secretsmanager.ISecret secret, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIdentifier = java.util.Objects.requireNonNull(clusterIdentifier, "clusterIdentifier is required");
            this.clusterEndpointAddress = clusterEndpointAddress;
            this.port = port;
            this.readerEndpointAddress = readerEndpointAddress;
            this.secret = secret;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getClusterEndpointAddress() {
            return this.clusterEndpointAddress;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getReaderEndpointAddress() {
            return this.readerEndpointAddress;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            if (this.getClusterEndpointAddress() != null) {
                data.set("clusterEndpointAddress", om.valueToTree(this.getClusterEndpointAddress()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getReaderEndpointAddress() != null) {
                data.set("readerEndpointAddress", om.valueToTree(this.getReaderEndpointAddress()));
            }
            if (this.getSecret() != null) {
                data.set("secret", om.valueToTree(this.getSecret()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ServerlessClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerlessClusterAttributes.Jsii$Proxy that = (ServerlessClusterAttributes.Jsii$Proxy) o;

            if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
            if (this.clusterEndpointAddress != null ? !this.clusterEndpointAddress.equals(that.clusterEndpointAddress) : that.clusterEndpointAddress != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.readerEndpointAddress != null ? !this.readerEndpointAddress.equals(that.readerEndpointAddress) : that.readerEndpointAddress != null) return false;
            if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterIdentifier.hashCode();
            result = 31 * result + (this.clusterEndpointAddress != null ? this.clusterEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.readerEndpointAddress != null ? this.readerEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
