package software.amazon.awscdk.services.ses.actions;

/**
 * (experimental) Saves the received message to an Amazon S3 bucket and, optionally, publishes a notification to Amazon SNS.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:48.074Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.S3")
public class S3 extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ses.IReceiptRuleAction {

    protected S3(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.S3Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Returns the receipt rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ses.actions.S3}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.actions.S3> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ses.actions.S3Props.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ses.actions.S3Props.Builder();
        }

        /**
         * (experimental) The S3 bucket that incoming email will be saved to.
         * <p>
         * @return {@code this}
         * @param bucket The S3 bucket that incoming email will be saved to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * (experimental) The master key that SES should use to encrypt your emails before saving them to the S3 bucket.
         * <p>
         * Default: no encryption
         * <p>
         * @return {@code this}
         * @param kmsKey The master key that SES should use to encrypt your emails before saving them to the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * (experimental) The key prefix of the S3 bucket.
         * <p>
         * Default: no prefix
         * <p>
         * @return {@code this}
         * @param objectKeyPrefix The key prefix of the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder objectKeyPrefix(final java.lang.String objectKeyPrefix) {
            this.props.objectKeyPrefix(objectKeyPrefix);
            return this;
        }

        /**
         * (experimental) The SNS topic to notify when the S3 action is taken.
         * <p>
         * Default: no notification
         * <p>
         * @return {@code this}
         * @param topic The SNS topic to notify when the S3 action is taken. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.actions.S3}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ses.actions.S3 build() {
            return new software.amazon.awscdk.services.ses.actions.S3(
                this.props.build()
            );
        }
    }
}
