package software.amazon.awscdk.services.ssm;

/**
 * (experimental) Properties needed to create a new SSM Parameter.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:48.126Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.ParameterOptions")
@software.amazon.jsii.Jsii.Proxy(ParameterOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ParameterOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A regular expression used to validate the parameter value.
     * <p>
     * For example, for String types with values restricted to
     * numbers, you can specify the following: <code>^\d+$</code>
     * <p>
     * Default: no validation is performed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllowedPattern() {
        return null;
    }

    /**
     * (experimental) Information about the parameter that you want to add to the system.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) The name of the parameter.
     * <p>
     * Default: - a name will be generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getParameterName() {
        return null;
    }

    /**
     * (experimental) Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
     * <p>
     * This is only required only if <code>parameterName</code> is a token, which means we
     * are unable to detect if the name is simple or "path-like" for the purpose
     * of rendering SSM parameter ARNs.
     * <p>
     * If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
     * undefined) since the name generated by AWS CloudFormation is always a
     * simple name.
     * <p>
     * Default: - auto-detect based on `parameterName`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSimpleName() {
        return null;
    }

    /**
     * (experimental) The tier of the string parameter.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterTier getTier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ParameterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ParameterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ParameterOptions> {
        private java.lang.String allowedPattern;
        private java.lang.String description;
        private java.lang.String parameterName;
        private java.lang.Boolean simpleName;
        private software.amazon.awscdk.services.ssm.ParameterTier tier;

        /**
         * Sets the value of {@link ParameterOptions#getAllowedPattern}
         * @param allowedPattern A regular expression used to validate the parameter value.
         *                       For example, for String types with values restricted to
         *                       numbers, you can specify the following: <code>^\d+$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowedPattern(java.lang.String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        /**
         * Sets the value of {@link ParameterOptions#getDescription}
         * @param description Information about the parameter that you want to add to the system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ParameterOptions#getParameterName}
         * @param parameterName The name of the parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterName(java.lang.String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        /**
         * Sets the value of {@link ParameterOptions#getSimpleName}
         * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
         *                   This is only required only if <code>parameterName</code> is a token, which means we
         *                   are unable to detect if the name is simple or "path-like" for the purpose
         *                   of rendering SSM parameter ARNs.
         *                   <p>
         *                   If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         *                   undefined) since the name generated by AWS CloudFormation is always a
         *                   simple name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder simpleName(java.lang.Boolean simpleName) {
            this.simpleName = simpleName;
            return this;
        }

        /**
         * Sets the value of {@link ParameterOptions#getTier}
         * @param tier The tier of the string parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tier(software.amazon.awscdk.services.ssm.ParameterTier tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ParameterOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ParameterOptions build() {
            return new Jsii$Proxy(allowedPattern, description, parameterName, simpleName, tier);
        }
    }

    /**
     * An implementation for {@link ParameterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterOptions {
        private final java.lang.String allowedPattern;
        private final java.lang.String description;
        private final java.lang.String parameterName;
        private final java.lang.Boolean simpleName;
        private final software.amazon.awscdk.services.ssm.ParameterTier tier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedPattern = software.amazon.jsii.Kernel.get(this, "allowedPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.simpleName = software.amazon.jsii.Kernel.get(this, "simpleName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.ParameterTier.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String allowedPattern, final java.lang.String description, final java.lang.String parameterName, final java.lang.Boolean simpleName, final software.amazon.awscdk.services.ssm.ParameterTier tier) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedPattern = allowedPattern;
            this.description = description;
            this.parameterName = parameterName;
            this.simpleName = simpleName;
            this.tier = tier;
        }

        @Override
        public final java.lang.String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final java.lang.Boolean getSimpleName() {
            return this.simpleName;
        }

        @Override
        public final software.amazon.awscdk.services.ssm.ParameterTier getTier() {
            return this.tier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedPattern() != null) {
                data.set("allowedPattern", om.valueToTree(this.getAllowedPattern()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getParameterName() != null) {
                data.set("parameterName", om.valueToTree(this.getParameterName()));
            }
            if (this.getSimpleName() != null) {
                data.set("simpleName", om.valueToTree(this.getSimpleName()));
            }
            if (this.getTier() != null) {
                data.set("tier", om.valueToTree(this.getTier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.ParameterOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ParameterOptions.Jsii$Proxy that = (ParameterOptions.Jsii$Proxy) o;

            if (this.allowedPattern != null ? !this.allowedPattern.equals(that.allowedPattern) : that.allowedPattern != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.parameterName != null ? !this.parameterName.equals(that.parameterName) : that.parameterName != null) return false;
            if (this.simpleName != null ? !this.simpleName.equals(that.simpleName) : that.simpleName != null) return false;
            return this.tier != null ? this.tier.equals(that.tier) : that.tier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedPattern != null ? this.allowedPattern.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.parameterName != null ? this.parameterName.hashCode() : 0);
            result = 31 * result + (this.simpleName != null ? this.simpleName.hashCode() : 0);
            result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
            return result;
        }
    }
}
