package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Location of query result along with S3 bucket configuration.
 * <p>
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_ResultConfiguration.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T09:55:52.956Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ResultConfiguration")
@software.amazon.jsii.Jsii.Proxy(ResultConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ResultConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Encryption option used if enabled in S3.
     * <p>
     * Default: - SSE_S3 encrpytion is enabled with default encryption key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration getEncryptionConfiguration() {
        return null;
    }

    /**
     * (experimental) S3 path of query results.
     * <p>
     * Default: - Query Result Location set in Athena settings for this workgroup
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * s3:}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Location getOutputLocation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResultConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResultConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ResultConfiguration> {
        private software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration encryptionConfiguration;
        private software.amazon.awscdk.services.s3.Location outputLocation;

        /**
         * Sets the value of {@link ResultConfiguration#getEncryptionConfiguration}
         * @param encryptionConfiguration Encryption option used if enabled in S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link ResultConfiguration#getOutputLocation}
         * @param outputLocation S3 path of query results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputLocation(software.amazon.awscdk.services.s3.Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResultConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ResultConfiguration build() {
            return new Jsii$Proxy(encryptionConfiguration, outputLocation);
        }
    }

    /**
     * An implementation for {@link ResultConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResultConfiguration {
        private final software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration encryptionConfiguration;
        private final software.amazon.awscdk.services.s3.Location outputLocation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration.class));
            this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration encryptionConfiguration, final software.amazon.awscdk.services.s3.Location outputLocation) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionConfiguration = encryptionConfiguration;
            this.outputLocation = outputLocation;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Location getOutputLocation() {
            return this.outputLocation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getOutputLocation() != null) {
                data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.ResultConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResultConfiguration.Jsii$Proxy that = (ResultConfiguration.Jsii$Proxy) o;

            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            return this.outputLocation != null ? this.outputLocation.equals(that.outputLocation) : that.outputLocation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0;
            result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
            return result;
        }
    }
}
