/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.apigateway.ApiKeySourceType;
import software.amazon.awscdk.services.apigateway.CorsOptions;
import software.amazon.awscdk.services.apigateway.DomainNameOptions;
import software.amazon.awscdk.services.apigateway.EndpointConfiguration;
import software.amazon.awscdk.services.apigateway.EndpointType;
import software.amazon.awscdk.services.apigateway.IResource;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.Method;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.Model;
import software.amazon.awscdk.services.apigateway.ModelOptions;
import software.amazon.awscdk.services.apigateway.RequestValidator;
import software.amazon.awscdk.services.apigateway.RequestValidatorOptions;
import software.amazon.awscdk.services.apigateway.RestApiAttributes;
import software.amazon.awscdk.services.apigateway.RestApiBase;
import software.amazon.awscdk.services.apigateway.RestApiProps;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigateway.RestApi")
public class RestApi
extends RestApiBase {
    protected RestApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RestApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public RestApi(@NotNull Construct scope, @NotNull String id, @Nullable RestApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public RestApi(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IRestApi fromRestApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull RestApiAttributes attrs) {
        return (IRestApi)JsiiObject.jsiiStaticCall(RestApi.class, (String)"fromRestApiAttributes", (NativeType)NativeType.forClass(IRestApi.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IRestApi fromRestApiId(@NotNull Construct scope, @NotNull String id, @NotNull String restApiId) {
        return (IRestApi)JsiiObject.jsiiStaticCall(RestApi.class, (String)"fromRestApiId", (NativeType)NativeType.forClass(IRestApi.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(restApiId, "restApiId is required")});
    }

    @NotNull
    public Model addModel(@NotNull String id, @NotNull ModelOptions props) {
        return (Model)Kernel.call((Object)this, (String)"addModel", (NativeType)NativeType.forClass(Model.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public RequestValidator addRequestValidator(@NotNull String id, @NotNull RequestValidatorOptions props) {
        return (RequestValidator)Kernel.call((Object)this, (String)"addRequestValidator", (NativeType)NativeType.forClass(RequestValidator.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public List<Method> getMethods() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"methods", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Method.class))));
    }

    @Override
    @NotNull
    public String getRestApiId() {
        return (String)Kernel.get((Object)this, (String)"restApiId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRestApiRootResourceId() {
        return (String)Kernel.get((Object)this, (String)"restApiRootResourceId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IResource getRoot() {
        return (IResource)Kernel.get((Object)this, (String)"root", (NativeType)NativeType.forClass(IResource.class));
    }

    @NotNull
    public String getUrl() {
        return (String)Kernel.get((Object)this, (String)"url", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<RestApi> {
        private final Construct scope;
        private final String id;
        private RestApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder defaultCorsPreflightOptions(CorsOptions defaultCorsPreflightOptions) {
            this.props().defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        public Builder defaultIntegration(Integration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        public Builder defaultMethodOptions(MethodOptions defaultMethodOptions) {
            this.props().defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        public Builder cloudWatchRole(Boolean cloudWatchRole) {
            this.props().cloudWatchRole(cloudWatchRole);
            return this;
        }

        public Builder cloudWatchRoleRemovalPolicy(RemovalPolicy cloudWatchRoleRemovalPolicy) {
            this.props().cloudWatchRoleRemovalPolicy(cloudWatchRoleRemovalPolicy);
            return this;
        }

        public Builder deploy(Boolean deploy) {
            this.props().deploy(deploy);
            return this;
        }

        public Builder deployOptions(StageOptions deployOptions) {
            this.props().deployOptions(deployOptions);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }

        public Builder domainName(DomainNameOptions domainName) {
            this.props().domainName(domainName);
            return this;
        }

        public Builder endpointExportName(String endpointExportName) {
            this.props().endpointExportName(endpointExportName);
            return this;
        }

        public Builder endpointTypes(List<? extends EndpointType> endpointTypes) {
            this.props().endpointTypes(endpointTypes);
            return this;
        }

        public Builder failOnWarnings(Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.props().policy(policy);
            return this;
        }

        public Builder restApiName(String restApiName) {
            this.props().restApiName(restApiName);
            return this;
        }

        public Builder retainDeployments(Boolean retainDeployments) {
            this.props().retainDeployments(retainDeployments);
            return this;
        }

        public Builder apiKeySourceType(ApiKeySourceType apiKeySourceType) {
            this.props().apiKeySourceType(apiKeySourceType);
            return this;
        }

        public Builder binaryMediaTypes(List<String> binaryMediaTypes) {
            this.props().binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        public Builder cloneFrom(IRestApi cloneFrom) {
            this.props().cloneFrom(cloneFrom);
            return this;
        }

        public Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.props().endpointConfiguration(endpointConfiguration);
            return this;
        }

        public Builder minCompressionSize(Size minCompressionSize) {
            this.props().minCompressionSize(minCompressionSize);
            return this;
        }

        @Deprecated
        public Builder minimumCompressionSize(Number minimumCompressionSize) {
            this.props().minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        public RestApi build() {
            return new RestApi(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private RestApiProps.Builder props() {
            if (this.props == null) {
                this.props = new RestApiProps.Builder();
            }
            return this.props;
        }
    }
}

