/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront.origins;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudfront.IOrigin;
import software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity;
import software.amazon.awscdk.services.cloudfront.OriginBindConfig;
import software.amazon.awscdk.services.cloudfront.OriginBindOptions;
import software.amazon.awscdk.services.cloudfront.origins.S3OriginProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudfront_origins.S3Origin")
public class S3Origin
extends JsiiObject
implements IOrigin {
    protected S3Origin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Origin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3Origin(@NotNull IBucket bucket, @Nullable S3OriginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), props});
    }

    public S3Origin(@NotNull IBucket bucket) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required")});
    }

    @Override
    @NotNull
    public OriginBindConfig bind(@NotNull Construct scope, @NotNull OriginBindOptions options) {
        return (OriginBindConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(OriginBindConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(options, "options is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3Origin> {
        private final IBucket bucket;
        private S3OriginProps.Builder props;

        public static Builder create(IBucket bucket) {
            return new Builder(bucket);
        }

        private Builder(IBucket bucket) {
            this.bucket = bucket;
        }

        public Builder connectionAttempts(Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        public Builder originId(String originId) {
            this.props().originId(originId);
            return this;
        }

        public Builder originShieldEnabled(Boolean originShieldEnabled) {
            this.props().originShieldEnabled(originShieldEnabled);
            return this;
        }

        public Builder originShieldRegion(String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        public Builder originPath(String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        public Builder originAccessIdentity(IOriginAccessIdentity originAccessIdentity) {
            this.props().originAccessIdentity(originAccessIdentity);
            return this;
        }

        public S3Origin build() {
            return new S3Origin(this.bucket, this.props != null ? this.props.build() : null);
        }

        private S3OriginProps.Builder props() {
            if (this.props == null) {
                this.props = new S3OriginProps.Builder();
            }
            return this.props;
        }
    }
}

