/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dlm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.dlm.CfnLifecyclePolicy;
import software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy")
public class CfnLifecyclePolicy
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLifecyclePolicy.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnLifecyclePolicy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLifecyclePolicy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLifecyclePolicy(@NotNull Construct scope, @NotNull String id, @Nullable CfnLifecyclePolicyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnLifecyclePolicy(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutionRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"executionRoleArn", (Object)value);
    }

    @Nullable
    public Object getPolicyDetails() {
        return Kernel.get((Object)this, (String)"policyDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPolicyDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"policyDetails", (Object)value);
    }

    public void setPolicyDetails(@Nullable PolicyDetailsProperty value) {
        Kernel.set((Object)this, (String)"policyDetails", (Object)value);
    }

    @Nullable
    public String getState() {
        return (String)Kernel.get((Object)this, (String)"state", (NativeType)NativeType.forClass(String.class));
    }

    public void setState(@Nullable String value) {
        Kernel.set((Object)this, (String)"state", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnLifecyclePolicy> {
        private final Construct scope;
        private final String id;
        private CfnLifecyclePolicyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props().executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder policyDetails(IResolvable policyDetails) {
            this.props().policyDetails(policyDetails);
            return this;
        }

        public Builder policyDetails(PolicyDetailsProperty policyDetails) {
            this.props().policyDetails(policyDetails);
            return this;
        }

        public Builder state(String state) {
            this.props().state(state);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnLifecyclePolicy build() {
            return new CfnLifecyclePolicy(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnLifecyclePolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnLifecyclePolicyProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ShareRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ShareRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getTargetAccounts() {
            return null;
        }

        @Nullable
        default public Number getUnshareInterval() {
            return null;
        }

        @Nullable
        default public String getUnshareIntervalUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ShareRuleProperty> {
            List<String> targetAccounts;
            Number unshareInterval;
            String unshareIntervalUnit;

            public Builder targetAccounts(List<String> targetAccounts) {
                this.targetAccounts = targetAccounts;
                return this;
            }

            public Builder unshareInterval(Number unshareInterval) {
                this.unshareInterval = unshareInterval;
                return this;
            }

            public Builder unshareIntervalUnit(String unshareIntervalUnit) {
                this.unshareIntervalUnit = unshareIntervalUnit;
                return this;
            }

            public ShareRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArchiveRule() {
            return null;
        }

        @Nullable
        default public Object getCopyTags() {
            return null;
        }

        @Nullable
        default public Object getCreateRule() {
            return null;
        }

        @Nullable
        default public Object getCrossRegionCopyRules() {
            return null;
        }

        @Nullable
        default public Object getDeprecateRule() {
            return null;
        }

        @Nullable
        default public Object getFastRestoreRule() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getRetainRule() {
            return null;
        }

        @Nullable
        default public Object getShareRules() {
            return null;
        }

        @Nullable
        default public Object getTagsToAdd() {
            return null;
        }

        @Nullable
        default public Object getVariableTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleProperty> {
            Object archiveRule;
            Object copyTags;
            Object createRule;
            Object crossRegionCopyRules;
            Object deprecateRule;
            Object fastRestoreRule;
            String name;
            Object retainRule;
            Object shareRules;
            Object tagsToAdd;
            Object variableTags;

            public Builder archiveRule(IResolvable archiveRule) {
                this.archiveRule = archiveRule;
                return this;
            }

            public Builder archiveRule(ArchiveRuleProperty archiveRule) {
                this.archiveRule = archiveRule;
                return this;
            }

            public Builder copyTags(Boolean copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            public Builder copyTags(IResolvable copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            public Builder createRule(IResolvable createRule) {
                this.createRule = createRule;
                return this;
            }

            public Builder createRule(CreateRuleProperty createRule) {
                this.createRule = createRule;
                return this;
            }

            public Builder crossRegionCopyRules(IResolvable crossRegionCopyRules) {
                this.crossRegionCopyRules = crossRegionCopyRules;
                return this;
            }

            public Builder crossRegionCopyRules(List<? extends Object> crossRegionCopyRules) {
                this.crossRegionCopyRules = crossRegionCopyRules;
                return this;
            }

            public Builder deprecateRule(IResolvable deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            public Builder deprecateRule(DeprecateRuleProperty deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            public Builder fastRestoreRule(IResolvable fastRestoreRule) {
                this.fastRestoreRule = fastRestoreRule;
                return this;
            }

            public Builder fastRestoreRule(FastRestoreRuleProperty fastRestoreRule) {
                this.fastRestoreRule = fastRestoreRule;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder retainRule(IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public Builder retainRule(RetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public Builder shareRules(IResolvable shareRules) {
                this.shareRules = shareRules;
                return this;
            }

            public Builder shareRules(List<? extends Object> shareRules) {
                this.shareRules = shareRules;
                return this;
            }

            public Builder tagsToAdd(IResolvable tagsToAdd) {
                this.tagsToAdd = tagsToAdd;
                return this;
            }

            public Builder tagsToAdd(List<? extends Object> tagsToAdd) {
                this.tagsToAdd = tagsToAdd;
                return this;
            }

            public Builder variableTags(IResolvable variableTags) {
                this.variableTags = variableTags;
                return this;
            }

            public Builder variableTags(List<? extends Object> variableTags) {
                this.variableTags = variableTags;
                return this;
            }

            public ScheduleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetentionArchiveTierProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetentionArchiveTierProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        @Nullable
        default public Number getInterval() {
            return null;
        }

        @Nullable
        default public String getIntervalUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetentionArchiveTierProperty> {
            Number count;
            Number interval;
            String intervalUnit;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder intervalUnit(String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public RetentionArchiveTierProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetainRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetainRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        @Nullable
        default public Number getInterval() {
            return null;
        }

        @Nullable
        default public String getIntervalUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetainRuleProperty> {
            Number count;
            Number interval;
            String intervalUnit;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder intervalUnit(String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public RetainRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.PolicyDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PolicyDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getEventSource() {
            return null;
        }

        @Nullable
        default public Object getParameters() {
            return null;
        }

        @Nullable
        default public String getPolicyType() {
            return null;
        }

        @Nullable
        default public List<String> getResourceLocations() {
            return null;
        }

        @Nullable
        default public List<String> getResourceTypes() {
            return null;
        }

        @Nullable
        default public Object getSchedules() {
            return null;
        }

        @Nullable
        default public Object getTargetTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PolicyDetailsProperty> {
            Object actions;
            Object eventSource;
            Object parameters;
            String policyType;
            List<String> resourceLocations;
            List<String> resourceTypes;
            Object schedules;
            Object targetTags;

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder eventSource(IResolvable eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            public Builder eventSource(EventSourceProperty eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(ParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder policyType(String policyType) {
                this.policyType = policyType;
                return this;
            }

            public Builder resourceLocations(List<String> resourceLocations) {
                this.resourceLocations = resourceLocations;
                return this;
            }

            public Builder resourceTypes(List<String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            public Builder schedules(IResolvable schedules) {
                this.schedules = schedules;
                return this;
            }

            public Builder schedules(List<? extends Object> schedules) {
                this.schedules = schedules;
                return this;
            }

            public Builder targetTags(IResolvable targetTags) {
                this.targetTags = targetTags;
                return this;
            }

            public Builder targetTags(List<? extends Object> targetTags) {
                this.targetTags = targetTags;
                return this;
            }

            public PolicyDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getExcludeBootVolume() {
            return null;
        }

        @Nullable
        default public Object getExcludeDataVolumeTags() {
            return null;
        }

        @Nullable
        default public Object getNoReboot() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParametersProperty> {
            Object excludeBootVolume;
            Object excludeDataVolumeTags;
            Object noReboot;

            public Builder excludeBootVolume(Boolean excludeBootVolume) {
                this.excludeBootVolume = excludeBootVolume;
                return this;
            }

            public Builder excludeBootVolume(IResolvable excludeBootVolume) {
                this.excludeBootVolume = excludeBootVolume;
                return this;
            }

            public Builder excludeDataVolumeTags(IResolvable excludeDataVolumeTags) {
                this.excludeDataVolumeTags = excludeDataVolumeTags;
                return this;
            }

            public Builder excludeDataVolumeTags(List<? extends Object> excludeDataVolumeTags) {
                this.excludeDataVolumeTags = excludeDataVolumeTags;
                return this;
            }

            public Builder noReboot(Boolean noReboot) {
                this.noReboot = noReboot;
                return this;
            }

            public Builder noReboot(IResolvable noReboot) {
                this.noReboot = noReboot;
                return this;
            }

            public ParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.FastRestoreRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FastRestoreRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAvailabilityZones() {
            return null;
        }

        @Nullable
        default public Number getCount() {
            return null;
        }

        @Nullable
        default public Number getInterval() {
            return null;
        }

        @Nullable
        default public String getIntervalUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FastRestoreRuleProperty> {
            List<String> availabilityZones;
            Number count;
            Number interval;
            String intervalUnit;

            public Builder availabilityZones(List<String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder intervalUnit(String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public FastRestoreRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventSourceProperty> {
            String type;
            Object parameters;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(EventParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            public EventSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getEventType();

        @NotNull
        public List<String> getSnapshotOwner();

        @Nullable
        default public String getDescriptionRegex() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventParametersProperty> {
            String eventType;
            List<String> snapshotOwner;
            String descriptionRegex;

            public Builder eventType(String eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder snapshotOwner(List<String> snapshotOwner) {
                this.snapshotOwner = snapshotOwner;
                return this;
            }

            public Builder descriptionRegex(String descriptionRegex) {
                this.descriptionRegex = descriptionRegex;
                return this;
            }

            public EventParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEncrypted();

        @Nullable
        default public String getCmkArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            Object encrypted;
            String cmkArn;

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder cmkArn(String cmkArn) {
                this.cmkArn = cmkArn;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.DeprecateRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeprecateRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        @Nullable
        default public Number getInterval() {
            return null;
        }

        @Nullable
        default public String getIntervalUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeprecateRuleProperty> {
            Number count;
            Number interval;
            String intervalUnit;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder intervalUnit(String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public DeprecateRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CrossRegionCopyRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEncrypted();

        @Nullable
        default public String getCmkArn() {
            return null;
        }

        @Nullable
        default public Object getCopyTags() {
            return null;
        }

        @Nullable
        default public Object getDeprecateRule() {
            return null;
        }

        @Nullable
        default public Object getRetainRule() {
            return null;
        }

        @Nullable
        default public String getTarget() {
            return null;
        }

        @Nullable
        default public String getTargetRegion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CrossRegionCopyRuleProperty> {
            Object encrypted;
            String cmkArn;
            Object copyTags;
            Object deprecateRule;
            Object retainRule;
            String target;
            String targetRegion;

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder cmkArn(String cmkArn) {
                this.cmkArn = cmkArn;
                return this;
            }

            public Builder copyTags(Boolean copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            public Builder copyTags(IResolvable copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            public Builder deprecateRule(IResolvable deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            public Builder deprecateRule(CrossRegionCopyDeprecateRuleProperty deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            public Builder retainRule(IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public Builder retainRule(CrossRegionCopyRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public Builder targetRegion(String targetRegion) {
                this.targetRegion = targetRegion;
                return this;
            }

            public CrossRegionCopyRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CrossRegionCopyRetainRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInterval();

        @NotNull
        public String getIntervalUnit();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CrossRegionCopyRetainRuleProperty> {
            Number interval;
            String intervalUnit;

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder intervalUnit(String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public CrossRegionCopyRetainRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CrossRegionCopyDeprecateRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInterval();

        @NotNull
        public String getIntervalUnit();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CrossRegionCopyDeprecateRuleProperty> {
            Number interval;
            String intervalUnit;

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder intervalUnit(String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public CrossRegionCopyDeprecateRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CrossRegionCopyActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEncryptionConfiguration();

        @NotNull
        public String getTarget();

        @Nullable
        default public Object getRetainRule() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CrossRegionCopyActionProperty> {
            Object encryptionConfiguration;
            String target;
            Object retainRule;

            public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public Builder retainRule(IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public Builder retainRule(CrossRegionCopyRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public CrossRegionCopyActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CreateRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CreateRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCronExpression() {
            return null;
        }

        @Nullable
        default public Number getInterval() {
            return null;
        }

        @Nullable
        default public String getIntervalUnit() {
            return null;
        }

        @Nullable
        default public String getLocation() {
            return null;
        }

        @Nullable
        default public List<String> getTimes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CreateRuleProperty> {
            String cronExpression;
            Number interval;
            String intervalUnit;
            String location;
            List<String> times;

            public Builder cronExpression(String cronExpression) {
                this.cronExpression = cronExpression;
                return this;
            }

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder intervalUnit(String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder times(List<String> times) {
                this.times = times;
                return this;
            }

            public CreateRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ArchiveRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArchiveRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRetainRule();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArchiveRuleProperty> {
            Object retainRule;

            public Builder retainRule(IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public Builder retainRule(ArchiveRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            public ArchiveRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ArchiveRetainRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArchiveRetainRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRetentionArchiveTier();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArchiveRetainRuleProperty> {
            Object retentionArchiveTier;

            public Builder retentionArchiveTier(IResolvable retentionArchiveTier) {
                this.retentionArchiveTier = retentionArchiveTier;
                return this;
            }

            public Builder retentionArchiveTier(RetentionArchiveTierProperty retentionArchiveTier) {
                this.retentionArchiveTier = retentionArchiveTier;
                return this;
            }

            public ArchiveRetainRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCrossRegionCopy();

        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionProperty> {
            Object crossRegionCopy;
            String name;

            public Builder crossRegionCopy(IResolvable crossRegionCopy) {
                this.crossRegionCopy = crossRegionCopy;
                return this;
            }

            public Builder crossRegionCopy(List<? extends Object> crossRegionCopy) {
                this.crossRegionCopy = crossRegionCopy;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public ActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

