/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.applicationautoscaling.Schedule;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.FargatePlatformVersion;
import software.amazon.awscdk.services.ecs.FargateTaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.RuntimePlatform;
import software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions;
import software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions;
import software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskProps;
import software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBase;
import software.amazon.awscdk.services.events.targets.EcsTask;
import software.amazon.awscdk.services.events.targets.Tag;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecs_patterns.ScheduledFargateTask")
public class ScheduledFargateTask
extends ScheduledTaskBase {
    protected ScheduledFargateTask(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledFargateTask(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ScheduledFargateTask(@NotNull Construct scope, @NotNull String id, @NotNull ScheduledFargateTaskProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public EcsTask getTask() {
        return (EcsTask)Kernel.get((Object)((Object)this), (String)"task", (NativeType)NativeType.forClass(EcsTask.class));
    }

    @NotNull
    public FargateTaskDefinition getTaskDefinition() {
        return (FargateTaskDefinition)Kernel.get((Object)((Object)this), (String)"taskDefinition", (NativeType)NativeType.forClass(FargateTaskDefinition.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ScheduledFargateTask> {
        private final Construct scope;
        private final String id;
        private final ScheduledFargateTaskProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ScheduledFargateTaskProps.Builder();
        }

        public Builder schedule(Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder desiredTaskCount(Number desiredTaskCount) {
            this.props.desiredTaskCount(desiredTaskCount);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder tags(List<? extends Tag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder platformVersion(FargatePlatformVersion platformVersion) {
            this.props.platformVersion(platformVersion);
            return this;
        }

        public Builder runtimePlatform(RuntimePlatform runtimePlatform) {
            this.props.runtimePlatform(runtimePlatform);
            return this;
        }

        public Builder taskDefinition(FargateTaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder scheduledFargateTaskDefinitionOptions(ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions) {
            this.props.scheduledFargateTaskDefinitionOptions(scheduledFargateTaskDefinitionOptions);
            return this;
        }

        public Builder scheduledFargateTaskImageOptions(ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions) {
            this.props.scheduledFargateTaskImageOptions(scheduledFargateTaskImageOptions);
            return this;
        }

        public ScheduledFargateTask build() {
            return new ScheduledFargateTask(this.scope, this.id, this.props.build());
        }
    }
}

