/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.efs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.efs.CfnAccessPoint;
import software.amazon.awscdk.services.efs.CfnAccessPointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnAccessPoint")
public class CfnAccessPoint
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAccessPoint.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAccessPoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessPoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAccessPoint(@NotNull Construct scope, @NotNull String id, @NotNull CfnAccessPointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAccessPointId() {
        return (String)Kernel.get((Object)this, (String)"attrAccessPointId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getFileSystemId() {
        return (String)Kernel.get((Object)this, (String)"fileSystemId", (NativeType)NativeType.forClass(String.class));
    }

    public void setFileSystemId(@NotNull String value) {
        Kernel.set((Object)this, (String)"fileSystemId", (Object)Objects.requireNonNull(value, "fileSystemId is required"));
    }

    @Nullable
    public List<AccessPointTagProperty> getAccessPointTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"accessPointTagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AccessPointTagProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAccessPointTagsRaw(@Nullable List<AccessPointTagProperty> value) {
        Kernel.set((Object)this, (String)"accessPointTagsRaw", value);
    }

    @Nullable
    public String getClientToken() {
        return (String)Kernel.get((Object)this, (String)"clientToken", (NativeType)NativeType.forClass(String.class));
    }

    public void setClientToken(@Nullable String value) {
        Kernel.set((Object)this, (String)"clientToken", (Object)value);
    }

    @Nullable
    public Object getPosixUser() {
        return Kernel.get((Object)this, (String)"posixUser", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPosixUser(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"posixUser", (Object)value);
    }

    public void setPosixUser(@Nullable PosixUserProperty value) {
        Kernel.set((Object)this, (String)"posixUser", (Object)value);
    }

    @Nullable
    public Object getRootDirectory() {
        return Kernel.get((Object)this, (String)"rootDirectory", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRootDirectory(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"rootDirectory", (Object)value);
    }

    public void setRootDirectory(@Nullable RootDirectoryProperty value) {
        Kernel.set((Object)this, (String)"rootDirectory", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnAccessPoint.AccessPointTagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessPointTagProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessPointTagProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public AccessPointTagProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAccessPoint> {
        private final Construct scope;
        private final String id;
        private final CfnAccessPointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAccessPointProps.Builder();
        }

        public Builder fileSystemId(String fileSystemId) {
            this.props.fileSystemId(fileSystemId);
            return this;
        }

        public Builder accessPointTags(List<? extends AccessPointTagProperty> accessPointTags) {
            this.props.accessPointTags(accessPointTags);
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.props.clientToken(clientToken);
            return this;
        }

        public Builder posixUser(IResolvable posixUser) {
            this.props.posixUser(posixUser);
            return this;
        }

        public Builder posixUser(PosixUserProperty posixUser) {
            this.props.posixUser(posixUser);
            return this;
        }

        public Builder rootDirectory(IResolvable rootDirectory) {
            this.props.rootDirectory(rootDirectory);
            return this;
        }

        public Builder rootDirectory(RootDirectoryProperty rootDirectory) {
            this.props.rootDirectory(rootDirectory);
            return this;
        }

        public CfnAccessPoint build() {
            return new CfnAccessPoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnAccessPoint.RootDirectoryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RootDirectoryProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCreationInfo() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RootDirectoryProperty> {
            Object creationInfo;
            String path;

            public Builder creationInfo(IResolvable creationInfo) {
                this.creationInfo = creationInfo;
                return this;
            }

            public Builder creationInfo(CreationInfoProperty creationInfo) {
                this.creationInfo = creationInfo;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public RootDirectoryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnAccessPoint.PosixUserProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PosixUserProperty
    extends JsiiSerializable {
        @NotNull
        public String getGid();

        @NotNull
        public String getUid();

        @Nullable
        default public List<String> getSecondaryGids() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PosixUserProperty> {
            String gid;
            String uid;
            List<String> secondaryGids;

            public Builder gid(String gid) {
                this.gid = gid;
                return this;
            }

            public Builder uid(String uid) {
                this.uid = uid;
                return this;
            }

            public Builder secondaryGids(List<String> secondaryGids) {
                this.secondaryGids = secondaryGids;
                return this;
            }

            public PosixUserProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnAccessPoint.CreationInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CreationInfoProperty
    extends JsiiSerializable {
        @NotNull
        public String getOwnerGid();

        @NotNull
        public String getOwnerUid();

        @NotNull
        public String getPermissions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CreationInfoProperty> {
            String ownerGid;
            String ownerUid;
            String permissions;

            public Builder ownerGid(String ownerGid) {
                this.ownerGid = ownerGid;
                return this;
            }

            public Builder ownerUid(String ownerUid) {
                this.ownerUid = ownerUid;
                return this;
            }

            public Builder permissions(String permissions) {
                this.permissions = permissions;
                return this;
            }

            public CreationInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

