/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.glue.CfnDatabase;
import software.amazon.awscdk.services.glue.CfnDatabaseProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnDatabase")
public class CfnDatabase
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDatabase.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDatabase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDatabase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDatabase(@NotNull Construct scope, @NotNull String id, @NotNull CfnDatabaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getCatalogId() {
        return (String)Kernel.get((Object)this, (String)"catalogId", (NativeType)NativeType.forClass(String.class));
    }

    public void setCatalogId(@NotNull String value) {
        Kernel.set((Object)this, (String)"catalogId", (Object)Objects.requireNonNull(value, "catalogId is required"));
    }

    @NotNull
    public Object getDatabaseInput() {
        return Kernel.get((Object)this, (String)"databaseInput", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDatabaseInput(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"databaseInput", (Object)Objects.requireNonNull(value, "databaseInput is required"));
    }

    public void setDatabaseInput(@NotNull DatabaseInputProperty value) {
        Kernel.set((Object)this, (String)"databaseInput", (Object)Objects.requireNonNull(value, "databaseInput is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDatabase> {
        private final Construct scope;
        private final String id;
        private final CfnDatabaseProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDatabaseProps.Builder();
        }

        public Builder catalogId(String catalogId) {
            this.props.catalogId(catalogId);
            return this;
        }

        public Builder databaseInput(IResolvable databaseInput) {
            this.props.databaseInput(databaseInput);
            return this;
        }

        public Builder databaseInput(DatabaseInputProperty databaseInput) {
            this.props.databaseInput(databaseInput);
            return this;
        }

        public CfnDatabase build() {
            return new CfnDatabase(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnDatabase.PrincipalPrivilegesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrincipalPrivilegesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getPermissions() {
            return null;
        }

        @Nullable
        default public Object getPrincipal() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrincipalPrivilegesProperty> {
            List<String> permissions;
            Object principal;

            public Builder permissions(List<String> permissions) {
                this.permissions = permissions;
                return this;
            }

            public Builder principal(IResolvable principal) {
                this.principal = principal;
                return this;
            }

            public Builder principal(DataLakePrincipalProperty principal) {
                this.principal = principal;
                return this;
            }

            public PrincipalPrivilegesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnDatabase.FederatedDatabaseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FederatedDatabaseProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public String getIdentifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FederatedDatabaseProperty> {
            String connectionName;
            String identifier;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder identifier(String identifier) {
                this.identifier = identifier;
                return this;
            }

            public FederatedDatabaseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnDatabase.DatabaseInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCreateTableDefaultPermissions() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getFederatedDatabase() {
            return null;
        }

        @Nullable
        default public String getLocationUri() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getParameters() {
            return null;
        }

        @Nullable
        default public Object getTargetDatabase() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseInputProperty> {
            Object createTableDefaultPermissions;
            String description;
            Object federatedDatabase;
            String locationUri;
            String name;
            Object parameters;
            Object targetDatabase;

            public Builder createTableDefaultPermissions(IResolvable createTableDefaultPermissions) {
                this.createTableDefaultPermissions = createTableDefaultPermissions;
                return this;
            }

            public Builder createTableDefaultPermissions(List<? extends Object> createTableDefaultPermissions) {
                this.createTableDefaultPermissions = createTableDefaultPermissions;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder federatedDatabase(IResolvable federatedDatabase) {
                this.federatedDatabase = federatedDatabase;
                return this;
            }

            public Builder federatedDatabase(FederatedDatabaseProperty federatedDatabase) {
                this.federatedDatabase = federatedDatabase;
                return this;
            }

            public Builder locationUri(String locationUri) {
                this.locationUri = locationUri;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder parameters(Object parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder targetDatabase(IResolvable targetDatabase) {
                this.targetDatabase = targetDatabase;
                return this;
            }

            public Builder targetDatabase(DatabaseIdentifierProperty targetDatabase) {
                this.targetDatabase = targetDatabase;
                return this;
            }

            public DatabaseInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnDatabase.DatabaseIdentifierProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseIdentifierProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getRegion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseIdentifierProperty> {
            String catalogId;
            String databaseName;
            String region;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public DatabaseIdentifierProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnDatabase.DataLakePrincipalProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataLakePrincipalProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDataLakePrincipalIdentifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataLakePrincipalProperty> {
            String dataLakePrincipalIdentifier;

            public Builder dataLakePrincipalIdentifier(String dataLakePrincipalIdentifier) {
                this.dataLakePrincipalIdentifier = dataLakePrincipalIdentifier;
                return this;
            }

            public DataLakePrincipalProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

