/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kms;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.Alias;
import software.amazon.awscdk.services.kms.CfnKey;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.kms.KeyLookupOptions;
import software.amazon.awscdk.services.kms.KeyProps;
import software.amazon.awscdk.services.kms.KeySpec;
import software.amazon.awscdk.services.kms.KeyUsage;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kms.Key")
public class Key
extends Resource
implements IKey {
    protected Key(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Key(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Key(@NotNull Construct scope, @NotNull String id, @Nullable KeyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Key(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IKey fromCfnKey(@NotNull CfnKey cfnKey) {
        return (IKey)JsiiObject.jsiiStaticCall(Key.class, (String)"fromCfnKey", (NativeType)NativeType.forClass(IKey.class), (Object[])new Object[]{Objects.requireNonNull(cfnKey, "cfnKey is required")});
    }

    @NotNull
    public static IKey fromKeyArn(@NotNull Construct scope, @NotNull String id, @NotNull String keyArn) {
        return (IKey)JsiiObject.jsiiStaticCall(Key.class, (String)"fromKeyArn", (NativeType)NativeType.forClass(IKey.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(keyArn, "keyArn is required")});
    }

    @NotNull
    public static IKey fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull KeyLookupOptions options) {
        return (IKey)JsiiObject.jsiiStaticCall(Key.class, (String)"fromLookup", (NativeType)NativeType.forClass(IKey.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public Alias addAlias(@NotNull String aliasName) {
        return (Alias)Kernel.call((Object)this, (String)"addAlias", (NativeType)NativeType.forClass(Alias.class), (Object[])new Object[]{Objects.requireNonNull(aliasName, "aliasName is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement, @Nullable Boolean allowNoOp) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required"), allowNoOp});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @NotNull
    public Grant grantAdmin(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantAdmin", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantDecrypt(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantDecrypt", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantEncrypt(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantEncrypt", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantEncryptDecrypt(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantEncryptDecrypt", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantGenerateMac(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantGenerateMac", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantVerifyMac(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantVerifyMac", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public String getKeyArn() {
        return (String)Kernel.get((Object)this, (String)"keyArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getKeyId() {
        return (String)Kernel.get((Object)this, (String)"keyId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Boolean getTrustAccountIdentities() {
        return (Boolean)Kernel.get((Object)this, (String)"trustAccountIdentities", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    protected PolicyDocument getPolicy() {
        return (PolicyDocument)Kernel.get((Object)this, (String)"policy", (NativeType)NativeType.forClass(PolicyDocument.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Key> {
        private final Construct scope;
        private final String id;
        private KeyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder admins(List<? extends IPrincipal> admins) {
            this.props().admins(admins);
            return this;
        }

        public Builder alias(String alias) {
            this.props().alias(alias);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        public Builder enableKeyRotation(Boolean enableKeyRotation) {
            this.props().enableKeyRotation(enableKeyRotation);
            return this;
        }

        public Builder keySpec(KeySpec keySpec) {
            this.props().keySpec(keySpec);
            return this;
        }

        public Builder keyUsage(KeyUsage keyUsage) {
            this.props().keyUsage(keyUsage);
            return this;
        }

        public Builder pendingWindow(Duration pendingWindow) {
            this.props().pendingWindow(pendingWindow);
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.props().policy(policy);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Key build() {
            return new Key(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private KeyProps.Builder props() {
            if (this.props == null) {
                this.props = new KeyProps.Builder();
            }
            return this.props;
        }
    }
}

